/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.xdja.pushsdk.utils.LogHelper;

public class PushTestRecorde {
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1XRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;
    public String strNetworkType = null;

    private void addNetWorkRecorde(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null) {
            LogHelper.writeFileToSD("PushSdkLog", "--Network Type  = " + networkInfo.getTypeName());
            LogHelper.writeFileToSD("PushSdkLog", "--Network State = " + networkInfo.getState());
            LogHelper.writeFileToSD("PushSdkLog", "--Network Subtype = " + this.getNetworkType(networkInfo));
        }
    }

    public String getNetworkType(NetworkInfo networkInfo) {
        if (networkInfo != null && networkInfo.isConnected()) {
            if (networkInfo.getType() == 1) {
                this.strNetworkType = "WIFI";
            } else if (networkInfo.getType() == 0) {
                String _strSubTypeName = networkInfo.getSubtypeName();
                int networkType = networkInfo.getSubtype();
                switch (networkType) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        this.strNetworkType = "2G";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        this.strNetworkType = "3G";
                        break;
                    }
                    case 13: {
                        this.strNetworkType = "4G";
                        break;
                    }
                    default: {
                        this.strNetworkType = _strSubTypeName.equalsIgnoreCase("TD-SCDMA") || _strSubTypeName.equalsIgnoreCase("WCDMA") || _strSubTypeName.equalsIgnoreCase("CDMA2000") ? "3G" : _strSubTypeName;
                    }
                }
            }
        }
        return this.strNetworkType;
    }

    public static void addPushConnectionStateRecord(String state, Context context) {
        LogHelper.writeFileToSD("PushSdkLog", "--PushConnection State = " + state);
        if (context != null) {
            PushTestRecorde recorde = new PushTestRecorde();
            recorde.addNetWorkRecorde(context);
        }
    }

    public static void addPushConnectionStateRecord(String state) {
        PushTestRecorde.addPushConnectionStateRecord(state, null);
    }
}

