/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.org.eclipse.paho.client.mqttv3;

import com.xdja.org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttException;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttMessage;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ClientComms;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import com.xdja.org.eclipse.paho.client.mqttv3.util.Strings;
import java.io.UnsupportedEncodingException;

public class MqttTopic {
    public static final String TOPIC_LEVEL_SEPARATOR = "/";
    public static final String MULTI_LEVEL_WILDCARD = "#";
    public static final String SINGLE_LEVEL_WILDCARD = "+";
    public static final String MULTI_LEVEL_WILDCARD_PATTERN = "/#";
    public static final String TOPIC_WILDCARDS = "#+";
    private static final int MIN_TOPIC_LEN = 1;
    private static final int MAX_TOPIC_LEN = 65535;
    private static final char NUL = '\u0000';
    private ClientComms comms;
    private String name;

    public MqttTopic(String name, ClientComms comms) {
        this.comms = comms;
        this.name = name;
    }

    public MqttDeliveryToken publish(byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        return this.publish(message);
    }

    public MqttDeliveryToken publish(MqttMessage message) throws MqttException, MqttPersistenceException {
        MqttDeliveryToken token = new MqttDeliveryToken(this.comms.getClient().getClientId());
        token.setMessage(message);
        this.comms.sendNoWait(this.createPublish(message), token);
        token.internalTok.waitUntilSent();
        return token;
    }

    public String getName() {
        return this.name;
    }

    private MqttPublish createPublish(MqttMessage message) {
        return new MqttPublish(this.getName(), message);
    }

    public String toString() {
        return this.getName();
    }

    public static void validate(String topicString, boolean wildcardAllowed) {
        int topicLen = 0;
        try {
            topicLen = topicString.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        if (topicLen < 1 || topicLen > 65535) {
            throw new IllegalArgumentException(String.format("Invalid topic length, should be in range[%d, %d]!", new Integer(1), new Integer(65535)));
        }
        if (wildcardAllowed) {
            if (Strings.equalsAny(topicString, new String[]{MULTI_LEVEL_WILDCARD, SINGLE_LEVEL_WILDCARD})) {
                return;
            }
            if (Strings.countMatches(topicString, MULTI_LEVEL_WILDCARD) > 1 || topicString.contains(MULTI_LEVEL_WILDCARD) && !topicString.endsWith(MULTI_LEVEL_WILDCARD_PATTERN)) {
                throw new IllegalArgumentException("Invalid usage of multi-level wildcard in topic string: " + topicString);
            }
            MqttTopic.validateSingleLevelWildcard(topicString);
            return;
        }
        if (Strings.containsAny((CharSequence)topicString, TOPIC_WILDCARDS)) {
            throw new IllegalArgumentException("The topic name MUST NOT contain any wildcard characters (#+)");
        }
    }

    private static void validateSingleLevelWildcard(String topicString) {
        char singleLevelWildcardChar = SINGLE_LEVEL_WILDCARD.charAt(0);
        char topicLevelSeparatorChar = TOPIC_LEVEL_SEPARATOR.charAt(0);
        char[] chars = topicString.toCharArray();
        int length = chars.length;
        char prev = '\u0000';
        char next = '\u0000';
        for (int i = 0; i < length; ++i) {
            prev = i - 1 >= 0 ? chars[i - 1] : (char)'\u0000';
            char c = next = i + 1 < length ? chars[i + 1] : (char)'\u0000';
            if (chars[i] != singleLevelWildcardChar || (prev == topicLevelSeparatorChar || prev == '\u0000') && (next == topicLevelSeparatorChar || next == '\u0000')) continue;
            throw new IllegalArgumentException(String.format("Invalid usage of single-level wildcard in topic string '%s'!", topicString));
        }
    }
}

