/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.org.eclipse.paho.client.mqttv3.logging;

import com.xdja.org.eclipse.paho.client.mqttv3.logging.Logger;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.MemoryHandler;

public class JSR47Logger
implements Logger {
    private java.util.logging.Logger julLogger = null;
    private ResourceBundle logMessageCatalog = null;
    private ResourceBundle traceMessageCatalog = null;
    private String catalogID = null;
    private String resourceName = null;
    private String loggerName = null;

    @Override
    public void initialise(ResourceBundle logMsgCatalog, String loggerID, String resourceContext) {
        this.traceMessageCatalog = this.logMessageCatalog;
        this.resourceName = resourceContext;
        this.loggerName = loggerID;
        this.julLogger = java.util.logging.Logger.getLogger(this.loggerName);
        this.logMessageCatalog = logMsgCatalog;
        this.traceMessageCatalog = logMsgCatalog;
        this.catalogID = this.logMessageCatalog.getString("0");
    }

    @Override
    public void setResourceName(String logContext) {
        this.resourceName = logContext;
    }

    @Override
    public boolean isLoggable(int level) {
        return false;
    }

    @Override
    public void severe(String sourceClass, String sourceMethod, String msg) {
    }

    @Override
    public void severe(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
    }

    @Override
    public void severe(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
    }

    @Override
    public void warning(String sourceClass, String sourceMethod, String msg) {
    }

    @Override
    public void warning(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
    }

    @Override
    public void warning(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
    }

    @Override
    public void info(String sourceClass, String sourceMethod, String msg) {
    }

    @Override
    public void info(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
    }

    @Override
    public void info(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
    }

    @Override
    public void config(String sourceClass, String sourceMethod, String msg) {
    }

    @Override
    public void config(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
    }

    @Override
    public void config(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
    }

    @Override
    public void log(int level, String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
    }

    @Override
    public void fine(String sourceClass, String sourceMethod, String msg) {
    }

    @Override
    public void fine(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
    }

    @Override
    public void fine(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {
    }

    @Override
    public void finer(String sourceClass, String sourceMethod, String msg) {
    }

    @Override
    public void finer(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
    }

    @Override
    public void finer(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {
    }

    @Override
    public void finest(String sourceClass, String sourceMethod, String msg) {
    }

    @Override
    public void finest(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
    }

    @Override
    public void finest(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {
    }

    @Override
    public void trace(int level, String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {
    }

    private String getResourceMessage(ResourceBundle messageCatalog, String msg) {
        String message;
        try {
            message = messageCatalog.getString(msg);
        }
        catch (MissingResourceException e) {
            message = msg;
        }
        return message;
    }

    private void logToJsr47(Level julLevel, String sourceClass, String sourceMethod, String catalogName, ResourceBundle messageCatalog, String msg, Object[] inserts, Throwable thrown) {
        String formattedWithArgs = msg;
        if (msg.indexOf("=====") == -1) {
            formattedWithArgs = MessageFormat.format(this.getResourceMessage(messageCatalog, msg), inserts);
        }
        LogRecord logRecord = new LogRecord(julLevel, this.resourceName + ": " + formattedWithArgs);
        logRecord.setSourceClassName(sourceClass);
        logRecord.setSourceMethodName(sourceMethod);
        logRecord.setLoggerName(this.loggerName);
        if (null != thrown) {
            logRecord.setThrown(thrown);
        }
        this.julLogger.log(logRecord);
    }

    private Level mapJULLevel(int level) {
        Level julLevel = null;
        switch (level) {
            case 1: {
                julLevel = Level.SEVERE;
                break;
            }
            case 2: {
                julLevel = Level.WARNING;
                break;
            }
            case 3: {
                julLevel = Level.INFO;
                break;
            }
            case 4: {
                julLevel = Level.CONFIG;
                break;
            }
            case 5: {
                julLevel = Level.FINE;
                break;
            }
            case 6: {
                julLevel = Level.FINER;
                break;
            }
            case 7: {
                julLevel = Level.FINEST;
                break;
            }
        }
        return julLevel;
    }

    @Override
    public String formatMessage(String msg, Object[] inserts) {
        String formatString;
        try {
            formatString = this.logMessageCatalog.getString(msg);
        }
        catch (MissingResourceException e) {
            formatString = msg;
        }
        return formatString;
    }

    @Override
    public void dumpTrace() {
        JSR47Logger.dumpMemoryTrace47(this.julLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dumpMemoryTrace47(java.util.logging.Logger logger) {
        MemoryHandler mHand = null;
        if (logger != null) {
            Handler[] handlers = logger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                if (!(handlers[i] instanceof MemoryHandler)) continue;
                Handler handler = handlers[i];
                synchronized (handler) {
                    mHand = (MemoryHandler)handlers[i];
                    mHand.push();
                    return;
                }
            }
            JSR47Logger.dumpMemoryTrace47(logger.getParent());
        }
    }
}

