/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import com.xdja.google.gson.Gson;
import com.xdja.google.gson.JsonIOException;
import com.xdja.google.gson.JsonSyntaxException;
import com.xdja.google.gson.reflect.TypeToken;
import com.xdja.pushsdk.bean.DelMsgBean;
import com.xdja.pushsdk.bean.DelMsgResult;
import com.xdja.pushsdk.bean.Mosquitto;
import com.xdja.pushsdk.bean.MsgBean;
import com.xdja.pushsdk.bean.NotifyBean;
import com.xdja.pushsdk.bean.RequestMsgBean;
import com.xdja.pushsdk.bean.RequestMsgResult;
import com.xdja.pushsdk.http.HttpHelper;
import com.xdja.pushsdk.http.HttpManager;
import com.xdja.pushsdk.http.bean.ErrorBean;
import com.xdja.pushsdk.http.bean.RequestBean;
import com.xdja.pushsdk.http.bean.ResponseBean;
import com.xdja.pushsdk.http.bean.ServiceException;
import com.xdja.pushsdk.npc.npcs.util.NPCManager;
import com.xdja.pushsdk.task.ProcessNotifyManager;
import com.xdja.pushsdk.utils.ErrCode;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.Result;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class PushClientManager {
    private static ProcessNotifyManager processNotifyManager;
    public static LinkedBlockingQueue<NotifyBean> notifyLinkedBlockingQueue;
    private static PushClientManager clientManager;
    private static HandlerThread handlerThread;
    private static Handler taskhandler;
    private final String REQUEST_CLIENTID = "clientid";
    private final String REQUEST_TESTTIME = "testtime";
    private final String REQUEST_MOSADDR = "mosaddr";
    private final String REQUEST_EXT = "ext";
    private final String REQUEST_GETSERV = "getserv";
    private final String REQUEST_TOPIC = "topic";
    private final String REQUEST_STARTID = "startid";
    private final String REQUEST_SIZE = "size";
    private final String REQUEST_VERSION = "version";
    private final String REQUEST_GETPSMSG = "getpsmsg";
    private final String REQUEST_DELPSMSG = "delpsmsg";
    private final String REQUEST_DEFAULT_ID = "1";
    private final int REQUEST_DEFAULT_TESTTIME = 0;
    private final int REQUEST_DEFAULT_MOSADDR = 1;
    private final String MOSQUITTO_TYPE_IN = "1";
    private final int REQUEST_DEFAULT_VERSION = 1;
    private final int HIS_MSG_ID = 10000000;
    private static final String HANDLER_THREAD_NAME = "xdja_push_sdk";
    private Context context;

    private PushClientManager(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PushClientManager getInstance(Context ctx) {
        Class<PushClientManager> clazz = PushClientManager.class;
        synchronized (PushClientManager.class) {
            if (clientManager == null) {
                clientManager = new PushClientManager(ctx);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return clientManager;
        }
    }

    public boolean isHaveAvailableNPC(Context context) {
        return NPCManager.isNPCService(context);
    }

    public Result<Mosquitto> getNpsInfo(Context context, String clientId) {
        Result<Mosquitto> result = new Result();
        String url = HttpManager.getRequestMosquittoRequestUrl(context);
        String type = HttpManager.getRequestMosquittoRequestType(context);
        RequestBean requestBean = this.getRequestBean(clientId, type);
        HttpHelper httpHelper = new HttpHelper(url);
        try {
            ResponseBean reponse = httpHelper.request(requestBean);
            result = this.parseMosquittoResponse(reponse);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            result.setResultCode(e.getErrCode());
            result.setMessage(e.getMessage());
        }
        catch (JsonIOException e) {
            e.printStackTrace();
            result.setResultCode(33566733);
            result.setMessage(ErrCode.getErrMsg(33566733));
        }
        return result;
    }

    private RequestBean getRequestBean(String clientId, String type) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("clientid", clientId);
        if ("1".equals(type)) {
            LogHelper.getHelper().d("\u83b7\u53d6\u5185\u7f51mos");
            HashMap<String, Integer> mapExt = new HashMap<String, Integer>();
            mapExt.put("testtime", 0);
            mapExt.put("mosaddr", 1);
            hashMap.put("ext", mapExt);
        }
        RequestBean requestBean = new RequestBean();
        requestBean.setId("1");
        requestBean.setMethod("getserv");
        requestBean.setParams(hashMap);
        return requestBean;
    }

    private RequestBean getMsgRequestBean(RequestMsgBean requestMsgBean) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("topic", requestMsgBean.getUser());
        hashMap.put("startid", requestMsgBean.getMsgStartId());
        hashMap.put("size", requestMsgBean.getMsgSize());
        HashMap<String, Integer> mapExt = new HashMap<String, Integer>();
        mapExt.put("testtime", 0);
        mapExt.put("version", 1);
        hashMap.put("ext", mapExt);
        RequestBean requestBean = new RequestBean();
        requestBean.setId("1");
        requestBean.setMethod("getpsmsg");
        requestBean.setParams(hashMap);
        return requestBean;
    }

    private RequestBean getDelMsgRequestBean(DelMsgBean delMsgBean) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("topic", delMsgBean.getUser());
        hashMap.put("startid", delMsgBean.getMsgStartId());
        hashMap.put("size", delMsgBean.getDelMsgSize());
        RequestBean requestBean = new RequestBean();
        requestBean.setId("1");
        requestBean.setMethod("delpsmsg");
        requestBean.setParams(hashMap);
        return requestBean;
    }

    private Result<Mosquitto> parseMosquittoResponse(ResponseBean reponse) throws JsonSyntaxException {
        Result<Mosquitto> result = new Result<Mosquitto>();
        if (reponse == null || reponse.getResult() == null && reponse.getError() == null) {
            result.setResultCode(33566731);
            result.setMessage(ErrCode.getErrMsg(33566731));
            return result;
        }
        Object resultObject = reponse.getResult();
        if (resultObject != null) {
            Gson gson = new Gson();
            String json = gson.toJson(resultObject);
            Mosquitto mosquittoInfo = new Gson().fromJson(json, Mosquitto.class);
            LogHelper.getHelper().d("Get mos callback json : " + json);
            if (mosquittoInfo == null) {
                result.setResultCode(33566732);
                result.setMessage(ErrCode.getErrMsg(33566732));
            } else {
                result.setData(mosquittoInfo);
            }
        } else if (reponse.getError() != null) {
            ErrorBean errorBean = reponse.getError();
            result.setResultCode(errorBean.getCode());
            result.setMessage(errorBean.getMessage());
        }
        return result;
    }

    public Result<RequestMsgResult> getpsMsg(Context context, RequestMsgBean requestMsgBean) {
        Result<RequestMsgResult> result = new Result();
        String url = HttpManager.getRequestMosquittoRequestUrl(context);
        RequestBean requestBean = this.getMsgRequestBean(requestMsgBean);
        HttpHelper httpHelper = new HttpHelper(url);
        try {
            ResponseBean reponse = httpHelper.request(requestBean);
            result = this.parseGetMsgResponse(reponse);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            result.setResultCode(e.getErrCode());
            result.setMessage(e.getMessage());
        }
        catch (JsonIOException e) {
            e.printStackTrace();
            result.setResultCode(33566736);
            result.setMessage(ErrCode.getErrMsg(33566736));
        }
        return result;
    }

    private Result<RequestMsgResult> parseGetMsgResponse(ResponseBean reponse) throws JsonSyntaxException {
        Result<RequestMsgResult> result = new Result<RequestMsgResult>();
        if (reponse == null || reponse.getResult() == null && reponse.getError() == null) {
            result.setResultCode(33566731);
            result.setMessage(ErrCode.getErrMsg(33566731));
            return result;
        }
        Object resultObject = reponse.getResult();
        if (resultObject != null) {
            Gson gson = new Gson();
            String json = gson.toJson(resultObject);
            RequestMsgResult requestMsgResult = new Gson().fromJson(json, RequestMsgResult.class);
            if (requestMsgResult == null) {
                result.setResultCode(33566734);
                result.setMessage(ErrCode.getErrMsg(33566734));
            } else {
                result.setData(requestMsgResult);
            }
        } else if (reponse.getError() != null) {
            ErrorBean errorBean = reponse.getError();
            result.setResultCode(errorBean.getCode());
            result.setMessage(errorBean.getMessage());
        }
        return result;
    }

    public Result<DelMsgResult> delpsMsg(Context context, DelMsgBean delMsgBean) {
        Result<DelMsgResult> result = new Result();
        String url = HttpManager.getRequestMosquittoRequestUrl(context);
        RequestBean requestBean = this.getDelMsgRequestBean(delMsgBean);
        HttpHelper httpHelper = new HttpHelper(url);
        try {
            ResponseBean reponse = httpHelper.request(requestBean);
            result = this.parseDelMsgResponse(reponse);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            result.setResultCode(e.getErrCode());
            result.setMessage(e.getMessage());
        }
        catch (JsonIOException e) {
            e.printStackTrace();
            result.setResultCode(33566737);
            result.setMessage(ErrCode.getErrMsg(33566737));
        }
        return result;
    }

    private Result<DelMsgResult> parseDelMsgResponse(ResponseBean reponse) throws JsonSyntaxException {
        Result<DelMsgResult> result = new Result<DelMsgResult>();
        if (reponse == null || reponse.getResult() == null && reponse.getError() == null) {
            result.setResultCode(33566731);
            result.setMessage(ErrCode.getErrMsg(33566731));
            return result;
        }
        Object resultObject = reponse.getResult();
        if (resultObject != null) {
            Gson gson = new Gson();
            String json = gson.toJson(resultObject);
            DelMsgResult delMsgResult = new Gson().fromJson(json, DelMsgResult.class);
            if (delMsgResult == null) {
                result.setResultCode(33566735);
                result.setMessage(ErrCode.getErrMsg(33566735));
            } else {
                result.setData(delMsgResult);
            }
        } else if (reponse.getError() != null) {
            ErrorBean errorBean = reponse.getError();
            result.setResultCode(errorBean.getCode());
            result.setMessage(errorBean.getMessage());
        }
        return result;
    }

    public int getNotifyStr(String topic, String notifyJsonStr, String pg) throws JsonSyntaxException {
        if (processNotifyManager == null) {
            processNotifyManager = new ProcessNotifyManager(this.context.getApplicationContext());
        }
        processNotifyManager.startProcessNotifyTask();
        processNotifyManager.startProcessMsgTask();
        Gson gson = new Gson();
        if (!TextUtils.isEmpty((CharSequence)notifyJsonStr)) {
            try {
                NotifyBean notifyBean;
                if ("PULL_HISTORY_MSG".equals(notifyJsonStr)) {
                    notifyBean = new NotifyBean();
                    notifyBean.setContext(notifyJsonStr);
                    notifyBean.setType(2);
                    LogHelper.getHelper().d("PULL_HISTORY_MSG");
                    notifyBean.setId(10000000L);
                } else {
                    notifyBean = gson.fromJson(notifyJsonStr, NotifyBean.class);
                    String msg = notifyBean.getContext();
                    MsgBean bean = null;
                    if (!TextUtils.isEmpty((CharSequence)msg)) {
                        Gson gsonMsg = new Gson();
                        bean = (MsgBean)gsonMsg.fromJson(msg, new TypeToken<MsgBean>(){}.getType());
                        notifyBean.setContext(bean.getCon());
                        notifyBean.setId(bean.getId());
                    }
                }
                notifyBean.setPg(pg);
                notifyBean.setTopic(topic);
                this.addNotifyBean2Quene(notifyBean);
            }
            catch (Exception e) {
                return 602;
            }
            return 601;
        }
        return 602;
    }

    private void addNotifyBean2Quene(final NotifyBean notifyBean) {
        if (!notifyLinkedBlockingQueue.offer(notifyBean)) {
            taskhandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        notifyLinkedBlockingQueue.put(notifyBean);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    static {
        notifyLinkedBlockingQueue = new LinkedBlockingQueue();
        handlerThread = new HandlerThread(HANDLER_THREAD_NAME);
        handlerThread.start();
        taskhandler = new Handler(handlerThread.getLooper());
    }
}

