/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.npc.aidl;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import com.xdja.pushsdk.PushClientManager;
import com.xdja.pushsdk.npc.aidl.IMyService;
import com.xdja.pushsdk.npc.npcs.util.NPCManager;
import com.xdja.pushsdk.utils.LogHelper;

public class GuardService
extends Service {
    private final String tag = "aidl";
    private final String MQTTS_ACTION = "com.xdja.MqttService";
    private MyBinder mBinder;
    private String pg = "";

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    @SuppressLint(value={"NewApi"})
    public void onCreate() {
        super.onCreate();
        this.mBinder = new MyBinder();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 2;
    }

    public boolean onUnbind(Intent intent) {
        this.reStartNPCS();
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        super.onDestroy();
    }

    private void reStartNPCS() {
        if (NPCManager.isNPCService((Context)this)) {
            LogHelper.getHelper().i("GuardService:npcs exist, don't restart npcs");
            return;
        }
        LogHelper.getHelper().i("GuardService:npcs not exist , restart npcs");
        Intent intent = new Intent();
        intent.setPackage(this.getPackageName());
        intent.setAction("com.xdja.MqttService");
        this.startService(intent);
        this.stopSelf();
    }

    private class MyBinder
    extends IMyService.Stub {
        private MyBinder() {
        }

        @Override
        public int sendMSG(String topic, String message) throws RemoteException {
            return PushClientManager.getInstance((Context)GuardService.this).getNotifyStr(topic, message, "");
        }

        @Override
        public void isRunningNPCPackage(String packageName) throws RemoteException {
            LogHelper.getHelper().d("npcs exist in packageName::" + packageName);
            GuardService.this.pg = packageName;
        }

        @Override
        public void unBindCon() throws RemoteException {
            GuardService.this.stopSelf();
            System.exit(0);
        }
    }
}

