/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.npc.service;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.IBinder;
import android.os.RemoteException;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttMessage;
import com.xdja.pushsdk.PushClientManager;
import com.xdja.pushsdk.npc.aidl.IMyService;
import com.xdja.pushsdk.npc.service.MqttConnection;
import com.xdja.pushsdk.npc.service.MqttServiceCallBack;
import com.xdja.pushsdk.npc.service.MqttServiceReceiver;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.NetState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MqttService
extends Service
implements MqttServiceCallBack {
    protected static final String TAG = "MqttService";
    protected static Map<String, String> topicByPg = new HashMap<String, String>();
    private static Map<String, IMyService> AIDLBinders = new HashMap<String, IMyService>();
    private static MqttConnection mqttConnection;
    private IMyService mBinder;
    private NPCServiceConnection mConn;
    private MqttServiceReceiver mServiceReceiver;
    private boolean bindDisConnect = false;

    public void onCreate() {
        super.onCreate();
        this.initMqttService();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 1;
    }

    public void onDestroy() {
        LogHelper.getHelper().i("mqtt onDestroy");
        this.unRegisterBroadcastReceivers();
        this.unbindGuardService();
        if (mqttConnection != null) {
            mqttConnection.disconnect(null, null);
        }
        super.onDestroy();
    }

    private void initMqttService() {
        this.mConn = new NPCServiceConnection();
        MqttServiceReceiver.setTopicCallBack(this);
        this.registerBroadcastReceivers();
        mqttConnection = new MqttConnection(this);
        mqttConnection.initConnect(this);
        MqttServiceReceiver.setMqttConnectCallBack(mqttConnection);
    }

    private void registerBroadcastReceivers() {
        LogHelper.getHelper().d("Register MqttWork Broadcast");
        if (this.mServiceReceiver == null) {
            this.mServiceReceiver = new MqttServiceReceiver();
            IntentFilter filter = new IntentFilter();
            filter.addAction("com.xdja.npcs.SUBTOPIC");
            filter.addAction("com.xdja.npcs.UNSUBTOPIC");
            filter.addAction("com.xdja.npcs.MSG");
            filter.addAction("com.xdja.npcs.PUSHSTOP");
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            filter.addAction("com.xdja.mqtt.ping");
            this.registerReceiver(this.mServiceReceiver, filter);
        }
    }

    private void unRegisterBroadcastReceivers() {
        LogHelper.getHelper().d("Unregister MqttWork Broadcast");
        if (this.mServiceReceiver != null) {
            try {
                this.unregisterReceiver(this.mServiceReceiver);
            }
            catch (Exception e) {
                LogHelper.getHelper().i("This receiver unRegisterBroadcastReceiver  suiye:" + e.getMessage());
            }
        }
    }

    private void unbindGuardService() {
        LogHelper.getHelper().d("UnbindGuardService");
        try {
            if (this.mConn != null) {
                this.unbindService(this.mConn);
            }
        }
        catch (Exception e) {
            LogHelper.getHelper().i("mConn is unbindService  e:" + e.getMessage());
        }
    }

    public void messageArrivedSender(String topic, String message) {
        LogHelper.getHelper().i("Mqtt Msg Comming");
        LogHelper.getHelper().d("topic--->>" + topic + "    message--->>" + message);
        PushClientManager.getInstance((Context)this).getNotifyStr(topic, message, topicByPg.get(topic));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Map<String, String> map = topicByPg;
        synchronized (map) {
            topicByPg.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disSubscribe(String[] topics) {
        Map<String, String> map = topicByPg;
        synchronized (map) {
            for (String topic : topics) {
                topicByPg.remove(topic);
            }
        }
    }

    public void pullHisMsg(String topic) {
        if (topicByPg.get(topic) != null) {
            PushClientManager.getInstance((Context)this).getNotifyStr(topic, "PULL_HISTORY_MSG", topicByPg.get(topic));
        }
    }

    public boolean subscribe(List<String> topics) {
        if (mqttConnection == null || !mqttConnection.isConnected()) {
            LogHelper.getHelper().d("initSub fail by client is not online");
            return false;
        }
        int[] qoss = new int[topics.size()];
        String[] tpcs = new String[topics.size()];
        topics.toArray(tpcs);
        mqttConnection.subscribe(tpcs, qoss, null, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String topic, String pg) {
        Map<String, String> map = topicByPg;
        synchronized (map) {
            if (topic.equals("UNREGISTER_PUSH")) {
                Set<String> topics = topicByPg.keySet();
                ArrayList<String> tpcs = new ArrayList<String>();
                tpcs.addAll(topics);
                for (int i = 0; i < tpcs.size(); ++i) {
                    if (!topicByPg.get(tpcs.get(i)).equals(pg) || mqttConnection == null || !mqttConnection.isConnected()) continue;
                    topicByPg.remove(tpcs.get(i));
                    mqttConnection.unsubscribe((String)tpcs.get(i), null, null);
                    LogHelper.getHelper().d("unsubscribe topic--->>" + (String)tpcs.get(i));
                }
            } else if (mqttConnection != null && mqttConnection.isConnected()) {
                topicByPg.remove(topic);
                mqttConnection.unsubscribe(topic, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(List<String> topics, String pg) {
        if (mqttConnection != null && mqttConnection.isConnected()) {
            Map<String, String> map = topicByPg;
            synchronized (map) {
                for (String topic : topics) {
                    topicByPg.remove(topic);
                }
            }
            String[] tpcs = new String[topics.size()];
            topics.toArray(tpcs);
            mqttConnection.unsubscribe(tpcs, null, null);
        }
    }

    public void publishMsg(String message, String topic) {
        if (mqttConnection != null && mqttConnection.isConnected()) {
            byte[] payload = message.getBytes();
            MqttMessage msg = null;
            msg = payload != null ? new MqttMessage(payload) : new MqttMessage();
            msg.setQos(0);
            msg.setRetained(false);
            mqttConnection.publish(topic, msg, null, null);
        }
    }

    public void mqttConnectSuccess() {
        LogHelper.getHelper().d("NPCS broadcast invite subscribe");
        Intent intent = new Intent();
        LogHelper.getHelper().d("pg--->>>" + this.getPackageName());
        intent.setAction("com.xdja.npcs.INVITESUB");
        intent.setPackage(this.getPackageName());
        intent.putExtra("pg", this.getPackageName());
        this.sendBroadcast(intent);
        String net = NetState.getNetworkType((Context)this);
        LogHelper.getHelper().i("mqtt connected and net is " + net);
        this.sendPushCode("10000");
    }

    public void sendPushCode(String code) {
        Intent inPushState = new Intent();
        inPushState.setPackage(this.getPackageName());
        inPushState.setAction("com.xdja.npcs.PUSHSTATE");
        inPushState.putExtra("pushcode", code);
        this.sendBroadcast(inPushState);
    }

    public boolean bindTargetAIDLService(String pg) {
        Intent in = new Intent();
        in.setAction("com.xdja.service.aidl.single");
        in.setPackage(pg);
        this.startService(in);
        boolean isSuccess = this.bindService(in, this.mConn, 1);
        LogHelper.getHelper().d("AIDLServiceTarget---" + pg + "---" + isSuccess);
        return isSuccess;
    }

    public List<Intent> getExplicitIntent(Context context, Intent implicitIntent) {
        ArrayList<Intent> intents = new ArrayList<Intent>();
        PackageManager pm = context.getPackageManager();
        List resolveInfo = pm.queryIntentServices(implicitIntent, 0);
        if (resolveInfo == null) {
            return null;
        }
        for (ResolveInfo resolveInfo2 : resolveInfo) {
            String packageName = resolveInfo2.serviceInfo.packageName;
            String className = resolveInfo2.serviceInfo.name;
            ComponentName component = new ComponentName(packageName, className);
            Intent explicitIntent = new Intent(implicitIntent);
            explicitIntent.setComponent(component);
            intents.add(explicitIntent);
        }
        return intents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subTopic(List<String> topics, String pg) {
        boolean bindState = false;
        ArrayList<String> topicsSub = new ArrayList<String>();
        if (topics != null && pg != null) {
            Map<String, String> map;
            bindState = this.bindTargetAIDLService(pg);
            if (bindState) {
                map = topicByPg;
                synchronized (map) {
                    for (String topic : topics) {
                        if (topicByPg.containsKey(topic)) continue;
                        topicByPg.put(topic, pg);
                        topicsSub.add(topic);
                        LogHelper.getHelper().d("subtopic::" + topic + "  pg::" + pg);
                    }
                }
            }
            if (!this.subscribe(topicsSub)) {
                map = topicByPg;
                synchronized (map) {
                    for (String topic : topicsSub) {
                        topicByPg.remove(topic);
                    }
                }
            }
        }
        return bindState;
    }

    @Override
    public void unsubTopic(List<String> topics, String pg) {
        if (topics != null && pg != null) {
            if (topics.size() == 1) {
                this.unsubscribe(topics.get(0), pg);
            } else if (topics.size() > 1) {
                this.unsubscribe(topics, pg);
            }
        }
    }

    @Override
    public void deliverMsg(String message, String topic) {
        if (message != null && topic != null) {
            this.publishMsg(message, topic);
        }
    }

    @Override
    public void stopPush() {
        try {
            if (this.mBinder != null) {
                this.mBinder.unBindCon();
            }
        }
        catch (RemoteException e) {
            LogHelper.getHelper().e("StopPush fail to unBindCon");
        }
        this.stopSelf();
        System.exit(0);
    }

    private final class NPCServiceConnection
    implements ServiceConnection {
        private NPCServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName name) {
            Map<String, String> map = AIDLBinders;
            synchronized (map) {
                AIDLBinders.remove(name.getPackageName());
            }
            if (mqttConnection != null) {
                map = topicByPg;
                synchronized (map) {
                    Set<String> keys = topicByPg.keySet();
                    for (String key : keys) {
                        if (!topicByPg.get(key).equals(name.getPackageName())) continue;
                        MqttService.this.bindDisConnect = true;
                        mqttConnection.unsubscribe(key, null, null);
                        LogHelper.getHelper().d("\u8de8\u8fdb\u7a0b\u8fde\u63a5\u65ad\u5f00\uff0c\u53d6\u6d88\u5df2\u7ecf\u6ce8\u518c\u7684\u4e3b\u9898--->>topic==" + key);
                    }
                }
            }
            MqttService.this.bindTargetAIDLService(name.getPackageName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            MqttService.this.mBinder = IMyService.Stub.asInterface(service);
            try {
                MqttService.this.mBinder.isRunningNPCPackage(MqttService.this.getPackageName());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            Map<String, String> map = AIDLBinders;
            synchronized (map) {
                AIDLBinders.put(name.getPackageName(), MqttService.this.mBinder);
            }
            map = topicByPg;
            synchronized (map) {
                ArrayList<String> topicsTmp = new ArrayList<String>();
                Set<String> keys = topicByPg.keySet();
                for (String key : keys) {
                    if (!topicByPg.get(key).equals(name.getPackageName()) || !MqttService.this.bindDisConnect) continue;
                    topicsTmp.add(key);
                    LogHelper.getHelper().d("\u8de8\u8fdb\u7a0b\u8fde\u63a5\u6210\u529f\uff0c\u6ce8\u518c\u4e3b\u9898--->>topic==" + key);
                }
                if (!MqttService.this.subscribe(topicsTmp)) {
                    for (String topic : topicsTmp) {
                        topicByPg.remove(topic);
                    }
                }
            }
            MqttService.this.bindDisConnect = false;
            LogHelper.getHelper().d("onServiceConnected....");
        }
    }
}

