/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.npc.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.xdja.pushsdk.npc.service.MqttConnectCallback;
import com.xdja.pushsdk.npc.service.MqttServiceCallBack;
import com.xdja.pushsdk.utils.LogHelper;
import java.util.ArrayList;

public class MqttServiceReceiver
extends BroadcastReceiver {
    static MqttServiceCallBack topicCallBack;
    static MqttConnectCallback mqttConnectCallback;

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action == null) {
            return;
        }
        if (action.equalsIgnoreCase("com.xdja.npcs.MSG")) {
            LogHelper.getHelper().d("\u63a5\u6536\u53d1\u9001\u6d88\u606f");
            if (topicCallBack != null) {
                topicCallBack.deliverMsg(intent.getStringExtra("msg"), intent.getStringExtra("topic"));
            }
        } else if (action.equalsIgnoreCase("com.xdja.npcs.SUBTOPIC")) {
            LogHelper.getHelper().d("\u63a5\u6536\u5230\u4e86\u6ce8\u518c\u4e3b\u9898\u5e7f\u64ad");
            if (topicCallBack != null) {
                String pg = intent.getStringExtra("pg");
                ArrayList topicsTmp = intent.getStringArrayListExtra("topic");
                topicCallBack.subTopic(topicsTmp, pg);
            }
        } else if (action.equalsIgnoreCase("com.xdja.npcs.UNSUBTOPIC")) {
            LogHelper.getHelper().d("\u63a5\u6536\u5230\u4e86\u53d6\u6d88\u4e3b\u9898\u5e7f\u64ad");
            if (topicCallBack != null) {
                String pg = intent.getStringExtra("pg");
                ArrayList topicsTmp = intent.getStringArrayListExtra("topic");
                topicCallBack.unsubTopic(topicsTmp, pg);
            }
        } else if (action.equalsIgnoreCase("android.net.conn.CONNECTIVITY_CHANGE")) {
            if (mqttConnectCallback != null) {
                LogHelper.getHelper().i("NetWork is Changed and checkPing");
                mqttConnectCallback.checkPing();
            } else {
                System.exit(0);
            }
        } else if (action.equalsIgnoreCase("com.xdja.npcs.PUSHSTOP")) {
            LogHelper.getHelper().d("\u63a5\u6536\u5230\u4e86\u5173\u95ed\u63a8\u9001\u5e7f\u64ad");
            if (topicCallBack != null) {
                topicCallBack.stopPush();
            }
        } else if (action.equalsIgnoreCase("com.xdja.mqtt.ping")) {
            LogHelper.getHelper().d("\u68c0\u6d4b\u957f\u94fe\u63a5\u662f\u5426\u53ef\u7528");
            if (mqttConnectCallback != null) {
                mqttConnectCallback.checkPing();
            }
        }
    }

    public static void setTopicCallBack(MqttServiceCallBack callBack) {
        topicCallBack = callBack;
    }

    public static void setMqttConnectCallBack(MqttConnectCallback callBack) {
        mqttConnectCallback = callBack;
    }
}

