/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.task;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import com.xdja.pushsdk.PushClientManager;
import com.xdja.pushsdk.bean.DelMsgBean;
import com.xdja.pushsdk.bean.DelMsgResult;
import com.xdja.pushsdk.bean.MsgBean;
import com.xdja.pushsdk.bean.NotifyBean;
import com.xdja.pushsdk.bean.RequestMsgBean;
import com.xdja.pushsdk.bean.RequestMsgResult;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.Result;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ProcessNotifyManager {
    private final int wait_notify_timeout = 100;
    private final int Notify_Type_Msg = 1;
    private final int Notify_Type_Signal = 2;
    private final int Notify_Type_Msg_Uncached = 4;
    private boolean isStopProcessNotifyTask = false;
    private static Thread processNotifythread;
    private static boolean isHaveNotHandleNotify;
    public static final Map<String, Long> lastGetMsgTimeMillis;
    private static final String MESSAGE_HANDLE_THREAD = "message_handle_thread";
    private static final String HTTP_TASK_HANDLE_THREAD = "http_task_handle_thread";
    private static final String GET_MESSAGE_SIZE = "50";
    private static final int GET_MESSAGE_SIZE_INT = 50;
    private static final String DEL_MESSAGE_SIZE = "-1";
    private static final int DEFAULT_TYPE = -1;
    private static final String NOTIFY_ACTION = "com.xdja.apushsdk";
    private static final String PUSH_NOTIFY_KEY = "c";
    private static final String PUSH_TOPIC_KEY = "topic";
    private static LinkedBlockingQueue<NotifyBean> messageLinkedBlockingQueue;
    private static final String UPDATE_TEST = "UPDATE_TEST";
    private HandlerThread messageHandlerThread;
    private HandlerThread httpTaskHandlerThread;
    private Handler messageHandler;
    private Handler httpTaskHandler;
    private ExecutorService executorService = Executors.newFixedThreadPool(3);
    private PushClientManager pushClientManager;
    private Context mContext;

    public ProcessNotifyManager(Context context) {
        this.mContext = context;
        this.pushClientManager = PushClientManager.getInstance(context);
    }

    public void stopProcessNotifyTask() {
        this.isStopProcessNotifyTask = true;
    }

    public void startProcessNotifyTask() {
        if (processNotifythread == null) {
            processNotifythread = new Thread(new ProcessNotifyRunnable());
            processNotifythread.setName("ProcessNotifyThread");
            this.startProcessNotifyThread();
        } else if (!processNotifythread.isAlive()) {
            this.startProcessNotifyThread();
        }
    }

    public void startProcessMsgTask() {
        if (this.messageHandlerThread == null) {
            this.messageHandlerThread = new HandlerThread(MESSAGE_HANDLE_THREAD);
            this.messageHandlerThread.start();
        } else if (!this.messageHandlerThread.isAlive()) {
            this.messageHandlerThread.start();
        }
        if (this.httpTaskHandlerThread == null) {
            this.httpTaskHandlerThread = new HandlerThread(HTTP_TASK_HANDLE_THREAD);
            this.httpTaskHandlerThread.start();
        } else if (!this.messageHandlerThread.isAlive()) {
            this.messageHandlerThread.start();
        }
        this.messageHandler = new Handler(this.messageHandlerThread.getLooper());
        this.httpTaskHandler = new Handler(this.httpTaskHandlerThread.getLooper());
    }

    private void startProcessNotifyThread() {
        try {
            processNotifythread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAllowGetMsgByTime(String topic) {
        long currentTime = System.currentTimeMillis();
        Map<String, Long> map = lastGetMsgTimeMillis;
        synchronized (map) {
            Long lastGetMsgTime;
            if (lastGetMsgTimeMillis.containsKey(topic) && (lastGetMsgTime = lastGetMsgTimeMillis.get(topic)) != null) {
                return currentTime - lastGetMsgTime >= 100L;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSignalNotify(final NotifyBean notifyBean) {
        if (notifyBean != null) {
            Map<String, Long> map = lastGetMsgTimeMillis;
            synchronized (map) {
                lastGetMsgTimeMillis.put(notifyBean.getTopic(), System.currentTimeMillis());
            }
        }
        this.httpTaskHandler.post(new Runnable(){

            @Override
            public void run() {
                ProcessNotifyManager.this.pullMsgFromServ(notifyBean);
            }
        });
        isHaveNotHandleNotify = false;
    }

    private void pullMsgFromServ(NotifyBean notifyBean) {
        RequestMsgBean requestMsgBean = this.getRequestMsgBean(notifyBean);
        if (requestMsgBean != null) {
            Result<DelMsgResult> result;
            DelMsgBean delMsgBean;
            boolean isHasMsg = true;
            long firstId = 0L;
            long lastId = 0L;
            ArrayList<NotifyBean> notifyBeans = new ArrayList<NotifyBean>();
            int pullMsgNum = 0;
            while (isHasMsg) {
                LogHelper.getHelper().d("pullMsgFromServ--->>begain  " + System.currentTimeMillis());
                Result<RequestMsgResult> msgBean = this.pushClientManager.getpsMsg(this.mContext, requestMsgBean);
                if (msgBean != null && !msgBean.isError()) {
                    NotifyBean bean;
                    List<NotifyBean> notifys = this.convertMsgResult2NotifyBean(msgBean, notifyBean.getTopic(), notifyBean.getPg());
                    notifyBeans.addAll(notifys);
                    LogHelper.getHelper().d("pullMsgFromServ--->>end   " + System.currentTimeMillis() + "   msgSize::" + notifyBeans.size());
                    pullMsgNum = notifys.size();
                    if (notifys.size() > 1 && (bean = notifys.get(notifys.size() - 1)) != null) {
                        lastId = bean.getId();
                    }
                }
                if (pullMsgNum < 50) {
                    isHasMsg = false;
                }
                requestMsgBean.setMsgStartId(lastId + "");
            }
            if (notifyBeans.size() > 0 && (delMsgBean = this.getDelMsgBean((firstId = ((NotifyBean)notifyBeans.get(0)).getId()) + "", notifyBean.getTopic())) != null && !(result = this.pushClientManager.delpsMsg(this.mContext, delMsgBean)).isError()) {
                this.handleMessageNotify(notifyBeans);
                LogHelper.getHelper().i("PMCS::" + notifyBeans.size() + " T::" + System.currentTimeMillis());
                notifyBeans.clear();
            }
            notifyBeans.clear();
        }
    }

    private void handleMessageNotify(NotifyBean notifyBean) {
        this.addNotifyBean2Quene(notifyBean);
        this.startHandleMsgThread();
    }

    private void handleMessageNotify(List<NotifyBean> notifyBeans) {
        for (NotifyBean bean : notifyBeans) {
            this.addNotifyBean2Quene(bean);
        }
        this.startHandleMsgThread();
    }

    private RequestMsgBean getRequestMsgBean(NotifyBean bean) {
        RequestMsgBean requestMsgBean = new RequestMsgBean();
        if (bean != null) {
            requestMsgBean.setUser(bean.getTopic());
            requestMsgBean.setMsgSize(GET_MESSAGE_SIZE);
            return requestMsgBean;
        }
        return null;
    }

    private DelMsgBean getDelMsgBean(String id2, String topic) {
        DelMsgBean delMsgBean = null;
        delMsgBean = new DelMsgBean();
        delMsgBean.setUser(topic);
        delMsgBean.setMsgStartId(id2);
        delMsgBean.setDelMsgSize(DEL_MESSAGE_SIZE);
        return delMsgBean;
    }

    private List<NotifyBean> convertMsgResult2NotifyBean(Result<RequestMsgResult> result, String topic, String pg) {
        MsgBean[] beans;
        ArrayList<NotifyBean> notifyBeans = new ArrayList<NotifyBean>();
        NotifyBean notifyBean = null;
        MsgBean bean = null;
        if (result.getData() != null && (beans = result.getData().getData()) != null) {
            for (int i = 0; i < beans.length; ++i) {
                notifyBean = new NotifyBean();
                bean = beans[i];
                notifyBean.setContext(bean.getCon());
                notifyBean.setId(bean.getId());
                notifyBean.setExp(bean.getExp());
                notifyBean.setType(-1);
                notifyBean.setTopic(topic);
                notifyBean.setPg(pg);
                notifyBeans.add(notifyBean);
            }
        }
        return notifyBeans;
    }

    private void addNotifyBean2Quene(final NotifyBean notifyBean) {
        if (!messageLinkedBlockingQueue.offer(notifyBean)) {
            this.messageHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        messageLinkedBlockingQueue.put(notifyBean);
                        ProcessNotifyManager.this.startHandleMsgThread();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void startHandleMsgThread() {
        if (this.executorService != null) {
            this.executorService.execute(new HandleMsgRunnable());
        }
    }

    static {
        isHaveNotHandleNotify = false;
        lastGetMsgTimeMillis = new HashMap<String, Long>();
        messageLinkedBlockingQueue = new LinkedBlockingQueue();
    }

    private class HandleMsgRunnable
    implements Runnable {
        private HandleMsgRunnable() {
        }

        @Override
        public void run() {
            NotifyBean bean;
            while ((bean = (NotifyBean)messageLinkedBlockingQueue.poll()) != null) {
                Intent in = new Intent();
                in.setAction(ProcessNotifyManager.NOTIFY_ACTION);
                in.setPackage(bean.getPg());
                in.putExtra(ProcessNotifyManager.PUSH_NOTIFY_KEY, bean.getContext());
                in.putExtra(ProcessNotifyManager.PUSH_TOPIC_KEY, bean.getTopic());
                LogHelper.getHelper().i("Msg Broadcast to APP");
                ProcessNotifyManager.this.mContext.sendBroadcast(in);
                LogHelper.getHelper().d("\u5e7f\u64ad\u5c06\u6d88\u606f\u4f20\u9012\u7ed9\u4e0a\u5c42APP");
            }
        }
    }

    public class ProcessNotifyRunnable
    implements Runnable {
        @Override
        public void run() {
            do {
                NotifyBean notifyBean;
                if ((notifyBean = this.getNotifyBeanFromMsgQueue()) == null) {
                    if (!isHaveNotHandleNotify) continue;
                    ProcessNotifyManager.this.handleSignalNotify(notifyBean);
                    continue;
                }
                if (notifyBean.getType() == 1 || notifyBean.getType() == 4) {
                    DelMsgBean delMsgBean;
                    ProcessNotifyManager.this.handleMessageNotify(notifyBean);
                    LogHelper.getHelper().i("PMCS::1 T::" + System.currentTimeMillis());
                    if (notifyBean.getType() == 1 && (delMsgBean = ProcessNotifyManager.this.getDelMsgBean(notifyBean.getId() + "", notifyBean.getTopic())) != null) {
                        ProcessNotifyManager.this.pushClientManager.delpsMsg(ProcessNotifyManager.this.mContext, delMsgBean);
                    }
                    if (!isHaveNotHandleNotify || !ProcessNotifyManager.this.isAllowGetMsgByTime(notifyBean.getTopic())) continue;
                    ProcessNotifyManager.this.handleSignalNotify(notifyBean);
                    continue;
                }
                if (notifyBean.getType() != 2) continue;
                if (notifyBean.getContext().equals("PULL_HISTORY_MSG")) {
                    ProcessNotifyManager.this.handleSignalNotify(notifyBean);
                }
                if (ProcessNotifyManager.this.isAllowGetMsgByTime(notifyBean.getTopic())) {
                    ProcessNotifyManager.this.handleSignalNotify(notifyBean);
                    continue;
                }
                isHaveNotHandleNotify = true;
            } while (!ProcessNotifyManager.this.isStopProcessNotifyTask);
        }

        private NotifyBean getNotifyBeanFromMsgQueue() {
            NotifyBean notifyBean = null;
            try {
                notifyBean = isHaveNotHandleNotify ? PushClientManager.notifyLinkedBlockingQueue.poll(this.getBlockTimeout(), TimeUnit.MILLISECONDS) : PushClientManager.notifyLinkedBlockingQueue.take();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return notifyBean;
        }

        private int getBlockTimeout() {
            return 100;
        }
    }
}

