/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.utils;

import android.util.Log;
import java.util.Hashtable;

public class LogHelper {
    private static final boolean LOG_FLAG = false;
    private static final boolean LOG_FLAG_WRITEFILE = false;
    private static final String TAG = "XdjaPushSdk_LOG";
    private static final int LOG_LEVEL = 2;
    private static Hashtable<String, LogHelper> sLoggerTable = new Hashtable();
    private String mClassName;
    private static LogHelper logger;

    private LogHelper(String name) {
        this.mClassName = name;
    }

    private static LogHelper getLogger(String className) {
        LogHelper classLogger = sLoggerTable.get(className);
        if (classLogger == null) {
            classLogger = new LogHelper(className);
            sLoggerTable.put(className, classLogger);
        }
        return classLogger;
    }

    public static LogHelper getHelper(String Tag) {
        if (logger == null) {
            logger = new LogHelper(Tag);
        }
        return logger;
    }

    public static LogHelper getHelper() {
        if (logger == null) {
            logger = new LogHelper(TAG);
        }
        return logger;
    }

    private String getFunctionName() {
        StackTraceElement[] sts = Thread.currentThread().getStackTrace();
        if (sts == null) {
            return null;
        }
        for (StackTraceElement st : sts) {
            if (st.isNativeMethod() || st.getClassName().equals(Thread.class.getName()) || st.getClassName().equals(this.getClass().getName())) continue;
            return this.mClassName + "[ " + Thread.currentThread().getName() + ": " + st.getFileName() + ":" + st.getLineNumber() + " " + st.getMethodName() + " ]";
        }
        return null;
    }

    public void i(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            LogHelper.writeFileToSD(TAG, name + " - " + str);
            Log.i((String)TAG, (String)(name + " - " + str));
        } else {
            LogHelper.writeFileToSD(TAG, str.toString());
            Log.i((String)TAG, (String)str.toString());
        }
    }

    public void d(Object str) {
    }

    public void v(Object str) {
    }

    public void w(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            LogHelper.writeFileToSD(TAG, name + " - " + str);
            Log.w((String)TAG, (String)(name + " - " + str));
        } else {
            LogHelper.writeFileToSD(TAG, str.toString());
            Log.w((String)TAG, (String)str.toString());
        }
    }

    public void e(Object str) {
    }

    public void e(Exception ex) {
    }

    public void e(String log, Throwable tr) {
    }

    public static void writeFileToSD(String appName, String content) {
    }
}

