/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SharedPreUtils {
    public static final String WEB_API_IP = "webApiIp";
    public static final String WEB_API_PORT = "webApiPort";
    public static final String WEB_API_TYPE = "webApiType";
    public static final String CLIENT_ID = "clientid";
    public static final String INIT_DEVID = "INIT_DEVID";
    public static final String NPSWEB_PARAM = "NPSWEB_PARAM";
    public static final String PUSH_STATE = "PUSH_STATE";
    public static final String STATE = "state";
    public static final String TOPIC_HIS = "TOPIC_HIS";
    public static final String DEFAULT_CLIENT_ID = "0";
    public static final String DEFAULT_STRING_OTHER = "0";
    public static final String DEFAULT_VALUE_STRING = "0";
    public static final int DEFAULT_VALUE_INTEGER = 0;

    public static void commitSharedPre(Context context, String tag, Map<String, Object> values) {
        SharedPreferences sp = context.getSharedPreferences(tag, 0);
        SharedPreferences.Editor editor = sp.edit();
        for (String key : values.keySet()) {
            if (values.get(key) instanceof Integer) {
                editor.putInt(key, ((Integer)values.get(key)).intValue());
                continue;
            }
            if (!(values.get(key) instanceof String)) continue;
            editor.putString(key, (String)values.get(key));
        }
        editor.clear();
        editor.apply();
    }

    @SuppressLint(value={"NewApi"})
    public static void commitSharedPreSet(Context context, String tag, Map<String, Set<String>> values) {
        SharedPreferences sp = context.getSharedPreferences(tag, 0);
        SharedPreferences.Editor editor = sp.edit();
        for (String key : values.keySet()) {
            editor.putStringSet(key, values.get(key));
        }
        editor.clear();
        editor.apply();
    }

    @SuppressLint(value={"NewApi"})
    public static Object getSharedPre(Context context, String tag, String key, Object defaultValue) {
        SharedPreferences sp = context.getSharedPreferences(tag, 0);
        Object value = null;
        if (defaultValue instanceof Integer) {
            value = sp.getInt(key, ((Integer)defaultValue).intValue());
        } else if (defaultValue instanceof String) {
            value = sp.getString(key, (String)defaultValue);
        } else if (defaultValue instanceof Set) {
            value = sp.getStringSet(key, (Set)defaultValue);
        }
        return value;
    }

    public static void clearSharedPre(Context context, String tag) {
        SharedPreferences sp = context.getSharedPreferences(tag, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.clear();
        editor.apply();
    }

    public static void savaPushConfig(Context context, String webApiIp, String webApiPort, String type) {
        HashMap<String, Object> initValues = new HashMap<String, Object>();
        initValues.put(WEB_API_IP, webApiIp);
        initValues.put(WEB_API_PORT, webApiPort);
        initValues.put(WEB_API_TYPE, type);
        SharedPreUtils.commitSharedPre(context, NPSWEB_PARAM, initValues);
    }

    public static void savaPushClientId(Context context, String clientId) {
        HashMap<String, Object> devValues = new HashMap<String, Object>();
        devValues.put(CLIENT_ID, clientId);
        SharedPreUtils.commitSharedPre(context, INIT_DEVID, devValues);
    }

    public static void savaPushState(Context context, int state) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STATE, state);
        SharedPreUtils.commitSharedPre(context, PUSH_STATE, map);
    }

    public static String getPushClientId(Context context) {
        return (String)SharedPreUtils.getSharedPre(context, INIT_DEVID, CLIENT_ID, "0");
    }

    public static int getPushState(Context context) {
        int state = (Integer)SharedPreUtils.getSharedPre(context, PUSH_STATE, STATE, 0);
        return state;
    }

    public static List<String> getPushTopics(Context context) {
        Set topics = new HashSet();
        topics = (Set)SharedPreUtils.getSharedPre(context, TOPIC_HIS, context.getPackageName(), topics);
        ArrayList<String> tpcs = new ArrayList<String>();
        if (topics.size() != 0) {
            tpcs.addAll(topics);
        }
        return tpcs;
    }
}

