/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ysm.security.web;

import com.xdja.ysm.core.core.util.JsonUtils;
import com.xdja.ysm.security.bean.Menu;
import com.xdja.ysm.security.provider.MenuProvider;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.filter.mgt.DefaultFilterChainManager;
import org.apache.shiro.web.filter.mgt.PathMatchingFilterChainResolver;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSecurityFilterFactoryBean
extends ShiroFilterFactoryBean
implements InitializingBean {
    @Autowired
    private MenuProvider menuProvider;
    private Map<String, String> customPermissionMap = new LinkedHashMap<String, String>();
    private boolean initialized = false;

    public synchronized void init() {
        PathMatchingFilterChainResolver filter = null;
        try {
            filter = (PathMatchingFilterChainResolver)((AbstractShiroFilter)this.getObject()).getFilterChainResolver();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DefaultFilterChainManager manager = (DefaultFilterChainManager)filter.getFilterChainManager();
        Map filterChainDefinitions = this.getFilterChainDefinitionMap();
        Collection<Menu> menus = this.menuProvider.provideAllMenus();
        this.processPermission(filterChainDefinitions, menus, manager);
        for (String string : this.customPermissionMap.keySet()) {
            filterChainDefinitions.remove(string);
            manager.getFilterChains().remove(string);
        }
        for (Map.Entry entry : this.customPermissionMap.entrySet()) {
            filterChainDefinitions.put(entry.getKey(), entry.getValue());
            manager.createChain((String)entry.getKey(), (String)entry.getValue());
        }
        System.out.println("DefaultFilterChainManager.chain>>>>>>>>>>>>>" + JsonUtils.object2Json((Object)filterChainDefinitions));
    }

    public void afterPropertiesSet() throws Exception {
        Map filterChainDefinitions = this.getFilterChainDefinitionMap();
        filterChainDefinitions.put(this.getLoginUrl(), "anon");
        Collection<String> anonLinks = this.menuProvider.provideAnonLink();
        if (CollectionUtils.isNotEmpty(anonLinks)) {
            for (String anonLink : anonLinks) {
                filterChainDefinitions.put(anonLink, "anon");
            }
        }
        this.customPermissionMap.clear();
        this.processCustomPermission(this.customPermissionMap);
        filterChainDefinitions.putAll(this.customPermissionMap);
    }

    abstract void processCustomPermission(Map<String, String> var1);

    private void processPermission(Map<String, String> filterChainDefinitions, Collection<Menu> menus, DefaultFilterChainManager manager) {
        if (CollectionUtils.isNotEmpty(menus)) {
            for (Menu menu : menus) {
                if (StringUtils.isNotBlank((CharSequence)menu.getPermissionKey()) && StringUtils.isNotBlank((CharSequence)menu.getPermission())) {
                    filterChainDefinitions.put(menu.getPermissionKey(), "perms[" + menu.getPermission() + "]");
                    manager.createChain(menu.getPermissionKey(), "perms[" + menu.getPermission() + "]");
                }
                this.processPermission(filterChainDefinitions, menu.getChildren(), manager);
            }
        }
        System.out.println(">>>>>>>>>>>>" + JsonUtils.object2Json(filterChainDefinitions));
    }
}

