/*
 * Decompiled with CFR 0.152.
 */
package com.example.xlhratingbar_lib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import com.example.xlhratingbar.UnitUtil;
import com.example.xlhratingbar_lib.R;

public class XLHRatingBar
extends LinearLayout {
    private int countNum;
    private int countSelected;
    private int stateResId;
    private float widthAndHeight;
    private float dividerWidth;
    private boolean canEdit;
    private boolean differentSize;
    private OnRatingChangeListener mOnRatingChangeListener;

    public XLHRatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.XlHRatingBar);
        this.countNum = typedArray.getInt(R.styleable.XlHRatingBar_starCount, 5);
        this.countSelected = typedArray.getInt(R.styleable.XlHRatingBar_countSelected, 0);
        this.canEdit = typedArray.getBoolean(R.styleable.XlHRatingBar_canEdit, false);
        this.differentSize = typedArray.getBoolean(R.styleable.XlHRatingBar_differentSize, false);
        this.widthAndHeight = typedArray.getDimension(R.styleable.XlHRatingBar_widthAndHeight, UnitUtil.dp2Px(context, 0.0f));
        this.dividerWidth = typedArray.getDimension(R.styleable.XlHRatingBar_dividerWidth, UnitUtil.dp2Px(context, 0.0f));
        this.stateResId = typedArray.getResourceId(R.styleable.XlHRatingBar_stateResId, -1);
        this.initView();
    }

    public int getCountNum() {
        return this.countNum;
    }

    public void setCountNum(int countNum) {
        this.countNum = countNum;
        this.initView();
    }

    public int getCountSelected() {
        return this.countSelected;
    }

    public void setCountSelected(int countSelected) {
        if (countSelected > this.countNum) {
            return;
        }
        this.countSelected = countSelected;
        this.initView();
    }

    private void initView() {
        this.removeAllViews();
        for (int i = 0; i < this.countNum; ++i) {
            CheckBox cb = new CheckBox(this.getContext());
            LinearLayout.LayoutParams layoutParams = this.widthAndHeight == 0.0f ? new LinearLayout.LayoutParams(-2, -2) : new LinearLayout.LayoutParams((int)this.widthAndHeight, (int)this.widthAndHeight);
            if (this.differentSize && this.countNum % 2 != 0) {
                Log.e((String)"xxx", (String)(layoutParams.width + ""));
                int index = i;
                if (index > this.countNum / 2) {
                    index = this.countNum - 1 - index;
                }
                float scale = (float)(index + 1) / (float)(this.countNum / 2 + 1);
                layoutParams.height = layoutParams.width = (int)((float)layoutParams.width * scale);
            }
            layoutParams.gravity = 16;
            if (i != 0 && i != this.countNum - 1) {
                layoutParams.leftMargin = (int)this.dividerWidth;
                layoutParams.rightMargin = (int)this.dividerWidth;
            } else if (i == 0) {
                layoutParams.rightMargin = (int)this.dividerWidth;
            } else if (i == this.countNum - 1) {
                layoutParams.leftMargin = (int)this.dividerWidth;
            }
            this.addView((View)cb, (ViewGroup.LayoutParams)layoutParams);
            cb.setButtonDrawable((Drawable)new ColorDrawable(this.getResources().getColor(17170445)));
            if (this.stateResId == -1) {
                this.stateResId = R.drawable.comment_ratingbar_selector;
            }
            cb.setBackgroundResource(this.stateResId);
            if (i + 1 <= this.countSelected) {
                cb.setChecked(true);
            }
            cb.setEnabled(this.canEdit);
            cb.setOnClickListener((View.OnClickListener)new MyClickListener(i));
        }
    }

    public OnRatingChangeListener getOnRatingChangeListener() {
        return this.mOnRatingChangeListener;
    }

    public void setOnRatingChangeListener(OnRatingChangeListener onRatingChangeListener) {
        this.mOnRatingChangeListener = onRatingChangeListener;
    }

    public static interface OnRatingChangeListener {
        public void onChange(int var1);
    }

    private class MyClickListener
    implements View.OnClickListener {
        int position;

        public MyClickListener(int position) {
            this.position = position;
        }

        public void onClick(View v) {
            XLHRatingBar.this.countSelected = this.position + 1;
            for (int i = 0; i < XLHRatingBar.this.countNum; ++i) {
                CheckBox cb = (CheckBox)XLHRatingBar.this.getChildAt(i);
                if (i <= this.position) {
                    cb.setChecked(true);
                    continue;
                }
                if (i <= this.position) continue;
                cb.setChecked(false);
            }
            if (XLHRatingBar.this.mOnRatingChangeListener != null) {
                XLHRatingBar.this.mOnRatingChangeListener.onChange(XLHRatingBar.this.countSelected);
            }
        }
    }
}

