/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.common.om.xml;

import cn.com.jit.common.om.IMapping;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLContext;

public class XMLMapping
implements IMapping {
    private XMLContext xmlContext;
    private String defCharset = "UTF-8";

    public byte[] mapToArray(Object object) {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.mapToStream(object, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public Object mapFromArray(Class clazz, byte[] byArray) {
        Object object = null;
        if (byArray == null || byArray.length < 1) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        object = this.mapFromStream(clazz, byteArrayInputStream);
        return object;
    }

    public OutputStream mapToStream(Object object, OutputStream outputStream) {
        if (object == null) {
            return null;
        }
        if (outputStream == null) {
            return null;
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.defCharset);
            Marshaller marshaller = this.xmlContext.createMarshaller();
            marshaller.setWriter((Writer)outputStreamWriter);
            marshaller.setEncoding(this.defCharset);
            marshaller.marshal(object);
        }
        catch (MarshalException marshalException) {
            marshalException.printStackTrace();
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mapFromStream(Class clazz, InputStream inputStream) {
        Object object = null;
        try {
            if (inputStream == null || inputStream.available() < 1) {
                Object var4_4 = null;
                return var4_4;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.defCharset);
            Unmarshaller unmarshaller = this.xmlContext.createUnmarshaller();
            unmarshaller.setClass(clazz);
            object = unmarshaller.unmarshal((Reader)inputStreamReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (MarshalException marshalException) {
            marshalException.printStackTrace();
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapToFile(Object object, String string) {
        if (string == null || "".equals(string)) {
            return;
        }
        if (object == null) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            this.mapToStream(object, fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapToFile(Object object, File file) {
        if (file == null) {
            return;
        }
        if (!file.exists() || !file.isDirectory()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (object == null) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.mapToStream(object, fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public Object mapFromFile(Class clazz, String string) {
        Object object = null;
        if (string == null || "".equals(string)) {
            return null;
        }
        try {
            object = this.mapFromStream(clazz, new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return object;
    }

    public Object mapFromFile(Class clazz, File file) {
        Object object = null;
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            object = this.mapFromStream(clazz, new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return object;
    }

    public String getDefCharset() {
        return this.defCharset;
    }

    public void setDefCharset(String string) {
        this.defCharset = string;
    }

    public XMLContext getXmlContext() {
        return this.xmlContext;
    }

    public void setXmlContext(XMLContext xMLContext) {
        this.xmlContext = xMLContext;
    }
}

