/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import com.yanzhenjie.album.AlbumActivity;
import com.yanzhenjie.album.AlbumConfig;
import com.yanzhenjie.album.AlbumWrapper;
import com.yanzhenjie.album.GalleryWrapper;
import com.yanzhenjie.album.task.LocalImageLoader;
import java.util.ArrayList;

public final class Album {
    public static String KEY_OUTPUT_IMAGE_PATH_LIST = "KEY_OUTPUT_IMAGE_PATH_LIST";
    private static AlbumConfig sAlbumConfig;

    public static void initialize(AlbumConfig albumConfig) {
        sAlbumConfig = albumConfig;
    }

    public static AlbumConfig getAlbumConfig() {
        if (sAlbumConfig == null) {
            Album.initialize(new AlbumConfig.Build().setImageLoader(new LocalImageLoader()).build());
        }
        return sAlbumConfig;
    }

    public static AlbumWrapper album(Activity activity) {
        return new AlbumWrapper(activity);
    }

    public static AlbumWrapper album(android.support.v4.app.Fragment fragment) {
        return new AlbumWrapper(fragment);
    }

    public static AlbumWrapper album(Fragment fragment) {
        return new AlbumWrapper(fragment);
    }

    public static GalleryWrapper gallery(Activity activity) {
        return new GalleryWrapper(activity);
    }

    public static GalleryWrapper gallery(android.support.v4.app.Fragment fragment) {
        return new GalleryWrapper(fragment);
    }

    public static GalleryWrapper gallery(Fragment fragment) {
        return new GalleryWrapper(fragment);
    }

    @NonNull
    public static ArrayList<String> parseResult(Intent intent) {
        ArrayList pathList = intent.getStringArrayListExtra(KEY_OUTPUT_IMAGE_PATH_LIST);
        if (pathList == null) {
            pathList = new ArrayList();
        }
        return pathList;
    }

    @Deprecated
    public static void startAlbum(Activity activity, int requestCode) {
        Intent intent = new Intent((Context)activity, AlbumActivity.class);
        activity.startActivityForResult(intent, requestCode);
    }

    @Deprecated
    public static void startAlbum(Activity activity, int requestCode, int limitCount) {
        Intent intent = new Intent((Context)activity, AlbumActivity.class);
        intent.putExtra("KEY_INPUT_LIMIT_COUNT", limitCount);
        activity.startActivityForResult(intent, requestCode);
    }

    @Deprecated
    public static void startAlbum(Activity activity, int requestCode, int limitCount, @ColorInt int toolbarColor, @ColorInt int statusBarColor) {
        Intent intent = new Intent((Context)activity, AlbumActivity.class);
        intent.putExtra("KEY_INPUT_LIMIT_COUNT", limitCount);
        intent.putExtra("KEY_INPUT_TOOLBAR_COLOR", toolbarColor);
        intent.putExtra("KEY_INPUT_STATUS_COLOR", statusBarColor);
        activity.startActivityForResult(intent, requestCode);
    }

    @Deprecated
    public static void startAlbum(android.support.v4.app.Fragment fragment, int requestCode) {
        Intent intent = new Intent(fragment.getContext(), AlbumActivity.class);
        fragment.startActivityForResult(intent, requestCode);
    }

    @Deprecated
    public static void startAlbum(android.support.v4.app.Fragment fragment, int requestCode, int limitCount) {
        Intent intent = new Intent(fragment.getContext(), AlbumActivity.class);
        intent.putExtra("KEY_INPUT_LIMIT_COUNT", limitCount);
        fragment.startActivityForResult(intent, requestCode);
    }

    @Deprecated
    public static void startAlbum(android.support.v4.app.Fragment fragment, int requestCode, int limitCount, @ColorInt int toolbarColor, @ColorInt int statusBarColor) {
        Intent intent = new Intent(fragment.getContext(), AlbumActivity.class);
        intent.putExtra("KEY_INPUT_LIMIT_COUNT", limitCount);
        intent.putExtra("KEY_INPUT_TOOLBAR_COLOR", toolbarColor);
        intent.putExtra("KEY_INPUT_STATUS_COLOR", statusBarColor);
        fragment.startActivityForResult(intent, requestCode);
    }
}

