/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.view.Window;
import android.widget.Toast;
import com.yanzhenjie.album.Album;
import com.yanzhenjie.album.R;
import com.yanzhenjie.album.entity.AlbumFolder;
import com.yanzhenjie.album.entity.AlbumImage;
import com.yanzhenjie.album.fragment.AlbumFragment;
import com.yanzhenjie.album.fragment.AlbumNullFragment;
import com.yanzhenjie.album.fragment.AlbumPreviewFragment;
import com.yanzhenjie.album.fragment.Callback;
import com.yanzhenjie.album.fragment.CameraCallback;
import com.yanzhenjie.album.fragment.GalleryFragment;
import com.yanzhenjie.album.task.ScanTask;
import com.yanzhenjie.album.util.DisplayUtils;
import com.yanzhenjie.fragment.CompatActivity;
import com.yanzhenjie.fragment.NoFragment;
import com.yanzhenjie.mediascanner.MediaScanner;
import java.util.ArrayList;
import java.util.List;

public class AlbumActivity
extends CompatActivity
implements Callback,
CameraCallback,
AlbumFragment.Callback,
ScanTask.Callback,
GalleryFragment.Callback {
    private static final int PERMISSION_REQUEST_STORAGE_ALBUM = 200;
    private static final int PERMISSION_REQUEST_STORAGE_GALLERY = 201;
    private ScanTask mScanTask;
    private List<AlbumFolder> mAlbumFolders;
    private List<AlbumImage> mCheckedImages = new ArrayList<AlbumImage>(1);
    private List<String> mCheckedPaths;
    private Bundle mArgument;

    protected int fragmentLayoutId() {
        return R.id.album_root_frame_layout;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        DisplayUtils.initScreen((Activity)this);
        this.setContentView(R.layout.album_activity_main);
        Intent intent = this.getIntent();
        this.mArgument = intent.getExtras();
        int statusBarColor = intent.getIntExtra("KEY_INPUT_STATUS_COLOR", ContextCompat.getColor((Context)this, (int)R.color.albumColorPrimaryDark));
        int navigationBarColor = intent.getIntExtra("KEY_INPUT_NAVIGATION_COLOR", ContextCompat.getColor((Context)this, (int)R.color.albumColorPrimaryBlack));
        this.mCheckedPaths = intent.getStringArrayListExtra("KEY_INPUT_CHECKED_LIST");
        this.setWindowBarColor(statusBarColor, navigationBarColor);
        int function = intent.getIntExtra("KEY_INPUT_FRAMEWORK_FUNCTION", 0);
        switch (function) {
            case 0: {
                int limitCount = intent.getIntExtra("KEY_INPUT_LIMIT_COUNT", 1);
                if (this.mCheckedPaths != null && this.mCheckedPaths.size() > limitCount) {
                    this.mCheckedPaths = this.mCheckedPaths.subList(0, limitCount - 1);
                }
                this.mScanTask = new ScanTask((Context)this, this, this.mCheckedImages);
                this.requestPermission(200);
                break;
            }
            case 1: {
                if (this.mCheckedPaths == null || this.mCheckedPaths.size() == 0) {
                    this.finish();
                    break;
                }
                this.requestPermission(201);
                break;
            }
            default: {
                this.finish();
            }
        }
    }

    private void setWindowBarColor(@ColorInt int statusColor, @ColorInt int navigationColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(statusColor);
            window.setNavigationBarColor(navigationColor);
        }
    }

    private void requestPermission(int requestCode) {
        if (Build.VERSION.SDK_INT >= 23) {
            int permissionResult = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
            if (permissionResult == 0) {
                this.onRequestPermissionsResult(requestCode, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, new int[]{0});
            } else if (permissionResult == -1) {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)requestCode);
            }
        } else {
            this.onRequestPermissionsResult(requestCode, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, new int[]{0});
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 200: {
                int permissionResult = grantResults[0];
                if (permissionResult == 0) {
                    this.scanWithPermission();
                    break;
                }
                new AlertDialog.Builder((Context)this).setCancelable(false).setTitle(R.string.album_dialog_permission_failed).setMessage(R.string.album_permission_storage_failed_hint).setPositiveButton(R.string.album_dialog_sure, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        AlbumActivity.this.doResult(false);
                    }
                }).show();
                break;
            }
            case 201: {
                GalleryFragment galleryFragment = (GalleryFragment)NoFragment.instantiate((Context)this, GalleryFragment.class, (Bundle)this.mArgument);
                galleryFragment.bindImagePaths(this.mCheckedPaths);
                this.startFragment(galleryFragment);
                break;
            }
        }
    }

    private void scanWithPermission() {
        this.mScanTask.execute(new List[]{this.mCheckedPaths});
    }

    @Override
    public void onScanCallback(List<AlbumFolder> albumFolders) {
        this.mAlbumFolders = albumFolders;
        if (this.mAlbumFolders.get(0).getImages().size() == 0) {
            AlbumNullFragment nullFragment = (AlbumNullFragment)NoFragment.instantiate((Context)this, AlbumNullFragment.class, (Bundle)this.mArgument);
            this.startFragment(nullFragment);
        } else {
            AlbumFragment albumFragment = (AlbumFragment)NoFragment.instantiate((Context)this, AlbumFragment.class, (Bundle)this.mArgument);
            albumFragment.bindAlbumFolders(this.mAlbumFolders);
            this.startFragment(albumFragment);
        }
    }

    @Override
    public void onGalleryCallback(ArrayList<String> imagePaths) {
        Intent intent = new Intent();
        intent.putStringArrayListExtra(Album.KEY_OUTPUT_IMAGE_PATH_LIST, imagePaths);
        this.setResult(-1, intent);
        this.finish();
    }

    @Override
    public void doResult(boolean ok) {
        if (ok) {
            int allSize = this.mAlbumFolders.get(0).getImages().size();
            int checkSize = this.mCheckedImages.size();
            if (allSize > 0 && checkSize == 0) {
                Toast.makeText((Context)this, (int)R.string.album_check_little, (int)1).show();
            } else if (checkSize == 0) {
                this.setResult(0);
                this.finish();
            } else {
                ArrayList<String> pathList = new ArrayList<String>();
                for (AlbumImage albumImage : this.mCheckedImages) {
                    pathList.add(albumImage.getPath());
                }
                this.onGalleryCallback(pathList);
            }
        } else {
            this.setResult(0);
            this.finish();
        }
    }

    @Override
    public void onCheckedChanged(AlbumImage image, boolean isChecked) {
        if (isChecked && !this.mCheckedImages.contains(image)) {
            this.mCheckedImages.add(image);
        } else if (this.mCheckedImages.contains(image)) {
            this.mCheckedImages.remove(image);
        }
    }

    @Override
    public int getCheckedCount() {
        return this.mCheckedImages.size();
    }

    @Override
    public void onCameraBack(String imagePath) {
        new MediaScanner((Context)this).scan(imagePath);
        ArrayList<String> pathList = new ArrayList<String>();
        if (this.mCheckedImages.size() > 0) {
            for (AlbumImage albumImage : this.mCheckedImages) {
                pathList.add(albumImage.getPath());
            }
        }
        pathList.add(imagePath);
        this.onGalleryCallback(pathList);
    }

    @Override
    public void onPreviewChecked() {
        if (this.mCheckedImages.size() <= 0) {
            return;
        }
        AlbumPreviewFragment previewFragment = (AlbumPreviewFragment)NoFragment.instantiate((Context)this, AlbumPreviewFragment.class, (Bundle)this.mArgument);
        previewFragment.bindAlbumImages(this.mCheckedImages, 0);
        this.startFragment(previewFragment);
    }

    @Override
    public void onPreviewFolder(int folderPosition, int itemPosition) {
        ArrayList<AlbumImage> albumImages = this.mAlbumFolders.get(folderPosition).getImages();
        AlbumPreviewFragment previewFragment = (AlbumPreviewFragment)NoFragment.instantiate((Context)this, AlbumPreviewFragment.class, (Bundle)this.mArgument);
        previewFragment.bindAlbumImages(albumImages, itemPosition);
        this.startFragment(previewFragment);
    }
}

