/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album.adapter;

import android.content.Context;
import android.content.res.ColorStateList;
import android.support.v7.widget.AppCompatRadioButton;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.yanzhenjie.album.Album;
import com.yanzhenjie.album.R;
import com.yanzhenjie.album.entity.AlbumFolder;
import com.yanzhenjie.album.entity.AlbumImage;
import com.yanzhenjie.album.impl.OnCompatItemClickListener;
import com.yanzhenjie.album.task.LocalImageLoader;
import com.yanzhenjie.album.util.DisplayUtils;
import java.util.ArrayList;
import java.util.List;

public class AlbumFolderAdapter
extends RecyclerView.Adapter<FolderViewHolder> {
    private ColorStateList mButtonTint;
    private List<AlbumFolder> mAlbumFolders;
    private OnCompatItemClickListener mItemClickListener;
    private int checkPosition = 0;
    private static int size = DisplayUtils.dip2px(100.0f);

    public AlbumFolderAdapter(ColorStateList buttonTint, List<AlbumFolder> mAlbumFolders, OnCompatItemClickListener mItemClickListener) {
        this.mButtonTint = buttonTint;
        this.mAlbumFolders = mAlbumFolders;
        this.mItemClickListener = mItemClickListener;
    }

    public FolderViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new FolderViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.album_item_dialog_folder, parent, false));
    }

    public void onBindViewHolder(FolderViewHolder holder, int position) {
        final int newPosition = holder.getAdapterPosition();
        holder.setButtonTint(this.mButtonTint);
        holder.setData(this.mAlbumFolders.get(newPosition));
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlbumFolder albumFolder = (AlbumFolder)AlbumFolderAdapter.this.mAlbumFolders.get(newPosition);
                if (AlbumFolderAdapter.this.mItemClickListener != null) {
                    AlbumFolderAdapter.this.mItemClickListener.onItemClick(v, newPosition);
                }
                if (!albumFolder.isChecked()) {
                    albumFolder.setChecked(true);
                    ((AlbumFolder)AlbumFolderAdapter.this.mAlbumFolders.get(AlbumFolderAdapter.this.checkPosition)).setChecked(false);
                    AlbumFolderAdapter.this.notifyItemChanged(AlbumFolderAdapter.this.checkPosition);
                    AlbumFolderAdapter.this.notifyItemChanged(newPosition);
                    AlbumFolderAdapter.this.checkPosition = newPosition;
                }
            }
        });
    }

    public int getItemCount() {
        return this.mAlbumFolders == null ? 0 : this.mAlbumFolders.size();
    }

    static class FolderViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mIvImage;
        private TextView mTvTitle;
        private AppCompatRadioButton mRbCheck;

        public FolderViewHolder(View itemView) {
            super(itemView);
            this.mIvImage = (ImageView)itemView.findViewById(R.id.iv_gallery_preview_image);
            this.mTvTitle = (TextView)itemView.findViewById(R.id.tv_gallery_preview_title);
            this.mRbCheck = (AppCompatRadioButton)itemView.findViewById(R.id.rb_gallery_preview_check);
        }

        public void setButtonTint(ColorStateList colorStateList) {
            this.mRbCheck.setSupportButtonTintList(colorStateList);
        }

        public void setData(AlbumFolder albumFolder) {
            ArrayList<AlbumImage> albumImages = albumFolder.getImages();
            this.mTvTitle.setText((CharSequence)("(" + albumImages.size() + ") " + albumFolder.getName()));
            this.mRbCheck.setChecked(albumFolder.isChecked());
            if (albumImages.size() > 0) {
                Album.getAlbumConfig().getImageLoader().loadImage(this.mIvImage, ((AlbumImage)albumImages.get(0)).getPath(), size, size);
            } else {
                this.mIvImage.setImageDrawable(LocalImageLoader.DEFAULT_DRAWABLE);
            }
        }
    }
}

