/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album.adapter;

import android.content.Context;
import android.content.res.ColorStateList;
import android.support.annotation.ColorInt;
import android.support.v7.widget.AppCompatCheckBox;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.ImageView;
import com.yanzhenjie.album.Album;
import com.yanzhenjie.album.R;
import com.yanzhenjie.album.entity.AlbumImage;
import com.yanzhenjie.album.impl.OnCompatItemClickListener;
import com.yanzhenjie.album.impl.OnCompoundItemCheckListener;
import com.yanzhenjie.album.util.SelectorUtils;
import java.util.List;

public class AlbumImageAdapter
extends RecyclerView.Adapter<ItemViewHolder> {
    private static final int TYPE_BUTTON = 1;
    private static final int TYPE_IMAGE = 2;
    private boolean hasCamera;
    private LayoutInflater mInflater;
    private ColorStateList mColorStateList;
    private List<AlbumImage> mAlbumImages;
    private OnCompatItemClickListener mAddPhotoClickListener;
    private OnCompatItemClickListener mItemClickListener;
    private OnCompoundItemCheckListener mOnCompatCheckListener;
    private int itemSize;

    public AlbumImageAdapter(Context context, boolean hasCamera, int itemSize, @ColorInt int normalColor, @ColorInt int checkColor) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.hasCamera = hasCamera;
        this.itemSize = itemSize;
        this.mColorStateList = SelectorUtils.createColorStateList(normalColor, checkColor);
    }

    public void notifyDataSetChanged(List<AlbumImage> albumImages) {
        this.mAlbumImages = albumImages;
        super.notifyDataSetChanged();
    }

    public void setAddPhotoClickListener(OnCompatItemClickListener addPhotoClickListener) {
        this.mAddPhotoClickListener = addPhotoClickListener;
    }

    public void setItemClickListener(OnCompatItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    public int getItemCount() {
        int camera = this.hasCamera ? 1 : 0;
        return this.mAlbumImages == null ? camera : this.mAlbumImages.size() + camera;
    }

    public int getItemViewType(int position) {
        switch (position) {
            case 0: {
                return this.hasCamera ? 1 : 2;
            }
        }
        return 2;
    }

    public void setOnCheckListener(OnCompoundItemCheckListener checkListener) {
        this.mOnCompatCheckListener = checkListener;
    }

    public ItemViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ItemViewHolder viewHolder;
        switch (viewType) {
            case 1: {
                viewHolder = new ItemViewHolder(this.mInflater.inflate(R.layout.album_item_content_button, parent, false), this.hasCamera, this.itemSize);
                break;
            }
            default: {
                viewHolder = new ImageHolder(this.mInflater.inflate(R.layout.album_item_content_image, parent, false), this.hasCamera, this.itemSize);
            }
        }
        return viewHolder;
    }

    public void onBindViewHolder(ItemViewHolder holder, int position) {
        switch (this.getItemViewType(position)) {
            case 1: {
                holder.mItemClickListener = this.mAddPhotoClickListener;
                break;
            }
            default: {
                int camera = this.hasCamera ? 1 : 0;
                int imagePosition = holder.getAdapterPosition() - camera;
                AlbumImage albumImage = this.mAlbumImages.get(imagePosition);
                ImageHolder imageHolder = (ImageHolder)holder;
                imageHolder.mItemClickListener = this.mItemClickListener;
                imageHolder.mOnCompatCheckListener = this.mOnCompatCheckListener;
                imageHolder.setButtonTint(this.mColorStateList);
                imageHolder.setData(albumImage);
                break;
            }
        }
    }

    static class ItemViewHolder
    extends RecyclerView.ViewHolder {
        final boolean hasCamera;
        final int itemSize;
        OnCompatItemClickListener mItemClickListener;
        private final View.OnClickListener mClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (ItemViewHolder.this.mItemClickListener != null && v == ItemViewHolder.this.itemView) {
                    int camera = ItemViewHolder.this.hasCamera ? 1 : 0;
                    ItemViewHolder.this.mItemClickListener.onItemClick(v, ItemViewHolder.this.getAdapterPosition() - camera);
                }
            }
        };

        public ItemViewHolder(View itemView, boolean hasCamera, int itemSize) {
            super(itemView);
            this.hasCamera = hasCamera;
            this.itemSize = itemSize;
            itemView.getLayoutParams().height = itemSize;
            itemView.setOnClickListener(this.mClickListener);
        }
    }

    private static class ImageHolder
    extends ItemViewHolder
    implements View.OnClickListener {
        private ImageView mIvImage;
        private AppCompatCheckBox mCbChecked;
        private OnCompoundItemCheckListener mOnCompatCheckListener;

        public ImageHolder(View itemView, boolean hasCamera, int itemSize) {
            super(itemView, hasCamera, itemSize);
            this.mIvImage = (ImageView)itemView.findViewById(R.id.iv_album_content_image);
            this.mCbChecked = (AppCompatCheckBox)itemView.findViewById(R.id.cb_album_check);
            this.mCbChecked.setOnClickListener((View.OnClickListener)this);
        }

        public void setButtonTint(ColorStateList colorStateList) {
            this.mCbChecked.setSupportButtonTintList(colorStateList);
        }

        public void setData(AlbumImage albumImage) {
            this.mCbChecked.setChecked(albumImage.isChecked());
            Album.getAlbumConfig().getImageLoader().loadImage(this.mIvImage, albumImage.getPath(), this.itemSize, this.itemSize);
        }

        public void onClick(View v) {
            if (this.mOnCompatCheckListener != null && v == this.mCbChecked) {
                boolean isChecked = this.mCbChecked.isChecked();
                int camera = this.hasCamera ? 1 : 0;
                this.mOnCompatCheckListener.onCheckedChanged((CompoundButton)this.mCbChecked, this.getAdapterPosition() - camera, isChecked);
            }
        }
    }
}

