/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album.dialog;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.R;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialog;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.Window;
import com.yanzhenjie.album.R;
import com.yanzhenjie.album.adapter.AlbumFolderAdapter;
import com.yanzhenjie.album.entity.AlbumFolder;
import com.yanzhenjie.album.impl.OnCompatItemClickListener;
import com.yanzhenjie.album.util.SelectorUtils;
import java.util.List;

public class AlbumFolderDialog
extends BottomSheetDialog {
    private int mCurrentPosition = 0;
    private BottomSheetBehavior bottomSheetBehavior;
    private OnCompatItemClickListener mItemClickListener;

    public AlbumFolderDialog(@NonNull Context context, @ColorInt int toolbarColor, @ColorInt int navigationColor, @Nullable List<AlbumFolder> albumFolders, @Nullable OnCompatItemClickListener itemClickListener) {
        super(context, R.style.AlbumDialogStyle_Folder);
        this.setContentView(R.layout.album_dialog_floder);
        this.setWindowBarColor(toolbarColor, navigationColor);
        this.fixRestart();
        this.mItemClickListener = itemClickListener;
        RecyclerView rvContentList = (RecyclerView)this.findViewById(R.id.rv_content_list);
        assert (rvContentList != null);
        rvContentList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        ColorStateList stateList = SelectorUtils.createColorStateList(ContextCompat.getColor((Context)context, (int)R.color.albumColorPrimaryBlack), toolbarColor);
        rvContentList.setAdapter((RecyclerView.Adapter)new AlbumFolderAdapter(stateList, albumFolders, new OnCompatItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                AlbumFolderDialog.this.behaviorHide();
                if (AlbumFolderDialog.this.mItemClickListener != null && AlbumFolderDialog.this.mCurrentPosition != position) {
                    AlbumFolderDialog.this.mCurrentPosition = position;
                    AlbumFolderDialog.this.mItemClickListener.onItemClick(view, position);
                }
            }
        }));
    }

    private void setWindowBarColor(@ColorInt int statusColor, @ColorInt int navigationColor) {
        Window window;
        if (Build.VERSION.SDK_INT >= 21 && (window = this.getWindow()) != null) {
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(statusColor);
            window.setNavigationBarColor(navigationColor);
        }
    }

    private void fixRestart() {
        View view = this.findViewById(R.id.design_bottom_sheet);
        if (view == null) {
            return;
        }
        this.bottomSheetBehavior = BottomSheetBehavior.from((View)view);
        this.bottomSheetBehavior.setBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(){

            public void onStateChanged(@NonNull View bottomSheet, int newState) {
                if (newState == 5) {
                    AlbumFolderDialog.this.dismiss();
                    AlbumFolderDialog.this.bottomSheetBehavior.setState(4);
                }
            }

            public void onSlide(@NonNull View bottomSheet, float slideOffset) {
            }
        });
    }

    public void behaviorHide() {
        this.bottomSheetBehavior.setState(5);
    }
}

