/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album.fragment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.Toast;
import com.yanzhenjie.album.R;
import com.yanzhenjie.album.adapter.AlbumImageAdapter;
import com.yanzhenjie.album.dialog.AlbumFolderDialog;
import com.yanzhenjie.album.entity.AlbumFolder;
import com.yanzhenjie.album.entity.AlbumImage;
import com.yanzhenjie.album.fragment.BasicCameraFragment;
import com.yanzhenjie.album.fragment.CameraCallback;
import com.yanzhenjie.album.impl.OnCompatItemClickListener;
import com.yanzhenjie.album.impl.OnCompoundItemCheckListener;
import com.yanzhenjie.album.util.DisplayUtils;
import com.yanzhenjie.album.widget.recyclerview.AlbumVerticalGirdDecoration;
import java.util.List;
import java.util.Locale;

public class AlbumFragment
extends BasicCameraFragment {
    private Callback mCallback;
    private int mToolBarColor;
    private int mNavigationColor;
    private Button mBtnPreview;
    private Button mBtnSwitchFolder;
    private RecyclerView mRvContentList;
    private GridLayoutManager mLayoutManager;
    private AlbumImageAdapter mAlbumContentAdapter;
    private List<AlbumFolder> mAlbumFolders;
    private int mCurrentFolderPosition;
    private int mAllowSelectCount;
    private AlbumFolderDialog mAlbumFolderDialog;
    private View.OnClickListener mSwitchDirClick = new View.OnClickListener(){

        public void onClick(View v) {
            if (AlbumFragment.this.mAlbumFolderDialog == null) {
                AlbumFragment.this.mAlbumFolderDialog = new AlbumFolderDialog(AlbumFragment.this.getContext(), AlbumFragment.this.mToolBarColor, AlbumFragment.this.mNavigationColor, AlbumFragment.this.mAlbumFolders, new OnCompatItemClickListener(){

                    @Override
                    public void onItemClick(View view, int position) {
                        if (AlbumFragment.this.mAlbumFolders.size() > position) {
                            AlbumFragment.this.mCurrentFolderPosition = position;
                            AlbumFragment.this.showImageFromFolder(AlbumFragment.this.mCurrentFolderPosition);
                            AlbumFragment.this.mLayoutManager.scrollToPosition(0);
                        }
                    }
                });
            }
            if (!AlbumFragment.this.mAlbumFolderDialog.isShowing()) {
                AlbumFragment.this.mAlbumFolderDialog.show();
            }
        }
    };
    private OnCompatItemClickListener mAddPhotoListener = new OnCompatItemClickListener(){

        @Override
        public void onItemClick(View view, int position) {
            int hasCheckSize = AlbumFragment.this.mCallback.getCheckedCount();
            if (hasCheckSize == AlbumFragment.this.mAllowSelectCount) {
                Toast.makeText((Context)AlbumFragment.this.getContext(), (CharSequence)String.format(Locale.getDefault(), AlbumFragment.this.getString(R.string.album_check_limit_camera), AlbumFragment.this.mAllowSelectCount), (int)1).show();
            } else {
                AlbumFragment.this.cameraUnKnowPermission();
            }
        }
    };
    private OnCompoundItemCheckListener mItemCheckListener = new OnCompoundItemCheckListener(){

        @Override
        public void onCheckedChanged(CompoundButton buttonView, int position, boolean isChecked) {
            AlbumImage albumImage = ((AlbumFolder)AlbumFragment.this.mAlbumFolders.get(AlbumFragment.this.mCurrentFolderPosition)).getImages().get(position);
            albumImage.setChecked(isChecked);
            AlbumFragment.this.mCallback.onCheckedChanged(albumImage, isChecked);
            int hasCheckSize = AlbumFragment.this.mCallback.getCheckedCount();
            if (hasCheckSize > AlbumFragment.this.mAllowSelectCount) {
                Toast.makeText((Context)AlbumFragment.this.getContext(), (CharSequence)String.format(Locale.getDefault(), AlbumFragment.this.getString(R.string.album_check_limit), AlbumFragment.this.mAllowSelectCount), (int)1).show();
                AlbumFragment.this.mCallback.onCheckedChanged(albumImage, false);
                buttonView.setChecked(false);
                albumImage.setChecked(false);
            } else {
                AlbumFragment.this.setCheckedCountUI(hasCheckSize);
            }
        }
    };
    private View.OnClickListener mPreviewClick = new View.OnClickListener(){

        public void onClick(View v) {
            AlbumFragment.this.mCallback.onPreviewChecked();
        }
    };

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mCallback = (Callback)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mCallback = null;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.album_fragment_album, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        this.mBtnPreview = (Button)view.findViewById(R.id.btn_preview);
        this.mBtnSwitchFolder = (Button)view.findViewById(R.id.btn_switch_dir);
        this.mRvContentList = (RecyclerView)view.findViewById(R.id.rv_content_list);
        this.setToolbar((Toolbar)view.findViewById(R.id.toolbar));
        this.displayHomeAsUpEnabled(R.drawable.album_ic_back_white);
        this.mBtnSwitchFolder.setOnClickListener(this.mSwitchDirClick);
        this.mBtnPreview.setOnClickListener(this.mPreviewClick);
    }

    public boolean onInterceptToolbarBack() {
        this.mCallback.doResult(false);
        return true;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Bundle argument = this.getArguments();
        this.mToolBarColor = argument.getInt("KEY_INPUT_TOOLBAR_COLOR", ContextCompat.getColor((Context)this.getContext(), (int)R.color.albumColorPrimary));
        String title = argument.getString("KEY_INPUT_TITLE");
        if (TextUtils.isEmpty((CharSequence)title)) {
            title = this.getString(R.string.album_title);
        }
        this.mNavigationColor = argument.getInt("KEY_INPUT_NAVIGATION_COLOR", ContextCompat.getColor((Context)this.getContext(), (int)R.color.albumColorPrimaryBlack));
        int columnCount = argument.getInt("KEY_INPUT_COLUMN_COUNT", 2);
        this.mAllowSelectCount = argument.getInt("KEY_INPUT_LIMIT_COUNT", Integer.MAX_VALUE);
        boolean hasCamera = argument.getBoolean("KEY_INPUT_ALLOW_CAMERA", true);
        this.getToolbar().setBackgroundColor(this.mToolBarColor);
        this.setTitle(title);
        this.mLayoutManager = new GridLayoutManager(this.getContext(), columnCount);
        this.mRvContentList.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        Drawable decoration = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.album_decoration_white);
        this.mRvContentList.addItemDecoration((RecyclerView.ItemDecoration)new AlbumVerticalGirdDecoration(decoration));
        int itemSize = (DisplayUtils.screenWidth - decoration.getIntrinsicWidth() * (columnCount + 1)) / columnCount;
        this.mAlbumContentAdapter = new AlbumImageAdapter(this.getContext(), hasCamera, itemSize, ContextCompat.getColor((Context)this.getContext(), (int)R.color.albumWhiteGray), this.mToolBarColor);
        this.mAlbumContentAdapter.setAddPhotoClickListener(this.mAddPhotoListener);
        this.mAlbumContentAdapter.setOnCheckListener(this.mItemCheckListener);
        this.mAlbumContentAdapter.setItemClickListener(new OnCompatItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                AlbumFragment.this.mCallback.onPreviewFolder(AlbumFragment.this.mCurrentFolderPosition, position);
            }
        });
        this.mRvContentList.setAdapter((RecyclerView.Adapter)this.mAlbumContentAdapter);
    }

    public void onResume() {
        super.onResume();
        this.showImageFromFolder(this.mCurrentFolderPosition);
        this.setCheckedCountUI(this.mCallback.getCheckedCount());
    }

    public void bindAlbumFolders(List<AlbumFolder> albumFolders) {
        this.mAlbumFolders = albumFolders;
    }

    private void showImageFromFolder(int position) {
        AlbumFolder albumFolder = this.mAlbumFolders.get(position);
        this.mBtnSwitchFolder.setText((CharSequence)albumFolder.getName());
        this.mAlbumContentAdapter.notifyDataSetChanged(albumFolder.getImages());
    }

    @Override
    protected void onCameraBack(String imagePath) {
        this.mCallback.onCameraBack(imagePath);
    }

    public void setCheckedCountUI(int count) {
        this.mBtnPreview.setText((CharSequence)(" (" + count + ")"));
        this.getToolbar().setSubtitle((CharSequence)(count + "/" + this.mAllowSelectCount));
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.album_menu_album, menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == 16908332) {
            this.mCallback.doResult(false);
        } else if (itemId == R.id.album_menu_finish) {
            this.mCallback.doResult(true);
        }
        return true;
    }

    public static interface Callback
    extends CameraCallback,
    com.yanzhenjie.album.fragment.Callback {
        public void onPreviewChecked();

        public void onPreviewFolder(int var1, int var2);
    }
}

