/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album.fragment;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatButton;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yanzhenjie.album.R;
import com.yanzhenjie.album.fragment.BasicCameraFragment;
import com.yanzhenjie.album.fragment.CameraCallback;
import com.yanzhenjie.album.util.SelectorUtils;

public class AlbumNullFragment
extends BasicCameraFragment {
    private CameraCallback mCallback;
    private AppCompatButton mBtnCamera;
    private View.OnClickListener mCameraClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            AlbumNullFragment.this.cameraUnKnowPermission();
        }
    };

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mCallback = (CameraCallback)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mCallback = null;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.album_fragment_null, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        this.setToolbar((Toolbar)view.findViewById(R.id.toolbar));
        this.displayHomeAsUpEnabled(R.drawable.album_ic_back_white);
        this.setTitle(R.string.album_title_not_found_image);
        this.mBtnCamera = (AppCompatButton)view.findViewById(R.id.btn_camera);
        this.mBtnCamera.setOnClickListener(this.mCameraClickListener);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Bundle argument = this.getArguments();
        int toolBarColor = argument.getInt("KEY_INPUT_TOOLBAR_COLOR", ContextCompat.getColor((Context)this.getContext(), (int)R.color.albumColorPrimary));
        int statusBarColor = argument.getInt("KEY_INPUT_STATUS_COLOR", ContextCompat.getColor((Context)this.getContext(), (int)R.color.albumColorPrimaryBlack));
        this.getToolbar().setBackgroundColor(toolBarColor);
        ColorStateList stateList = SelectorUtils.createColorStateList(toolBarColor, statusBarColor);
        this.mBtnCamera.setSupportBackgroundTintList(stateList);
    }

    @Override
    protected void onCameraBack(String imagePath) {
        this.mCallback.onCameraBack(imagePath);
    }
}

