/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.AppCompatCheckBox;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.yanzhenjie.album.R;
import com.yanzhenjie.album.adapter.AlbumImagePreviewAdapter;
import com.yanzhenjie.album.entity.AlbumImage;
import com.yanzhenjie.album.fragment.Callback;
import com.yanzhenjie.album.util.SelectorUtils;
import com.yanzhenjie.fragment.NoFragment;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class AlbumPreviewFragment
extends NoFragment {
    private Callback mCallback;
    private int mToolBarColor;
    private MenuItem mFinishMenuItem;
    private AppCompatCheckBox mCheckBox;
    private ViewPager mViewPager;
    private List<AlbumImage> mAlbumImages;
    private int mCurrentItemPosition;
    private int mAllowSelectCount;

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mCallback = (Callback)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mCallback = null;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.album_fragment_preview, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        this.mCheckBox = (AppCompatCheckBox)view.findViewById(R.id.cb_album_check);
        this.mViewPager = (ViewPager)view.findViewById(R.id.view_pager);
        this.setToolbar((Toolbar)view.findViewById(R.id.toolbar));
        this.displayHomeAsUpEnabled(R.drawable.album_ic_back_white);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Bundle argument = this.getArguments();
        this.mToolBarColor = argument.getInt("KEY_INPUT_TOOLBAR_COLOR", ContextCompat.getColor((Context)this.getContext(), (int)R.color.albumColorPrimary));
        this.mAllowSelectCount = argument.getInt("KEY_INPUT_LIMIT_COUNT", Integer.MAX_VALUE);
        this.getToolbar().setBackgroundColor(this.mToolBarColor);
        this.getToolbar().getBackground().mutate().setAlpha(200);
        this.initializeCheckBox();
        this.initializeViewPager();
        this.setCheckedCountUI(this.mCallback.getCheckedCount());
    }

    public void bindAlbumImages(List<AlbumImage> albumImages, int currentItemPosition) {
        this.mAlbumImages = new ArrayList<AlbumImage>();
        this.mAlbumImages.addAll(albumImages);
        this.mCurrentItemPosition = currentItemPosition;
    }

    private void initializeCheckBox() {
        this.mCheckBox.setSupportButtonTintList(SelectorUtils.createColorStateList(-1, this.mToolBarColor));
        this.mCheckBox.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean isChecked = AlbumPreviewFragment.this.mCheckBox.isChecked();
                AlbumImage albumImage = (AlbumImage)AlbumPreviewFragment.this.mAlbumImages.get(AlbumPreviewFragment.this.mCurrentItemPosition);
                albumImage.setChecked(isChecked);
                AlbumPreviewFragment.this.mCallback.onCheckedChanged(albumImage, isChecked);
                int hasCheckSize = AlbumPreviewFragment.this.mCallback.getCheckedCount();
                if (hasCheckSize > AlbumPreviewFragment.this.mAllowSelectCount) {
                    Toast.makeText((Context)AlbumPreviewFragment.this.getContext(), (CharSequence)String.format(Locale.getDefault(), AlbumPreviewFragment.this.getString(R.string.album_check_limit), AlbumPreviewFragment.this.mAllowSelectCount), (int)1).show();
                    AlbumPreviewFragment.this.mCallback.onCheckedChanged(albumImage, false);
                    AlbumPreviewFragment.this.mCheckBox.setChecked(false);
                    albumImage.setChecked(false);
                } else {
                    AlbumPreviewFragment.this.setCheckedCountUI(hasCheckSize);
                }
            }
        });
    }

    private void initializeViewPager() {
        if (this.mAlbumImages.size() > 2) {
            this.mViewPager.setOffscreenPageLimit(2);
        }
        AlbumImagePreviewAdapter previewAdapter = new AlbumImagePreviewAdapter(this.mAlbumImages);
        this.mViewPager.setAdapter((PagerAdapter)previewAdapter);
        ViewPager.SimpleOnPageChangeListener pageChangeListener = new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                AlbumPreviewFragment.this.mCurrentItemPosition = position;
                AlbumImage albumImage = (AlbumImage)AlbumPreviewFragment.this.mAlbumImages.get(AlbumPreviewFragment.this.mCurrentItemPosition);
                AlbumPreviewFragment.this.mCheckBox.setChecked(albumImage.isChecked());
                AlbumPreviewFragment.this.getToolbar().setTitle((CharSequence)(AlbumPreviewFragment.this.mCurrentItemPosition + 1 + " / " + AlbumPreviewFragment.this.mAlbumImages.size()));
            }
        };
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)pageChangeListener);
        this.mViewPager.setCurrentItem(this.mCurrentItemPosition);
        pageChangeListener.onPageSelected(this.mCurrentItemPosition);
    }

    private void setCheckedCountUI(int count) {
        String finishStr = this.getString(R.string.album_menu_finish);
        finishStr = finishStr + "(" + count + " / " + this.mAllowSelectCount + ")";
        this.mFinishMenuItem.setTitle((CharSequence)finishStr);
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.album_menu_preview, menu2);
        this.mFinishMenuItem = menu2.findItem(R.id.album_menu_finish);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.album_menu_finish) {
            this.mCallback.doResult(true);
        }
        return true;
    }
}

