/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album.task;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.provider.MediaStore;
import com.yanzhenjie.album.R;
import com.yanzhenjie.album.dialog.AlbumWaitDialog;
import com.yanzhenjie.album.entity.AlbumFolder;
import com.yanzhenjie.album.entity.AlbumImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScanTask
extends AsyncTask<List<String>, Void, List<AlbumFolder>> {
    private static final String[] STORE_IMAGES = new String[]{"_id", "_data", "_display_name", "date_added", "bucket_id", "bucket_display_name"};
    private Context mContext;
    private Callback mCallback;
    private List<AlbumImage> mCheckedImages;
    private AlbumWaitDialog mWaitDialog;

    public ScanTask(Context context, Callback callback, List<AlbumImage> checkedImages) {
        this.mContext = context;
        this.mCallback = callback;
        this.mCheckedImages = checkedImages;
        this.mWaitDialog = new AlbumWaitDialog(context);
    }

    protected void onPreExecute() {
        if (!this.mWaitDialog.isShowing()) {
            this.mWaitDialog.show();
        }
    }

    protected void onPostExecute(List<AlbumFolder> albumFolders) {
        if (this.mWaitDialog.isShowing()) {
            this.mWaitDialog.dismiss();
        }
        this.mCallback.onScanCallback(albumFolders);
    }

    @SafeVarargs
    protected final List<AlbumFolder> doInBackground(List<String> ... params) {
        List<AlbumFolder> folders = this.getPhotoAlbum(this.mContext);
        List<String> checkedList = params[0];
        if (checkedList != null && checkedList.size() > 0) {
            ArrayList<AlbumImage> images = folders.get(0).getImages();
            for (String path : checkedList) {
                for (int i = 0; i < images.size(); ++i) {
                    AlbumImage image = (AlbumImage)images.get(i);
                    if (!path.equals(image.getPath())) continue;
                    image.setChecked(true);
                    this.mCheckedImages.add(image);
                }
            }
        }
        return folders;
    }

    private List<AlbumFolder> getPhotoAlbum(Context context) {
        Cursor cursor = MediaStore.Images.Media.query((ContentResolver)context.getContentResolver(), (Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (String[])STORE_IMAGES);
        HashMap<String, AlbumFolder> albumFolderMap = new HashMap<String, AlbumFolder>();
        AlbumFolder allImageAlbumFolder = new AlbumFolder();
        allImageAlbumFolder.setChecked(true);
        allImageAlbumFolder.setName(context.getString(R.string.album_all_image));
        while (cursor.moveToNext()) {
            int imageId = cursor.getInt(0);
            String imagePath = cursor.getString(1);
            String imageName = cursor.getString(2);
            long addTime = cursor.getLong(3);
            int bucketId = cursor.getInt(4);
            String bucketName = cursor.getString(5);
            AlbumImage albumImage = new AlbumImage();
            albumImage.setId(imageId);
            albumImage.setPath(imagePath);
            albumImage.setName(imageName);
            albumImage.setAddTime(addTime);
            allImageAlbumFolder.addPhoto(albumImage);
            AlbumFolder albumFolder = (AlbumFolder)albumFolderMap.get(bucketName);
            if (albumFolder != null) {
                albumFolder.addPhoto(albumImage);
                continue;
            }
            albumFolder = new AlbumFolder();
            albumFolder.setId(bucketId);
            albumFolder.setName(bucketName);
            albumFolder.addPhoto(albumImage);
            albumFolderMap.put(bucketName, albumFolder);
        }
        cursor.close();
        ArrayList<AlbumFolder> albumFolders = new ArrayList<AlbumFolder>();
        Collections.sort(allImageAlbumFolder.getImages());
        albumFolders.add(allImageAlbumFolder);
        for (Map.Entry folderEntry : albumFolderMap.entrySet()) {
            AlbumFolder albumFolder = (AlbumFolder)folderEntry.getValue();
            Collections.sort(albumFolder.getImages());
            albumFolders.add(albumFolder);
        }
        return albumFolders;
    }

    public static interface Callback {
        public void onScanCallback(List<AlbumFolder> var1);
    }
}

