/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album.widget.loading;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.animation.LinearInterpolator;
import com.yanzhenjie.album.util.DisplayUtils;

public abstract class LoadingRenderer {
    private static final long ANIMATION_DURATION = 1333L;
    private static final float DEFAULT_SIZE = 56.0f;
    private final ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            LoadingRenderer.this.computeRender(((Float)animation.getAnimatedValue()).floatValue());
            LoadingRenderer.this.invalidateSelf();
        }
    };
    protected final Rect mBounds = new Rect();
    private Drawable.Callback mCallback;
    private ValueAnimator mRenderAnimator;
    protected long mDuration = 1333L;
    protected float mWidth = DisplayUtils.dip2px(56.0f);
    protected float mHeight = DisplayUtils.dip2px(56.0f);

    public LoadingRenderer(Context context) {
        this.setupAnimators();
    }

    @Deprecated
    protected void draw(Canvas canvas, Rect bounds) {
    }

    protected void draw(Canvas canvas) {
        this.draw(canvas, this.mBounds);
    }

    protected abstract void computeRender(float var1);

    protected abstract void setAlpha(int var1);

    protected abstract void setColorFilter(ColorFilter var1);

    protected abstract void reset();

    protected void addRenderListener(Animator.AnimatorListener animatorListener) {
        this.mRenderAnimator.addListener(animatorListener);
    }

    void start() {
        this.reset();
        this.mRenderAnimator.addUpdateListener(this.mAnimatorUpdateListener);
        this.mRenderAnimator.setRepeatCount(-1);
        this.mRenderAnimator.setDuration(this.mDuration);
        this.mRenderAnimator.start();
    }

    void stop() {
        this.mRenderAnimator.removeUpdateListener(this.mAnimatorUpdateListener);
        this.mRenderAnimator.setRepeatCount(0);
        this.mRenderAnimator.setDuration(0L);
        this.mRenderAnimator.end();
    }

    boolean isRunning() {
        return this.mRenderAnimator.isRunning();
    }

    void setCallback(Drawable.Callback callback) {
        this.mCallback = callback;
    }

    void setBounds(Rect bounds) {
        this.mBounds.set(bounds);
    }

    private void setupAnimators() {
        this.mRenderAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mRenderAnimator.setRepeatCount(-1);
        this.mRenderAnimator.setRepeatMode(1);
        this.mRenderAnimator.setDuration(this.mDuration);
        this.mRenderAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mRenderAnimator.addUpdateListener(this.mAnimatorUpdateListener);
    }

    private void invalidateSelf() {
        this.mCallback.invalidateDrawable(null);
    }
}

