/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album.widget.recyclerview;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class AlbumVerticalGirdDecoration
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;

    public AlbumVerticalGirdDecoration(Drawable drawable2) {
        this.mDivider = drawable2;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildLayoutPosition(view);
        int spanCount = this.getSpanCount(parent);
        int childCount = parent.getAdapter().getItemCount();
        boolean lastRaw = this.isLastRaw(position, spanCount, childCount);
        boolean lastColumn = this.isLastColumn(position, spanCount);
        if (Build.VERSION.SDK_INT >= 21) {
            boolean isFirstRaw = this.isFirstRaw(position, spanCount);
            if (isFirstRaw && lastColumn) {
                outRect.set(this.mDivider.getIntrinsicWidth(), this.mDivider.getIntrinsicHeight(), this.mDivider.getIntrinsicWidth(), this.mDivider.getIntrinsicHeight());
            } else if (isFirstRaw) {
                outRect.set(this.mDivider.getIntrinsicWidth(), this.mDivider.getIntrinsicHeight(), 0, this.mDivider.getIntrinsicHeight());
            } else if (lastRaw && lastColumn) {
                outRect.set(this.mDivider.getIntrinsicWidth(), 0, this.mDivider.getIntrinsicWidth(), this.mDivider.getIntrinsicHeight());
            } else if (lastRaw) {
                outRect.set(this.mDivider.getIntrinsicWidth(), 0, 0, this.mDivider.getIntrinsicHeight());
            } else if (lastColumn) {
                outRect.set(this.mDivider.getIntrinsicWidth(), 0, this.mDivider.getIntrinsicWidth(), this.mDivider.getIntrinsicHeight());
            } else {
                outRect.set(this.mDivider.getIntrinsicWidth(), 0, 0, this.mDivider.getIntrinsicHeight());
            }
        } else if (lastRaw && lastColumn) {
            outRect.set(0, 0, 0, 0);
        } else if (lastRaw) {
            outRect.set(0, 0, this.mDivider.getIntrinsicWidth(), 0);
        } else if (lastColumn) {
            outRect.set(0, 0, 0, this.mDivider.getIntrinsicHeight());
        } else {
            outRect.set(0, 0, this.mDivider.getIntrinsicWidth(), this.mDivider.getIntrinsicHeight());
        }
    }

    private int getSpanCount(RecyclerView parent) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            return ((GridLayoutManager)layoutManager).getSpanCount();
        }
        return 1;
    }

    private boolean isFirstRaw(int position, int spanCount) {
        return position < spanCount;
    }

    private boolean isLastRaw(int position, int spanCount, int childCount) {
        if (spanCount == 1) {
            return position == childCount;
        }
        int lastRawItemCount = childCount % spanCount;
        int rawCount = (childCount - lastRawItemCount) / spanCount + (lastRawItemCount > 0 ? 1 : 0);
        int positionRawCount = (position + 1) % spanCount;
        if (positionRawCount == 0) {
            return rawCount == (position + 1) / spanCount;
        }
        return rawCount == (position + 1 - positionRawCount) / spanCount + 1;
    }

    private boolean isLastColumn(int position, int spanCount) {
        return spanCount == 1 || (position + 1) % spanCount == 0;
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        this.drawHorizontal(c, parent);
        this.drawVertical(c, parent);
    }

    public void drawHorizontal(Canvas c, RecyclerView parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            int left = child.getLeft();
            int top = child.getBottom();
            int right = child.getRight();
            int bottom = top + this.mDivider.getIntrinsicHeight();
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }

    public void drawVertical(Canvas c, RecyclerView parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            int left = child.getRight();
            int top = child.getTop();
            int right = left + this.mDivider.getIntrinsicWidth();
            int bottom = child.getBottom();
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }
}

