/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.mediascanner;

import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import com.yanzhenjie.mediascanner.ScannerListener;
import java.util.List;

public class MediaScanner
implements MediaScannerConnection.MediaScannerConnectionClient {
    private MediaScannerConnection mMediaScanConn;
    private ScannerListener mScannerListener;
    private String[] filePaths;
    private int scanCount = 0;

    public MediaScanner(Context context) {
        this(context, null);
    }

    public MediaScanner(Context context, ScannerListener scannerListener) {
        this.mMediaScanConn = new MediaScannerConnection(context, (MediaScannerConnection.MediaScannerConnectionClient)this);
        this.mScannerListener = scannerListener;
    }

    public boolean isRunning() {
        return this.mMediaScanConn.isConnected();
    }

    public void scan(String filePath) {
        this.scan(new String[]{filePath});
    }

    public void scan(List<String> filePaths) {
        this.scan(filePaths.toArray(new String[filePaths.size()]));
    }

    public void scan(String[] filePaths) {
        if (this.isRunning()) {
            throw new RuntimeException("The scanner is running.");
        }
        this.filePaths = filePaths;
        this.mMediaScanConn.connect();
    }

    public void onMediaScannerConnected() {
        if (this.filePaths != null && this.filePaths.length > 0) {
            for (String filePath : this.filePaths) {
                String extension = MimeTypeMap.getFileExtensionFromUrl((String)filePath);
                String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
                this.mMediaScanConn.scanFile(filePath, mimeType);
            }
        }
    }

    public void onScanCompleted(String path, Uri uri) {
        if (this.mScannerListener != null) {
            this.mScannerListener.oneComplete(path, uri);
        }
        ++this.scanCount;
        if (this.scanCount == this.filePaths.length) {
            this.mMediaScanConn.disconnect();
            if (this.mScannerListener != null) {
                this.mScannerListener.allComplete(this.filePaths);
            }
        }
    }
}

