/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.ActivityCompat;

class PermissionUtils {
    PermissionUtils() {
    }

    static Context getContext(Object o) {
        if (o instanceof Activity) {
            return (Activity)o;
        }
        if (o instanceof android.support.v4.app.Fragment) {
            return ((android.support.v4.app.Fragment)o).getActivity();
        }
        if (o instanceof Fragment) {
            ((Fragment)o).getActivity();
        }
        throw new IllegalArgumentException("The " + o.getClass().getName() + " is not support.");
    }

    static boolean shouldShowRationalePermissions(Object o, String ... permissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        boolean rationale = false;
        for (String permission : permissions) {
            if (o instanceof Activity) {
                rationale = ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)o), (String)permission);
            } else if (o instanceof android.support.v4.app.Fragment) {
                rationale = ((android.support.v4.app.Fragment)o).shouldShowRequestPermissionRationale(permission);
            } else if (o instanceof Fragment) {
                rationale = ((Fragment)o).shouldShowRequestPermissionRationale(permission);
            }
            if (!rationale) continue;
            return true;
        }
        return false;
    }
}

