/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission;

import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import com.yanzhenjie.alertdialog.AlertDialog;
import com.yanzhenjie.permission.R;
import com.yanzhenjie.permission.SettingService;

public class SettingDialog {
    private AlertDialog.Builder mBuilder;
    private SettingService mSettingService;
    private DialogInterface.OnClickListener mClickListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            switch (which) {
                case -2: {
                    SettingDialog.this.mSettingService.cancel();
                    break;
                }
                case -1: {
                    SettingDialog.this.mSettingService.execute();
                }
            }
        }
    };

    SettingDialog(@NonNull Context context, @NonNull SettingService settingService) {
        this.mBuilder = AlertDialog.build((Context)context).setCancelable(false).setTitle(R.string.permission_title_permission_failed).setMessage(R.string.permission_message_permission_failed).setPositiveButton(R.string.permission_setting, this.mClickListener).setNegativeButton(R.string.permission_cancel, this.mClickListener);
        this.mSettingService = settingService;
    }

    @NonNull
    public SettingDialog setTitle(@NonNull String title) {
        this.mBuilder.setTitle((CharSequence)title);
        return this;
    }

    @NonNull
    public SettingDialog setTitle(@StringRes int title) {
        this.mBuilder.setTitle(title);
        return this;
    }

    @NonNull
    public SettingDialog setMessage(@NonNull String message) {
        this.mBuilder.setMessage((CharSequence)message);
        return this;
    }

    @NonNull
    public SettingDialog setMessage(@StringRes int message) {
        this.mBuilder.setMessage(message);
        return this;
    }

    @NonNull
    public SettingDialog setNegativeButton(@NonNull String text, @Nullable DialogInterface.OnClickListener negativeListener) {
        this.mBuilder.setNegativeButton((CharSequence)text, negativeListener);
        return this;
    }

    @NonNull
    public SettingDialog setNegativeButton(@StringRes int text, @Nullable DialogInterface.OnClickListener negativeListener) {
        this.mBuilder.setNegativeButton(text, negativeListener);
        return this;
    }

    @NonNull
    public SettingDialog setPositiveButton(@NonNull String text) {
        this.mBuilder.setPositiveButton((CharSequence)text, this.mClickListener);
        return this;
    }

    @NonNull
    public SettingDialog setPositiveButton(@StringRes int text) {
        this.mBuilder.setPositiveButton(text, this.mClickListener);
        return this;
    }

    public void show() {
        this.mBuilder.show();
    }
}

