/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.recyclerview.swipe;

import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.yanzhenjie.recyclerview.swipe.SwipeAdapterWrapper;
import com.yanzhenjie.recyclerview.swipe.SwipeItemClickListener;
import com.yanzhenjie.recyclerview.swipe.SwipeItemLongClickListener;
import com.yanzhenjie.recyclerview.swipe.SwipeMenuBridge;
import com.yanzhenjie.recyclerview.swipe.SwipeMenuCreator;
import com.yanzhenjie.recyclerview.swipe.SwipeMenuItemClickListener;
import com.yanzhenjie.recyclerview.swipe.SwipeMenuLayout;
import com.yanzhenjie.recyclerview.swipe.touch.DefaultItemTouchHelper;
import com.yanzhenjie.recyclerview.swipe.touch.OnItemMoveListener;
import com.yanzhenjie.recyclerview.swipe.touch.OnItemMovementListener;
import com.yanzhenjie.recyclerview.swipe.touch.OnItemStateChangedListener;
import com.yanzhenjie.recyclerview.swipe.widget.DefaultLoadMoreView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class SwipeMenuRecyclerView
extends RecyclerView {
    public static final int LEFT_DIRECTION = 1;
    public static final int RIGHT_DIRECTION = -1;
    private static final int INVALID_POSITION = -1;
    protected int mScaleTouchSlop;
    protected SwipeMenuLayout mOldSwipedLayout;
    protected int mOldTouchedPosition = -1;
    private int mDownX;
    private int mDownY;
    private boolean allowSwipeDelete = false;
    private DefaultItemTouchHelper mDefaultItemTouchHelper;
    private SwipeMenuCreator mSwipeMenuCreator;
    private SwipeMenuItemClickListener mSwipeMenuItemClickListener;
    private SwipeItemClickListener mSwipeItemClickListener;
    private SwipeItemLongClickListener mSwipeItemLongClickListener;
    private SwipeAdapterWrapper mAdapterWrapper;
    private RecyclerView.AdapterDataObserver mAdapterDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            SwipeMenuRecyclerView.this.mAdapterWrapper.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            SwipeMenuRecyclerView.this.mAdapterWrapper.notifyItemRangeChanged(positionStart += SwipeMenuRecyclerView.this.getHeaderItemCount(), itemCount);
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            SwipeMenuRecyclerView.this.mAdapterWrapper.notifyItemRangeChanged(positionStart += SwipeMenuRecyclerView.this.getHeaderItemCount(), itemCount, payload);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            SwipeMenuRecyclerView.this.mAdapterWrapper.notifyItemRangeInserted(positionStart += SwipeMenuRecyclerView.this.getHeaderItemCount(), itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            SwipeMenuRecyclerView.this.mAdapterWrapper.notifyItemRangeRemoved(positionStart += SwipeMenuRecyclerView.this.getHeaderItemCount(), itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            SwipeMenuRecyclerView.this.mAdapterWrapper.notifyItemMoved(fromPosition += SwipeMenuRecyclerView.this.getHeaderItemCount(), toPosition += SwipeMenuRecyclerView.this.getHeaderItemCount());
        }
    };
    private List<View> mHeaderViewList = new ArrayList<View>();
    private List<View> mFooterViewList = new ArrayList<View>();
    private int mScrollState = -1;
    private boolean isLoadMore = false;
    private boolean isAutoLoadMore = true;
    private boolean isLoadError = false;
    private boolean mDataEmpty = true;
    private boolean mHasMore = false;
    private LoadMoreView mLoadMoreView;
    private LoadMoreListener mLoadMoreListener;

    public SwipeMenuRecyclerView(Context context) {
        this(context, null);
    }

    public SwipeMenuRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeMenuRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mScaleTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
    }

    private void initializeItemTouchHelper() {
        if (this.mDefaultItemTouchHelper == null) {
            this.mDefaultItemTouchHelper = new DefaultItemTouchHelper();
            this.mDefaultItemTouchHelper.attachToRecyclerView(this);
        }
    }

    public void setOnItemMoveListener(OnItemMoveListener onItemMoveListener) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.setOnItemMoveListener(onItemMoveListener);
    }

    public void setOnItemMovementListener(OnItemMovementListener onItemMovementListener) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.setOnItemMovementListener(onItemMovementListener);
    }

    public void setOnItemStateChangedListener(OnItemStateChangedListener onItemStateChangedListener) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.setOnItemStateChangedListener(onItemStateChangedListener);
    }

    public void setLongPressDragEnabled(boolean canDrag) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.setLongPressDragEnabled(canDrag);
    }

    public boolean isLongPressDragEnabled() {
        this.initializeItemTouchHelper();
        return this.mDefaultItemTouchHelper.isLongPressDragEnabled();
    }

    public void setItemViewSwipeEnabled(boolean canSwipe) {
        this.initializeItemTouchHelper();
        this.allowSwipeDelete = canSwipe;
        this.mDefaultItemTouchHelper.setItemViewSwipeEnabled(canSwipe);
    }

    public boolean isItemViewSwipeEnabled() {
        this.initializeItemTouchHelper();
        return this.mDefaultItemTouchHelper.isItemViewSwipeEnabled();
    }

    public void startDrag(RecyclerView.ViewHolder viewHolder) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.startDrag(viewHolder);
    }

    public void startSwipe(RecyclerView.ViewHolder viewHolder) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.startSwipe(viewHolder);
    }

    private void checkAdapterExist(String message) {
        if (this.mAdapterWrapper != null) {
            throw new IllegalStateException(message);
        }
    }

    public void setSwipeItemClickListener(SwipeItemClickListener itemClickListener) {
        if (itemClickListener == null) {
            return;
        }
        this.checkAdapterExist("Cannot set item click listener, setAdapter has already been called.");
        this.mSwipeItemClickListener = new ItemClick(this, itemClickListener);
    }

    public void setSwipeItemLongClickListener(SwipeItemLongClickListener itemLongClickListener) {
        if (itemLongClickListener == null) {
            return;
        }
        this.checkAdapterExist("Cannot set item long click listener, setAdapter has already been called.");
        this.mSwipeItemLongClickListener = new ItemLongClick(this, itemLongClickListener);
    }

    public void setSwipeMenuCreator(SwipeMenuCreator menuCreator) {
        if (menuCreator == null) {
            return;
        }
        this.checkAdapterExist("Cannot set menu creator, setAdapter has already been called.");
        this.mSwipeMenuCreator = menuCreator;
    }

    public void setSwipeMenuItemClickListener(SwipeMenuItemClickListener menuItemClickListener) {
        if (menuItemClickListener == null) {
            return;
        }
        this.checkAdapterExist("Cannot set menu item click listener, setAdapter has already been called.");
        this.mSwipeMenuItemClickListener = new MenuItemClick(this, menuItemClickListener);
    }

    public void setLayoutManager(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof GridLayoutManager) {
            final GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
            final GridLayoutManager.SpanSizeLookup spanSizeLookupHolder = gridLayoutManager.getSpanSizeLookup();
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (SwipeMenuRecyclerView.this.mAdapterWrapper.isHeaderView(position) || SwipeMenuRecyclerView.this.mAdapterWrapper.isFooterView(position)) {
                        return gridLayoutManager.getSpanCount();
                    }
                    if (spanSizeLookupHolder != null) {
                        return spanSizeLookupHolder.getSpanSize(position - SwipeMenuRecyclerView.this.getHeaderItemCount());
                    }
                    return 1;
                }
            });
        }
        super.setLayoutManager(layoutManager);
    }

    public RecyclerView.Adapter getOriginAdapter() {
        if (this.mAdapterWrapper == null) {
            return null;
        }
        return this.mAdapterWrapper.getOriginAdapter();
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (this.mAdapterWrapper != null) {
            this.mAdapterWrapper.getOriginAdapter().unregisterAdapterDataObserver(this.mAdapterDataObserver);
        }
        if (adapter == null) {
            this.mAdapterWrapper = null;
        } else {
            adapter.registerAdapterDataObserver(this.mAdapterDataObserver);
            this.mAdapterWrapper = new SwipeAdapterWrapper(this.getContext(), adapter);
            this.mAdapterWrapper.setSwipeItemClickListener(this.mSwipeItemClickListener);
            this.mAdapterWrapper.setSwipeItemLongClickListener(this.mSwipeItemLongClickListener);
            this.mAdapterWrapper.setSwipeMenuCreator(this.mSwipeMenuCreator);
            this.mAdapterWrapper.setSwipeMenuItemClickListener(this.mSwipeMenuItemClickListener);
            if (this.mHeaderViewList.size() > 0) {
                for (View view : this.mHeaderViewList) {
                    this.mAdapterWrapper.addHeaderView(view);
                }
            }
            if (this.mFooterViewList.size() > 0) {
                for (View view : this.mFooterViewList) {
                    this.mAdapterWrapper.addFooterView(view);
                }
            }
        }
        super.setAdapter((RecyclerView.Adapter)this.mAdapterWrapper);
    }

    public void addHeaderView(View view) {
        this.mHeaderViewList.add(view);
        if (this.mAdapterWrapper != null) {
            this.mAdapterWrapper.addHeaderViewAndNotify(view);
        }
    }

    public void removeHeaderView(View view) {
        this.mHeaderViewList.remove(view);
        if (this.mAdapterWrapper != null) {
            this.mAdapterWrapper.removeHeaderViewAndNotify(view);
        }
    }

    public void addFooterView(View view) {
        this.mFooterViewList.add(view);
        if (this.mAdapterWrapper != null) {
            this.mAdapterWrapper.addFooterViewAndNotify(view);
        }
    }

    public void removeFooterView(View view) {
        this.mFooterViewList.remove(view);
        if (this.mAdapterWrapper != null) {
            this.mAdapterWrapper.removeFooterViewAndNotify(view);
        }
    }

    public int getHeaderItemCount() {
        if (this.mAdapterWrapper == null) {
            return 0;
        }
        return this.mAdapterWrapper.getHeaderItemCount();
    }

    public int getFooterItemCount() {
        if (this.mAdapterWrapper == null) {
            return 0;
        }
        return this.mAdapterWrapper.getFooterItemCount();
    }

    public int getItemViewType(int position) {
        if (this.mAdapterWrapper == null) {
            return 0;
        }
        return this.mAdapterWrapper.getItemViewType(position);
    }

    public void smoothOpenLeftMenu(int position) {
        this.smoothOpenMenu(position, 1, 200);
    }

    public void smoothOpenLeftMenu(int position, int duration) {
        this.smoothOpenMenu(position, 1, duration);
    }

    public void smoothOpenRightMenu(int position) {
        this.smoothOpenMenu(position, -1, 200);
    }

    public void smoothOpenRightMenu(int position, int duration) {
        this.smoothOpenMenu(position, -1, duration);
    }

    public void smoothOpenMenu(int position, int direction, int duration) {
        View itemView;
        RecyclerView.ViewHolder vh;
        if (this.mOldSwipedLayout != null && this.mOldSwipedLayout.isMenuOpen()) {
            this.mOldSwipedLayout.smoothCloseMenu();
        }
        if ((vh = this.findViewHolderForAdapterPosition(position += this.getHeaderItemCount())) != null && (itemView = this.getSwipeMenuView(vh.itemView)) instanceof SwipeMenuLayout) {
            this.mOldSwipedLayout = (SwipeMenuLayout)itemView;
            if (direction == -1) {
                this.mOldTouchedPosition = position;
                this.mOldSwipedLayout.smoothOpenRightMenu(duration);
            } else if (direction == 1) {
                this.mOldTouchedPosition = position;
                this.mOldSwipedLayout.smoothOpenLeftMenu(duration);
            }
        }
    }

    public void smoothCloseMenu() {
        if (this.mOldSwipedLayout != null && this.mOldSwipedLayout.isMenuOpen()) {
            this.mOldSwipedLayout.smoothCloseMenu();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        boolean isIntercepted = super.onInterceptTouchEvent(e);
        if (this.allowSwipeDelete) {
            return isIntercepted;
        }
        if (e.getPointerCount() > 1) {
            return true;
        }
        int action = e.getAction();
        int x = (int)e.getX();
        int y = (int)e.getY();
        switch (action) {
            case 0: {
                View itemView;
                this.mDownX = x;
                this.mDownY = y;
                isIntercepted = false;
                int touchingPosition = this.getChildAdapterPosition(this.findChildViewUnder(x, y));
                if (touchingPosition != this.mOldTouchedPosition && this.mOldSwipedLayout != null && this.mOldSwipedLayout.isMenuOpen()) {
                    this.mOldSwipedLayout.smoothCloseMenu();
                    isIntercepted = true;
                }
                if (isIntercepted) {
                    this.mOldSwipedLayout = null;
                    this.mOldTouchedPosition = -1;
                    break;
                }
                RecyclerView.ViewHolder vh = this.findViewHolderForAdapterPosition(touchingPosition);
                if (vh == null || !((itemView = this.getSwipeMenuView(vh.itemView)) instanceof SwipeMenuLayout)) break;
                this.mOldSwipedLayout = (SwipeMenuLayout)itemView;
                this.mOldTouchedPosition = touchingPosition;
                break;
            }
            case 2: {
                ViewParent viewParent;
                isIntercepted = this.handleUnDown(x, y, isIntercepted);
                if (this.mOldSwipedLayout == null || (viewParent = this.getParent()) == null) break;
                int disX = this.mDownX - x;
                boolean showRightCloseLeft = disX > 0 && (this.mOldSwipedLayout.hasRightMenu() || this.mOldSwipedLayout.isLeftCompleteOpen());
                boolean showLeftCloseRight = disX < 0 && (this.mOldSwipedLayout.hasLeftMenu() || this.mOldSwipedLayout.isRightCompleteOpen());
                viewParent.requestDisallowInterceptTouchEvent(showRightCloseLeft || showLeftCloseRight);
            }
            case 1: 
            case 3: {
                isIntercepted = this.handleUnDown(x, y, isIntercepted);
            }
        }
        return isIntercepted;
    }

    private boolean handleUnDown(int x, int y, boolean defaultValue) {
        int disX = this.mDownX - x;
        int disY = this.mDownY - y;
        if (Math.abs(disX) > this.mScaleTouchSlop && Math.abs(disX) > Math.abs(disY)) {
            return false;
        }
        if (Math.abs(disY) < this.mScaleTouchSlop && Math.abs(disX) < this.mScaleTouchSlop) {
            return false;
        }
        return defaultValue;
    }

    public boolean onTouchEvent(MotionEvent e) {
        int action = e.getAction();
        switch (action) {
            case 0: {
                break;
            }
            case 2: {
                if (this.mOldSwipedLayout == null || !this.mOldSwipedLayout.isMenuOpen()) break;
                this.mOldSwipedLayout.smoothCloseMenu();
                break;
            }
            case 1: {
                break;
            }
        }
        return super.onTouchEvent(e);
    }

    private View getSwipeMenuView(View itemView) {
        if (itemView instanceof SwipeMenuLayout) {
            return itemView;
        }
        ArrayList<View> unvisited = new ArrayList<View>();
        unvisited.add(itemView);
        while (!unvisited.isEmpty()) {
            View child = (View)unvisited.remove(0);
            if (!(child instanceof ViewGroup)) continue;
            if (child instanceof SwipeMenuLayout) {
                return child;
            }
            ViewGroup group = (ViewGroup)child;
            int childCount = group.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                unvisited.add(group.getChildAt(i));
            }
        }
        return itemView;
    }

    public void onScrollStateChanged(int state) {
        this.mScrollState = state;
    }

    public void onScrolled(int dx, int dy) {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager != null && layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            int itemCount = layoutManager.getItemCount();
            if (itemCount <= 0) {
                return;
            }
            int lastVisiblePosition = linearLayoutManager.findLastVisibleItemPosition();
            if (itemCount == lastVisiblePosition + 1 && (this.mScrollState == 1 || this.mScrollState == 2)) {
                this.dispatchLoadMore();
            }
        } else if (layoutManager != null && layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
            int itemCount = layoutManager.getItemCount();
            if (itemCount <= 0) {
                return;
            }
            int[] lastVisiblePositionArray = staggeredGridLayoutManager.findLastCompletelyVisibleItemPositions(null);
            int lastVisiblePosition = lastVisiblePositionArray[lastVisiblePositionArray.length - 1];
            if (itemCount == lastVisiblePosition + 1 && (this.mScrollState == 1 || this.mScrollState == 2)) {
                this.dispatchLoadMore();
            }
        }
    }

    private void dispatchLoadMore() {
        if (this.isLoadError) {
            return;
        }
        if (!this.isAutoLoadMore) {
            if (this.mLoadMoreView != null) {
                this.mLoadMoreView.onWaitToLoadMore(this.mLoadMoreListener);
            }
        } else {
            if (this.isLoadMore || this.mDataEmpty || !this.mHasMore) {
                return;
            }
            this.isLoadMore = true;
            if (this.mLoadMoreView != null) {
                this.mLoadMoreView.onLoading();
            }
            if (this.mLoadMoreListener != null) {
                this.mLoadMoreListener.onLoadMore();
            }
        }
    }

    public void useDefaultLoadMore() {
        DefaultLoadMoreView defaultLoadMoreView = new DefaultLoadMoreView(this.getContext());
        this.addFooterView((View)defaultLoadMoreView);
        this.setLoadMoreView(defaultLoadMoreView);
    }

    public void setLoadMoreView(LoadMoreView loadMoreView) {
        this.mLoadMoreView = loadMoreView;
    }

    public void setLoadMoreListener(LoadMoreListener loadMoreListener) {
        this.mLoadMoreListener = loadMoreListener;
    }

    public void setAutoLoadMore(boolean autoLoadMore) {
        this.isAutoLoadMore = autoLoadMore;
    }

    public final void loadMoreFinish(boolean dataEmpty, boolean hasMore) {
        this.isLoadMore = false;
        this.isLoadError = false;
        this.mDataEmpty = dataEmpty;
        this.mHasMore = hasMore;
        if (this.mLoadMoreView != null) {
            this.mLoadMoreView.onLoadFinish(dataEmpty, hasMore);
        }
    }

    public void loadMoreError(int errorCode, String errorMessage) {
        this.isLoadMore = false;
        this.isLoadError = true;
        if (this.mLoadMoreView != null) {
            this.mLoadMoreView.onLoadError(errorCode, errorMessage);
        }
    }

    public static interface LoadMoreListener {
        public void onLoadMore();
    }

    public static interface LoadMoreView {
        public void onLoading();

        public void onLoadFinish(boolean var1, boolean var2);

        public void onWaitToLoadMore(LoadMoreListener var1);

        public void onLoadError(int var1, String var2);
    }

    private static class MenuItemClick
    implements SwipeMenuItemClickListener {
        private SwipeMenuRecyclerView mRecyclerView;
        private SwipeMenuItemClickListener mCallback;

        public MenuItemClick(SwipeMenuRecyclerView recyclerView, SwipeMenuItemClickListener callback) {
            this.mRecyclerView = recyclerView;
            this.mCallback = callback;
        }

        @Override
        public void onItemClick(SwipeMenuBridge menuBridge) {
            int position = menuBridge.getAdapterPosition();
            if ((position -= this.mRecyclerView.getHeaderItemCount()) >= 0) {
                menuBridge.mAdapterPosition = position;
                this.mCallback.onItemClick(menuBridge);
            }
        }
    }

    private static class ItemLongClick
    implements SwipeItemLongClickListener {
        private SwipeMenuRecyclerView mRecyclerView;
        private SwipeItemLongClickListener mCallback;

        public ItemLongClick(SwipeMenuRecyclerView recyclerView, SwipeItemLongClickListener callback) {
            this.mRecyclerView = recyclerView;
            this.mCallback = callback;
        }

        @Override
        public void onItemLongClick(View itemView, int position) {
            if ((position -= this.mRecyclerView.getHeaderItemCount()) >= 0) {
                this.mCallback.onItemLongClick(itemView, position);
            }
        }
    }

    private static class ItemClick
    implements SwipeItemClickListener {
        private SwipeMenuRecyclerView mRecyclerView;
        private SwipeItemClickListener mCallback;

        public ItemClick(SwipeMenuRecyclerView recyclerView, SwipeItemClickListener callback) {
            this.mRecyclerView = recyclerView;
            this.mCallback = callback;
        }

        @Override
        public void onItemClick(View itemView, int position) {
            if ((position -= this.mRecyclerView.getHeaderItemCount()) >= 0) {
                this.mCallback.onItemClick(itemView, position);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DirectionMode {
    }
}

