/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.recyclerview.swipe.widget;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import com.yanzhenjie.recyclerview.swipe.SwipeMenuRecyclerView;
import java.util.ArrayList;
import java.util.List;

public class DefaultItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;
    private int mDividerWidth;
    private int mDividerHeight;
    private List<Integer> mViewTypeList = new ArrayList<Integer>();

    public DefaultItemDecoration(@ColorInt int color2) {
        this(color2, 2, 2, -1);
    }

    public DefaultItemDecoration(@ColorInt int color2, int dividerWidth, int dividerHeight, int ... excludeViewType) {
        this.mDivider = new ColorDrawable(color2);
        this.mDividerWidth = dividerWidth;
        this.mDividerHeight = dividerHeight;
        for (int i : excludeViewType) {
            this.mViewTypeList.add(i);
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        if (position < 0) {
            return;
        }
        if (this.mViewTypeList.contains(parent.getAdapter().getItemViewType(position))) {
            outRect.set(0, 0, 0, 0);
            return;
        }
        int columnCount = this.getSpanCount(parent);
        int childCount = parent.getAdapter().getItemCount();
        boolean firstRaw = this.isFirstRaw(position, columnCount);
        boolean lastRaw = this.isLastRaw(position, columnCount, childCount);
        boolean firstColumn = this.isFirstColumn(position, columnCount);
        boolean lastColumn = this.isLastColumn(position, columnCount);
        if (columnCount == 1) {
            if (firstRaw) {
                outRect.set(0, 0, 0, this.mDividerHeight / 2);
            } else if (lastRaw) {
                outRect.set(0, this.mDividerHeight / 2, 0, 0);
            } else {
                outRect.set(0, this.mDividerHeight / 2, 0, this.mDividerHeight / 2);
            }
        } else if (firstRaw && firstColumn) {
            outRect.set(0, 0, this.mDividerWidth / 2, this.mDividerHeight / 2);
        } else if (firstRaw && lastColumn) {
            outRect.set(this.mDividerWidth / 2, 0, 0, this.mDividerHeight / 2);
        } else if (firstRaw) {
            outRect.set(this.mDividerWidth / 2, 0, this.mDividerWidth / 2, this.mDividerHeight / 2);
        } else if (lastRaw && firstColumn) {
            outRect.set(0, this.mDividerHeight / 2, this.mDividerWidth / 2, 0);
        } else if (lastRaw && lastColumn) {
            outRect.set(this.mDividerWidth / 2, this.mDividerHeight / 2, 0, 0);
        } else if (lastRaw) {
            outRect.set(this.mDividerWidth / 2, this.mDividerHeight / 2, this.mDividerWidth / 2, 0);
        } else if (firstColumn) {
            outRect.set(0, this.mDividerHeight / 2, this.mDividerWidth / 2, this.mDividerHeight / 2);
        } else if (lastColumn) {
            outRect.set(this.mDividerWidth / 2, this.mDividerHeight / 2, 0, this.mDividerHeight / 2);
        } else {
            outRect.set(this.mDividerWidth / 2, this.mDividerHeight / 2, this.mDividerWidth / 2, this.mDividerHeight / 2);
        }
    }

    private int getSpanCount(RecyclerView parent) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            return ((GridLayoutManager)layoutManager).getSpanCount();
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
        }
        return 1;
    }

    private boolean isFirstRaw(int position, int columnCount) {
        return position < columnCount;
    }

    private boolean isLastRaw(int position, int columnCount, int childCount) {
        if (columnCount == 1) {
            return position + 1 == childCount;
        }
        int lastRawItemCount = childCount % columnCount;
        int rawCount = (childCount - lastRawItemCount) / columnCount + (lastRawItemCount > 0 ? 1 : 0);
        int rawPositionJudge = (position + 1) % columnCount;
        if (rawPositionJudge == 0) {
            int rawPosition = (position + 1) / columnCount;
            return rawCount == rawPosition;
        }
        int rawPosition = (position + 1 - rawPositionJudge) / columnCount + 1;
        return rawCount == rawPosition;
    }

    private boolean isFirstColumn(int position, int columnCount) {
        if (columnCount == 1) {
            return true;
        }
        return position % columnCount == 0;
    }

    private boolean isLastColumn(int position, int columnCount) {
        if (columnCount == 1) {
            return true;
        }
        return (position + 1) % columnCount == 0;
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        this.drawHorizontal(c, parent);
        this.drawVertical(c, parent);
    }

    public void drawHorizontal(Canvas c, RecyclerView parent) {
        c.save();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            int childPosition = parent.getChildAdapterPosition(child);
            if (childPosition < 0 || this.mViewTypeList.contains(parent.getAdapter().getItemViewType(childPosition)) || child instanceof SwipeMenuRecyclerView.LoadMoreView) continue;
            int left = child.getLeft();
            int top = child.getBottom();
            int right = child.getRight();
            int bottom = top + this.mDividerHeight;
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
        c.restore();
    }

    public void drawVertical(Canvas c, RecyclerView parent) {
        c.save();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            int childPosition = parent.getChildAdapterPosition(child);
            if (childPosition < 0 || this.mViewTypeList.contains(parent.getAdapter().getItemViewType(childPosition)) || child instanceof SwipeMenuRecyclerView.LoadMoreView) continue;
            int left = child.getRight();
            int top = child.getTop();
            int right = left + this.mDividerWidth;
            int bottom = child.getBottom();
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
        c.restore();
    }
}

