/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.recyclerview.swipe.widget;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yanzhenjie.loading.LoadingView;
import com.yanzhenjie.recyclerview.swipe.R;
import com.yanzhenjie.recyclerview.swipe.SwipeMenuRecyclerView;

public class DefaultLoadMoreView
extends LinearLayout
implements SwipeMenuRecyclerView.LoadMoreView,
View.OnClickListener {
    private LoadingView mLoadingView;
    private TextView mTvMessage;
    private SwipeMenuRecyclerView.LoadMoreListener mLoadMoreListener;

    public DefaultLoadMoreView(Context context) {
        this(context, null);
    }

    public DefaultLoadMoreView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.setGravity(17);
        this.setVisibility(8);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        int minHeight = (int)((double)(displayMetrics.density * 60.0f) + 0.5);
        this.setMinimumHeight(minHeight);
        DefaultLoadMoreView.inflate((Context)this.getContext(), (int)R.layout.recycler_swipe_view_load_more, (ViewGroup)this);
        this.mLoadingView = (LoadingView)this.findViewById(R.id.loading_view);
        this.mTvMessage = (TextView)this.findViewById(R.id.tv_load_more_message);
        int color1 = ContextCompat.getColor((Context)this.getContext(), (int)R.color.recycler_swipe_color_loading_color1);
        int color2 = ContextCompat.getColor((Context)this.getContext(), (int)R.color.recycler_swipe_color_loading_color2);
        int color3 = ContextCompat.getColor((Context)this.getContext(), (int)R.color.recycler_swipe_color_loading_color3);
        this.mLoadingView.setCircleColors(color1, color2, color3);
        this.setOnClickListener(this);
    }

    @Override
    public void onLoading() {
        this.setVisibility(0);
        this.mLoadingView.setVisibility(0);
        this.mTvMessage.setVisibility(0);
        this.mTvMessage.setText(R.string.recycler_swipe_load_more_message);
    }

    @Override
    public void onLoadFinish(boolean dataEmpty, boolean hasMore) {
        if (!hasMore) {
            this.setVisibility(0);
            if (dataEmpty) {
                this.mLoadingView.setVisibility(8);
                this.mTvMessage.setVisibility(0);
                this.mTvMessage.setText(R.string.recycler_swipe_data_empty);
            } else {
                this.mLoadingView.setVisibility(8);
                this.mTvMessage.setVisibility(0);
                this.mTvMessage.setText(R.string.recycler_swipe_more_not);
            }
        } else {
            this.setVisibility(4);
        }
    }

    @Override
    public void onWaitToLoadMore(SwipeMenuRecyclerView.LoadMoreListener loadMoreListener) {
        this.mLoadMoreListener = loadMoreListener;
        this.setVisibility(0);
        this.mLoadingView.setVisibility(8);
        this.mTvMessage.setVisibility(0);
        this.mTvMessage.setText(R.string.recycler_swipe_click_load_more);
    }

    @Override
    public void onLoadError(int errorCode, String errorMessage) {
        this.setVisibility(0);
        this.mLoadingView.setVisibility(8);
        this.mTvMessage.setVisibility(0);
        this.mTvMessage.setText((CharSequence)(TextUtils.isEmpty((CharSequence)errorMessage) ? this.getContext().getString(R.string.recycler_swipe_load_error) : errorMessage));
    }

    public void onClick(View v) {
        if (this.mLoadMoreListener != null) {
            this.mLoadMoreListener.onLoadMore();
        }
    }
}

