/*
 * Decompiled with CFR 0.152.
 */
package com.yarolegovich.discretescrollview;

import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import com.yarolegovich.discretescrollview.DSVOrientation;
import com.yarolegovich.discretescrollview.DSVScrollConfig;
import com.yarolegovich.discretescrollview.Direction;
import com.yarolegovich.discretescrollview.RecyclerViewProxy;
import com.yarolegovich.discretescrollview.transform.DiscreteScrollItemTransformer;
import java.util.Locale;

public class DiscreteScrollLayoutManager
extends RecyclerView.LayoutManager {
    static final int NO_POSITION = -1;
    private static final String EXTRA_POSITION = "extra_position";
    private static final int DEFAULT_TIME_FOR_ITEM_SETTLE = 300;
    private static final int DEFAULT_FLING_THRESHOLD = 2100;
    private static final int DEFAULT_TRANSFORM_CLAMP_ITEM_COUNT = 1;
    protected static final float SCROLL_TO_SNAP_TO_ANOTHER_ITEM = 0.6f;
    protected Point viewCenterIterator;
    protected Point recyclerCenter;
    protected Point currentViewCenter;
    protected int childHalfWidth;
    protected int childHalfHeight;
    protected int extraLayoutSpace;
    protected int scrollToChangeCurrent;
    protected int currentScrollState;
    protected int scrolled;
    protected int pendingScroll;
    protected int currentPosition;
    protected int pendingPosition;
    protected SparseArray<View> detachedCache;
    private DSVOrientation.Helper orientationHelper;
    protected boolean isFirstOrEmptyLayout;
    private Context context;
    private int timeForItemSettle;
    private int offscreenItems;
    private int transformClampItemCount;
    private boolean dataSetChangeShiftedPosition;
    private int flingThreshold;
    private boolean shouldSlideOnFling;
    private int viewWidth;
    private int viewHeight;
    @NonNull
    private DSVScrollConfig scrollConfig = DSVScrollConfig.ENABLED;
    @NonNull
    private final ScrollStateListener scrollStateListener;
    private DiscreteScrollItemTransformer itemTransformer;
    private RecyclerViewProxy recyclerViewProxy;

    public DiscreteScrollLayoutManager(@NonNull Context c, @NonNull ScrollStateListener scrollStateListener, @NonNull DSVOrientation orientation) {
        this.context = c;
        this.timeForItemSettle = 300;
        this.pendingPosition = -1;
        this.currentPosition = -1;
        this.flingThreshold = 2100;
        this.shouldSlideOnFling = false;
        this.recyclerCenter = new Point();
        this.currentViewCenter = new Point();
        this.viewCenterIterator = new Point();
        this.detachedCache = new SparseArray();
        this.scrollStateListener = scrollStateListener;
        this.orientationHelper = orientation.createHelper();
        this.recyclerViewProxy = new RecyclerViewProxy(this);
        this.transformClampItemCount = 1;
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (state.getItemCount() == 0) {
            this.recyclerViewProxy.removeAndRecycleAllViews(recycler);
            this.pendingPosition = -1;
            this.currentPosition = -1;
            this.pendingScroll = 0;
            this.scrolled = 0;
            return;
        }
        this.ensureValidPosition(state);
        this.updateRecyclerDimensions(state);
        if (!this.isFirstOrEmptyLayout) {
            boolean bl = this.isFirstOrEmptyLayout = this.recyclerViewProxy.getChildCount() == 0;
            if (this.isFirstOrEmptyLayout) {
                this.initChildDimensions(recycler);
            }
        }
        this.recyclerViewProxy.detachAndScrapAttachedViews(recycler);
        this.fill(recycler);
        this.applyItemTransformToChildren();
    }

    private void ensureValidPosition(RecyclerView.State state) {
        if (this.currentPosition == -1 || this.currentPosition >= state.getItemCount()) {
            this.currentPosition = 0;
        }
    }

    public void onLayoutCompleted(RecyclerView.State state) {
        if (this.isFirstOrEmptyLayout) {
            this.scrollStateListener.onCurrentViewFirstLayout();
            this.isFirstOrEmptyLayout = false;
        } else if (this.dataSetChangeShiftedPosition) {
            this.scrollStateListener.onDataSetChangeChangedPosition();
            this.dataSetChangeShiftedPosition = false;
        }
    }

    protected void initChildDimensions(RecyclerView.Recycler recycler) {
        View viewToMeasure = this.recyclerViewProxy.getMeasuredChildForAdapterPosition(0, recycler);
        int childViewWidth = this.recyclerViewProxy.getMeasuredWidthWithMargin(viewToMeasure);
        int childViewHeight = this.recyclerViewProxy.getMeasuredHeightWithMargin(viewToMeasure);
        this.childHalfWidth = childViewWidth / 2;
        this.childHalfHeight = childViewHeight / 2;
        this.scrollToChangeCurrent = this.orientationHelper.getDistanceToChangeCurrent(childViewWidth, childViewHeight);
        this.extraLayoutSpace = this.scrollToChangeCurrent * this.offscreenItems;
        this.recyclerViewProxy.detachAndScrapView(viewToMeasure, recycler);
    }

    protected void updateRecyclerDimensions(RecyclerView.State state) {
        boolean dimensionsChanged;
        boolean bl = dimensionsChanged = !state.isMeasuring() && (this.recyclerViewProxy.getWidth() != this.viewWidth || this.recyclerViewProxy.getHeight() != this.viewHeight);
        if (dimensionsChanged) {
            this.viewWidth = this.recyclerViewProxy.getWidth();
            this.viewHeight = this.recyclerViewProxy.getHeight();
            this.recyclerViewProxy.removeAllViews();
        }
        this.recyclerCenter.set(this.recyclerViewProxy.getWidth() / 2, this.recyclerViewProxy.getHeight() / 2);
    }

    protected void fill(RecyclerView.Recycler recycler) {
        this.cacheAndDetachAttachedViews();
        this.orientationHelper.setCurrentViewCenter(this.recyclerCenter, this.scrolled, this.currentViewCenter);
        int endBound = this.orientationHelper.getViewEnd(this.recyclerViewProxy.getWidth(), this.recyclerViewProxy.getHeight());
        if (this.isViewVisible(this.currentViewCenter, endBound)) {
            this.layoutView(recycler, this.currentPosition, this.currentViewCenter);
        }
        this.layoutViews(recycler, Direction.START, endBound);
        this.layoutViews(recycler, Direction.END, endBound);
        this.recycleDetachedViewsAndClearCache(recycler);
    }

    private void layoutViews(RecyclerView.Recycler recycler, Direction direction, int endBound) {
        int positionStep = direction.applyTo(1);
        boolean noPredictiveLayoutRequired = this.pendingPosition == -1 || !direction.sameAs(this.pendingPosition - this.currentPosition);
        this.viewCenterIterator.set(this.currentViewCenter.x, this.currentViewCenter.y);
        int pos = this.currentPosition + positionStep;
        while (this.isInBounds(pos)) {
            if (pos == this.pendingPosition) {
                noPredictiveLayoutRequired = true;
            }
            this.orientationHelper.shiftViewCenter(direction, this.scrollToChangeCurrent, this.viewCenterIterator);
            if (this.isViewVisible(this.viewCenterIterator, endBound)) {
                this.layoutView(recycler, pos, this.viewCenterIterator);
            } else if (noPredictiveLayoutRequired) break;
            pos += positionStep;
        }
    }

    protected void layoutView(RecyclerView.Recycler recycler, int position, Point viewCenter) {
        if (position < 0) {
            return;
        }
        View v = (View)this.detachedCache.get(position);
        if (v == null) {
            v = this.recyclerViewProxy.getMeasuredChildForAdapterPosition(position, recycler);
            this.recyclerViewProxy.layoutDecoratedWithMargins(v, viewCenter.x - this.childHalfWidth, viewCenter.y - this.childHalfHeight, viewCenter.x + this.childHalfWidth, viewCenter.y + this.childHalfHeight);
        } else {
            this.recyclerViewProxy.attachView(v);
            this.detachedCache.remove(position);
        }
    }

    protected void cacheAndDetachAttachedViews() {
        int i;
        this.detachedCache.clear();
        for (i = 0; i < this.recyclerViewProxy.getChildCount(); ++i) {
            View child = this.recyclerViewProxy.getChildAt(i);
            this.detachedCache.put(this.recyclerViewProxy.getPosition(child), (Object)child);
        }
        for (i = 0; i < this.detachedCache.size(); ++i) {
            this.recyclerViewProxy.detachView((View)this.detachedCache.valueAt(i));
        }
    }

    protected void recycleDetachedViewsAndClearCache(RecyclerView.Recycler recycler) {
        for (int i = 0; i < this.detachedCache.size(); ++i) {
            View viewToRemove = (View)this.detachedCache.valueAt(i);
            this.recyclerViewProxy.recycleView(viewToRemove, recycler);
        }
        this.detachedCache.clear();
    }

    public void onItemsAdded(@NonNull RecyclerView recyclerView, int positionStart, int itemCount) {
        int newPosition = this.currentPosition;
        if (this.currentPosition == -1) {
            newPosition = 0;
        } else if (this.currentPosition >= positionStart) {
            newPosition = Math.min(this.currentPosition + itemCount, this.recyclerViewProxy.getItemCount() - 1);
        }
        this.onNewPosition(newPosition);
    }

    public void onItemsRemoved(@NonNull RecyclerView recyclerView, int positionStart, int itemCount) {
        int newPosition = this.currentPosition;
        if (this.recyclerViewProxy.getItemCount() == 0) {
            newPosition = -1;
        } else if (this.currentPosition >= positionStart) {
            if (this.currentPosition < positionStart + itemCount) {
                this.currentPosition = -1;
            }
            newPosition = Math.max(0, this.currentPosition - itemCount);
        }
        this.onNewPosition(newPosition);
    }

    public void onItemsChanged(@NonNull RecyclerView recyclerView) {
        this.currentPosition = Math.min(Math.max(0, this.currentPosition), this.recyclerViewProxy.getItemCount() - 1);
        this.dataSetChangeShiftedPosition = true;
    }

    private void onNewPosition(int position) {
        if (this.currentPosition != position) {
            this.currentPosition = position;
            this.dataSetChangeShiftedPosition = true;
        }
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.scrollBy(dx, recycler);
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.scrollBy(dy, recycler);
    }

    protected int scrollBy(int amount, RecyclerView.Recycler recycler) {
        if (this.recyclerViewProxy.getChildCount() == 0) {
            return 0;
        }
        Direction direction = Direction.fromDelta(amount);
        int leftToScroll = this.calculateAllowedScrollIn(direction);
        if (leftToScroll <= 0) {
            return 0;
        }
        int delta = direction.applyTo(Math.min(leftToScroll, Math.abs(amount)));
        this.scrolled += delta;
        if (this.pendingScroll != 0) {
            this.pendingScroll -= delta;
        }
        this.orientationHelper.offsetChildren(-delta, this.recyclerViewProxy);
        if (this.orientationHelper.hasNewBecomeVisible(this)) {
            this.fill(recycler);
        }
        this.notifyScroll();
        this.applyItemTransformToChildren();
        return delta;
    }

    protected void applyItemTransformToChildren() {
        if (this.itemTransformer != null) {
            int clampAfterDistance = this.scrollToChangeCurrent * this.transformClampItemCount;
            for (int i = 0; i < this.recyclerViewProxy.getChildCount(); ++i) {
                View child = this.recyclerViewProxy.getChildAt(i);
                float position = this.getCenterRelativePositionOf(child, clampAfterDistance);
                this.itemTransformer.transformItem(child, position);
            }
        }
    }

    public void scrollToPosition(int position) {
        if (this.currentPosition == position) {
            return;
        }
        this.currentPosition = position;
        this.recyclerViewProxy.requestLayout();
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        if (this.currentPosition == position || this.pendingPosition != -1) {
            return;
        }
        this.checkTargetPosition(state, position);
        if (this.currentPosition == -1) {
            this.currentPosition = position;
        } else {
            this.startSmoothPendingScroll(position);
        }
    }

    public boolean canScrollHorizontally() {
        return this.orientationHelper.canScrollHorizontally();
    }

    public boolean canScrollVertically() {
        return this.orientationHelper.canScrollVertically();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onScrollStateChanged(int state) {
        if (this.currentScrollState == 0 && this.currentScrollState != state) {
            this.scrollStateListener.onScrollStart();
        }
        if (state == 0) {
            boolean isScrollEnded = this.onScrollEnd();
            if (!isScrollEnded) return;
            this.scrollStateListener.onScrollEnd();
        } else if (state == 1) {
            this.onDragStart();
        }
        this.currentScrollState = state;
    }

    private boolean onScrollEnd() {
        if (this.pendingPosition != -1) {
            this.currentPosition = this.pendingPosition;
            this.pendingPosition = -1;
            this.scrolled = 0;
        }
        Direction scrollDirection = Direction.fromDelta(this.scrolled);
        if (Math.abs(this.scrolled) == this.scrollToChangeCurrent) {
            this.currentPosition += scrollDirection.applyTo(1);
            this.scrolled = 0;
        }
        this.pendingScroll = this.isAnotherItemCloserThanCurrent() ? this.getHowMuchIsLeftToScroll(this.scrolled) : -this.scrolled;
        if (this.pendingScroll == 0) {
            return true;
        }
        this.startSmoothPendingScroll();
        return false;
    }

    private void onDragStart() {
        boolean isScrollingThroughMultiplePositions;
        boolean bl = isScrollingThroughMultiplePositions = Math.abs(this.scrolled) > this.scrollToChangeCurrent;
        if (isScrollingThroughMultiplePositions) {
            int scrolledPositions = this.scrolled / this.scrollToChangeCurrent;
            this.currentPosition += scrolledPositions;
            this.scrolled -= scrolledPositions * this.scrollToChangeCurrent;
        }
        if (this.isAnotherItemCloserThanCurrent()) {
            Direction direction = Direction.fromDelta(this.scrolled);
            this.currentPosition += direction.applyTo(1);
            this.scrolled = -this.getHowMuchIsLeftToScroll(this.scrolled);
        }
        this.pendingPosition = -1;
        this.pendingScroll = 0;
    }

    public boolean isFlingDisallowed(int velocityX, int velocityY) {
        int velocity = this.orientationHelper.getFlingVelocity(velocityX, velocityY);
        Direction direction = Direction.fromDelta(velocity);
        return this.scrollConfig.isScrollBlocked(direction);
    }

    public void onFling(int velocityX, int velocityY) {
        boolean canFling;
        int velocity = this.orientationHelper.getFlingVelocity(velocityX, velocityY);
        int throttleValue = this.shouldSlideOnFling ? Math.abs(velocity / this.flingThreshold) : 1;
        int newPosition = this.currentPosition + Direction.fromDelta(velocity).applyTo(throttleValue);
        newPosition = this.checkNewOnFlingPositionIsInBounds(newPosition);
        boolean isInScrollDirection = velocity * this.scrolled >= 0;
        boolean bl = canFling = isInScrollDirection && this.isInBounds(newPosition);
        if (canFling) {
            this.startSmoothPendingScroll(newPosition);
        } else {
            this.returnToCurrentPosition();
        }
    }

    public void returnToCurrentPosition() {
        this.pendingScroll = -this.scrolled;
        if (this.pendingScroll != 0) {
            this.startSmoothPendingScroll();
        }
    }

    protected int calculateAllowedScrollIn(Direction direction) {
        int allowedScroll;
        boolean isBoundReached;
        boolean isScrollDirectionAsBefore;
        if (this.pendingScroll != 0) {
            return Math.abs(this.pendingScroll);
        }
        if (this.currentScrollState == 1 && this.scrollConfig.isScrollBlocked(direction)) {
            return direction.reverse().applyTo(this.scrolled);
        }
        boolean bl = isScrollDirectionAsBefore = direction.applyTo(this.scrolled) > 0;
        if (direction == Direction.START && this.currentPosition == 0) {
            isBoundReached = this.scrolled == 0;
            allowedScroll = isBoundReached ? 0 : Math.abs(this.scrolled);
        } else if (direction == Direction.END && this.currentPosition == this.recyclerViewProxy.getItemCount() - 1) {
            isBoundReached = this.scrolled == 0;
            allowedScroll = isBoundReached ? 0 : Math.abs(this.scrolled);
        } else {
            isBoundReached = false;
            allowedScroll = isScrollDirectionAsBefore ? this.scrollToChangeCurrent - Math.abs(this.scrolled) : this.scrollToChangeCurrent + Math.abs(this.scrolled);
        }
        this.scrollStateListener.onIsBoundReachedFlagChange(isBoundReached);
        return allowedScroll;
    }

    private void startSmoothPendingScroll() {
        DiscreteLinearSmoothScroller scroller = new DiscreteLinearSmoothScroller(this.context);
        scroller.setTargetPosition(this.currentPosition);
        this.recyclerViewProxy.startSmoothScroll((RecyclerView.SmoothScroller)scroller);
    }

    private void startSmoothPendingScroll(int position) {
        if (this.currentPosition == position) {
            return;
        }
        this.pendingScroll = -this.scrolled;
        Direction direction = Direction.fromDelta(position - this.currentPosition);
        int distanceToScroll = Math.abs(position - this.currentPosition) * this.scrollToChangeCurrent;
        this.pendingScroll += direction.applyTo(distanceToScroll);
        this.pendingPosition = position;
        this.startSmoothPendingScroll();
    }

    public boolean isAutoMeasureEnabled() {
        return true;
    }

    public int computeVerticalScrollRange(@NonNull RecyclerView.State state) {
        return this.computeScrollRange(state);
    }

    public int computeVerticalScrollOffset(@NonNull RecyclerView.State state) {
        return this.computeScrollOffset(state);
    }

    public int computeVerticalScrollExtent(@NonNull RecyclerView.State state) {
        return this.computeScrollExtent(state);
    }

    public int computeHorizontalScrollRange(@NonNull RecyclerView.State state) {
        return this.computeScrollRange(state);
    }

    public int computeHorizontalScrollOffset(@NonNull RecyclerView.State state) {
        return this.computeScrollOffset(state);
    }

    public int computeHorizontalScrollExtent(@NonNull RecyclerView.State state) {
        return this.computeScrollExtent(state);
    }

    private int computeScrollOffset(RecyclerView.State state) {
        int scrollbarSize = this.computeScrollExtent(state);
        int offset = (int)((float)this.scrolled / (float)this.scrollToChangeCurrent * (float)scrollbarSize);
        return this.currentPosition * scrollbarSize + offset;
    }

    private int computeScrollExtent(RecyclerView.State state) {
        if (this.getItemCount() == 0) {
            return 0;
        }
        return (int)((float)this.computeScrollRange(state) / (float)this.getItemCount());
    }

    private int computeScrollRange(RecyclerView.State state) {
        if (state.getItemCount() == 0) {
            return 0;
        }
        return this.scrollToChangeCurrent * (state.getItemCount() - 1);
    }

    public void onAdapterChanged(RecyclerView.Adapter oldAdapter, RecyclerView.Adapter newAdapter) {
        this.pendingPosition = -1;
        this.pendingScroll = 0;
        this.scrolled = 0;
        this.currentPosition = newAdapter instanceof InitialPositionProvider ? ((InitialPositionProvider)newAdapter).getInitialPosition() : 0;
        this.recyclerViewProxy.removeAllViews();
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        if (this.pendingPosition != -1) {
            this.currentPosition = this.pendingPosition;
        }
        bundle.putInt(EXTRA_POSITION, this.currentPosition);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        Bundle bundle = (Bundle)state;
        this.currentPosition = bundle.getInt(EXTRA_POSITION);
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    public int getNextPosition() {
        if (this.scrolled == 0) {
            return this.currentPosition;
        }
        if (this.pendingPosition != -1) {
            return this.pendingPosition;
        }
        return this.currentPosition + Direction.fromDelta(this.scrolled).applyTo(1);
    }

    public void setItemTransformer(DiscreteScrollItemTransformer itemTransformer) {
        this.itemTransformer = itemTransformer;
    }

    public void setTimeForItemSettle(int timeForItemSettle) {
        this.timeForItemSettle = timeForItemSettle;
    }

    public void setOffscreenItems(int offscreenItems) {
        this.offscreenItems = offscreenItems;
        this.extraLayoutSpace = this.scrollToChangeCurrent * offscreenItems;
        this.recyclerViewProxy.requestLayout();
    }

    public void setTransformClampItemCount(int transformClampItemCount) {
        this.transformClampItemCount = transformClampItemCount;
        this.applyItemTransformToChildren();
    }

    public void setOrientation(DSVOrientation orientation) {
        this.orientationHelper = orientation.createHelper();
        this.recyclerViewProxy.removeAllViews();
        this.recyclerViewProxy.requestLayout();
    }

    public void setShouldSlideOnFling(boolean result) {
        this.shouldSlideOnFling = result;
    }

    public void setSlideOnFlingThreshold(int threshold) {
        this.flingThreshold = threshold;
    }

    public void setScrollConfig(@NonNull DSVScrollConfig config) {
        this.scrollConfig = config;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (this.recyclerViewProxy.getChildCount() > 0) {
            event.setFromIndex(this.getPosition(this.getFirstChild()));
            event.setToIndex(this.getPosition(this.getLastChild()));
        }
    }

    private float getCenterRelativePositionOf(View v, int maxDistance) {
        float childCenterX = (float)this.getDecoratedLeft(v) + (float)v.getWidth() * 0.5f;
        float childCenterY = (float)this.getDecoratedTop(v) + (float)v.getHeight() * 0.5f;
        float distanceFromCenter = this.orientationHelper.getDistanceFromCenter(this.recyclerCenter, childCenterX, childCenterY);
        return Math.min(Math.max(-1.0f, distanceFromCenter / (float)maxDistance), 1.0f);
    }

    private int checkNewOnFlingPositionIsInBounds(int position) {
        int itemCount = this.recyclerViewProxy.getItemCount();
        if (this.currentPosition != 0 && position < 0) {
            return 0;
        }
        if (this.currentPosition != itemCount - 1 && position >= itemCount) {
            return itemCount - 1;
        }
        return position;
    }

    private int getHowMuchIsLeftToScroll(int dx) {
        return Direction.fromDelta(dx).applyTo(this.scrollToChangeCurrent - Math.abs(this.scrolled));
    }

    private boolean isAnotherItemCloserThanCurrent() {
        return (float)Math.abs(this.scrolled) >= (float)this.scrollToChangeCurrent * 0.6f;
    }

    public View getFirstChild() {
        return this.recyclerViewProxy.getChildAt(0);
    }

    public View getLastChild() {
        return this.recyclerViewProxy.getChildAt(this.recyclerViewProxy.getChildCount() - 1);
    }

    public int getExtraLayoutSpace() {
        return this.extraLayoutSpace;
    }

    private void notifyScroll() {
        float amountToScroll = this.pendingPosition != -1 ? (float)Math.abs(this.scrolled + this.pendingScroll) : (float)this.scrollToChangeCurrent;
        float position = -Math.min(Math.max(-1.0f, (float)this.scrolled / amountToScroll), 1.0f);
        this.scrollStateListener.onScroll(position);
    }

    private boolean isInBounds(int itemPosition) {
        return itemPosition >= 0 && itemPosition < this.recyclerViewProxy.getItemCount();
    }

    private boolean isViewVisible(Point viewCenter, int endBound) {
        return this.orientationHelper.isViewVisible(viewCenter, this.childHalfWidth, this.childHalfHeight, endBound, this.extraLayoutSpace);
    }

    private void checkTargetPosition(RecyclerView.State state, int targetPosition) {
        if (targetPosition < 0 || targetPosition >= state.getItemCount()) {
            throw new IllegalArgumentException(String.format(Locale.US, "target position out of bounds: position=%d, itemCount=%d", targetPosition, state.getItemCount()));
        }
    }

    protected void setRecyclerViewProxy(RecyclerViewProxy recyclerViewProxy) {
        this.recyclerViewProxy = recyclerViewProxy;
    }

    protected void setOrientationHelper(DSVOrientation.Helper orientationHelper) {
        this.orientationHelper = orientationHelper;
    }

    public static interface InitialPositionProvider {
        public int getInitialPosition();
    }

    public static interface ScrollStateListener {
        public void onIsBoundReachedFlagChange(boolean var1);

        public void onScrollStart();

        public void onScrollEnd();

        public void onScroll(float var1);

        public void onCurrentViewFirstLayout();

        public void onDataSetChangeChangedPosition();
    }

    private class DiscreteLinearSmoothScroller
    extends LinearSmoothScroller {
        public DiscreteLinearSmoothScroller(Context context) {
            super(context);
        }

        public int calculateDxToMakeVisible(View view, int snapPreference) {
            return DiscreteScrollLayoutManager.this.orientationHelper.getPendingDx(-DiscreteScrollLayoutManager.this.pendingScroll);
        }

        public int calculateDyToMakeVisible(View view, int snapPreference) {
            return DiscreteScrollLayoutManager.this.orientationHelper.getPendingDy(-DiscreteScrollLayoutManager.this.pendingScroll);
        }

        protected int calculateTimeForScrolling(int dx) {
            float dist = Math.min(Math.abs(dx), DiscreteScrollLayoutManager.this.scrollToChangeCurrent);
            return (int)(Math.max(0.01f, dist / (float)DiscreteScrollLayoutManager.this.scrollToChangeCurrent) * (float)DiscreteScrollLayoutManager.this.timeForItemSettle);
        }

        @Nullable
        public PointF computeScrollVectorForPosition(int targetPosition) {
            return new PointF((float)DiscreteScrollLayoutManager.this.orientationHelper.getPendingDx(DiscreteScrollLayoutManager.this.pendingScroll), (float)DiscreteScrollLayoutManager.this.orientationHelper.getPendingDy(DiscreteScrollLayoutManager.this.pendingScroll));
        }
    }
}

