/*
 * Decompiled with CFR 0.152.
 */
package com.yarolegovich.discretescrollview;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.yarolegovich.discretescrollview.DSVOrientation;
import com.yarolegovich.discretescrollview.DSVScrollConfig;
import com.yarolegovich.discretescrollview.DiscreteScrollLayoutManager;
import com.yarolegovich.discretescrollview.R;
import com.yarolegovich.discretescrollview.transform.DiscreteScrollItemTransformer;
import com.yarolegovich.discretescrollview.util.ScrollListenerAdapter;
import java.util.ArrayList;
import java.util.List;

public class DiscreteScrollView
extends RecyclerView {
    public static final int NO_POSITION = -1;
    private static final int DEFAULT_ORIENTATION = DSVOrientation.HORIZONTAL.ordinal();
    private DiscreteScrollLayoutManager layoutManager;
    private List<ScrollStateChangeListener> scrollStateChangeListeners;
    private List<OnItemChangedListener> onItemChangedListeners;
    private Runnable notifyItemChangedRunnable = new Runnable(){

        @Override
        public void run() {
            DiscreteScrollView.this.notifyCurrentItemChanged();
        }
    };
    private boolean isOverScrollEnabled;

    public DiscreteScrollView(Context context) {
        super(context);
        this.init(null);
    }

    public DiscreteScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public DiscreteScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.scrollStateChangeListeners = new ArrayList<ScrollStateChangeListener>();
        this.onItemChangedListeners = new ArrayList<OnItemChangedListener>();
        int orientation = DEFAULT_ORIENTATION;
        if (attrs != null) {
            TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.DiscreteScrollView);
            orientation = ta.getInt(R.styleable.DiscreteScrollView_dsv_orientation, DEFAULT_ORIENTATION);
            ta.recycle();
        }
        this.isOverScrollEnabled = this.getOverScrollMode() != 2;
        this.layoutManager = new DiscreteScrollLayoutManager(this.getContext(), new ScrollStateListener(), DSVOrientation.values()[orientation]);
        this.setLayoutManager(this.layoutManager);
    }

    public void setLayoutManager(RecyclerView.LayoutManager layout) {
        if (!(layout instanceof DiscreteScrollLayoutManager)) {
            throw new IllegalArgumentException(this.getContext().getString(R.string.dsv_ex_msg_dont_set_lm));
        }
        super.setLayoutManager(layout);
    }

    public boolean fling(int velocityX, int velocityY) {
        if (this.layoutManager.isFlingDisallowed(velocityX, velocityY)) {
            return false;
        }
        boolean isFling = super.fling(velocityX, velocityY);
        if (isFling) {
            this.layoutManager.onFling(velocityX, velocityY);
        } else {
            this.layoutManager.returnToCurrentPosition();
        }
        return isFling;
    }

    @Nullable
    public RecyclerView.ViewHolder getViewHolder(int position) {
        View view = this.layoutManager.findViewByPosition(position);
        return view != null ? this.getChildViewHolder(view) : null;
    }

    public void scrollToPosition(int position) {
        int currentPosition = this.layoutManager.getCurrentPosition();
        super.scrollToPosition(position);
        if (currentPosition != position) {
            this.notifyCurrentItemChanged();
        }
    }

    public int getCurrentItem() {
        return this.layoutManager.getCurrentPosition();
    }

    public void setItemTransformer(DiscreteScrollItemTransformer transformer) {
        this.layoutManager.setItemTransformer(transformer);
    }

    public void setItemTransitionTimeMillis(@IntRange(from=10L) int millis) {
        this.layoutManager.setTimeForItemSettle(millis);
    }

    public void setSlideOnFling(boolean result) {
        this.layoutManager.setShouldSlideOnFling(result);
    }

    public void setSlideOnFlingThreshold(int threshold) {
        this.layoutManager.setSlideOnFlingThreshold(threshold);
    }

    public void setOrientation(DSVOrientation orientation) {
        this.layoutManager.setOrientation(orientation);
    }

    public void setOffscreenItems(int items) {
        this.layoutManager.setOffscreenItems(items);
    }

    public void setScrollConfig(@NonNull DSVScrollConfig config) {
        this.layoutManager.setScrollConfig(config);
    }

    public void setClampTransformProgressAfter(@IntRange(from=1L) int itemCount) {
        if (itemCount <= 1) {
            throw new IllegalArgumentException("must be >= 1");
        }
        this.layoutManager.setTransformClampItemCount(itemCount);
    }

    public void setOverScrollEnabled(boolean overScrollEnabled) {
        this.isOverScrollEnabled = overScrollEnabled;
        this.setOverScrollMode(2);
    }

    public void addScrollStateChangeListener(@NonNull ScrollStateChangeListener<?> scrollStateChangeListener) {
        this.scrollStateChangeListeners.add(scrollStateChangeListener);
    }

    public void addScrollListener(@NonNull ScrollListener<?> scrollListener) {
        this.addScrollStateChangeListener(new ScrollListenerAdapter(scrollListener));
    }

    public void addOnItemChangedListener(@NonNull OnItemChangedListener<?> onItemChangedListener) {
        this.onItemChangedListeners.add(onItemChangedListener);
    }

    public void removeScrollStateChangeListener(@NonNull ScrollStateChangeListener<?> scrollStateChangeListener) {
        this.scrollStateChangeListeners.remove(scrollStateChangeListener);
    }

    public void removeScrollListener(@NonNull ScrollListener<?> scrollListener) {
        this.removeScrollStateChangeListener(new ScrollListenerAdapter(scrollListener));
    }

    public void removeItemChangedListener(@NonNull OnItemChangedListener<?> onItemChangedListener) {
        this.onItemChangedListeners.remove(onItemChangedListener);
    }

    private void notifyScrollStart(RecyclerView.ViewHolder holder, int current) {
        for (ScrollStateChangeListener listener : this.scrollStateChangeListeners) {
            listener.onScrollStart(holder, current);
        }
    }

    private void notifyScrollEnd(RecyclerView.ViewHolder holder, int current) {
        for (ScrollStateChangeListener listener : this.scrollStateChangeListeners) {
            listener.onScrollEnd(holder, current);
        }
    }

    private void notifyScroll(float position, int currentIndex, int newIndex, RecyclerView.ViewHolder currentHolder, RecyclerView.ViewHolder newHolder) {
        for (ScrollStateChangeListener listener : this.scrollStateChangeListeners) {
            listener.onScroll(position, currentIndex, newIndex, currentHolder, newHolder);
        }
    }

    private void notifyCurrentItemChanged(RecyclerView.ViewHolder holder, int current) {
        for (OnItemChangedListener listener : this.onItemChangedListeners) {
            listener.onCurrentItemChanged(holder, current);
        }
    }

    private void notifyCurrentItemChanged() {
        this.removeCallbacks(this.notifyItemChangedRunnable);
        if (this.onItemChangedListeners.isEmpty()) {
            return;
        }
        int current = this.layoutManager.getCurrentPosition();
        RecyclerView.ViewHolder currentHolder = this.getViewHolder(current);
        if (currentHolder == null) {
            this.post(this.notifyItemChangedRunnable);
        } else {
            this.notifyCurrentItemChanged(currentHolder, current);
        }
    }

    public static interface OnItemChangedListener<T extends RecyclerView.ViewHolder> {
        public void onCurrentItemChanged(@Nullable T var1, int var2);
    }

    public static interface ScrollListener<T extends RecyclerView.ViewHolder> {
        public void onScroll(float var1, int var2, int var3, @Nullable T var4, @Nullable T var5);
    }

    public static interface ScrollStateChangeListener<T extends RecyclerView.ViewHolder> {
        public void onScrollStart(@NonNull T var1, int var2);

        public void onScrollEnd(@NonNull T var1, int var2);

        public void onScroll(float var1, int var2, int var3, @Nullable T var4, @Nullable T var5);
    }

    private class ScrollStateListener
    implements DiscreteScrollLayoutManager.ScrollStateListener {
        private ScrollStateListener() {
        }

        @Override
        public void onIsBoundReachedFlagChange(boolean isBoundReached) {
            if (DiscreteScrollView.this.isOverScrollEnabled) {
                DiscreteScrollView.this.setOverScrollMode(isBoundReached ? 0 : 2);
            }
        }

        @Override
        public void onScrollStart() {
            DiscreteScrollView.this.removeCallbacks(DiscreteScrollView.this.notifyItemChangedRunnable);
            if (DiscreteScrollView.this.scrollStateChangeListeners.isEmpty()) {
                return;
            }
            int current = DiscreteScrollView.this.layoutManager.getCurrentPosition();
            RecyclerView.ViewHolder holder = DiscreteScrollView.this.getViewHolder(current);
            if (holder != null) {
                DiscreteScrollView.this.notifyScrollStart(holder, current);
            }
        }

        @Override
        public void onScrollEnd() {
            if (DiscreteScrollView.this.onItemChangedListeners.isEmpty() && DiscreteScrollView.this.scrollStateChangeListeners.isEmpty()) {
                return;
            }
            int current = DiscreteScrollView.this.layoutManager.getCurrentPosition();
            RecyclerView.ViewHolder holder = DiscreteScrollView.this.getViewHolder(current);
            if (holder != null) {
                DiscreteScrollView.this.notifyScrollEnd(holder, current);
                DiscreteScrollView.this.notifyCurrentItemChanged(holder, current);
            }
        }

        @Override
        public void onScroll(float currentViewPosition) {
            int newIndex;
            if (DiscreteScrollView.this.scrollStateChangeListeners.isEmpty()) {
                return;
            }
            int currentIndex = DiscreteScrollView.this.getCurrentItem();
            if (currentIndex != (newIndex = DiscreteScrollView.this.layoutManager.getNextPosition())) {
                DiscreteScrollView.this.notifyScroll(currentViewPosition, currentIndex, newIndex, DiscreteScrollView.this.getViewHolder(currentIndex), DiscreteScrollView.this.getViewHolder(newIndex));
            }
        }

        @Override
        public void onCurrentViewFirstLayout() {
            DiscreteScrollView.this.notifyCurrentItemChanged();
        }

        @Override
        public void onDataSetChangeChangedPosition() {
            DiscreteScrollView.this.notifyCurrentItemChanged();
        }
    }
}

