/*
 * Decompiled with CFR 0.152.
 */
package com.yarolegovich.discretescrollview;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yarolegovich.discretescrollview.DiscreteScrollLayoutManager;
import com.yarolegovich.discretescrollview.DiscreteScrollView;
import com.yarolegovich.discretescrollview.R;
import java.util.Locale;

public class InfiniteScrollAdapter<T extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<T>
implements DiscreteScrollLayoutManager.InitialPositionProvider {
    private static final int CENTER = 0x3FFFFFFF;
    private static final int RESET_BOUND = 100;
    private RecyclerView.Adapter<T> wrapped;
    private DiscreteScrollLayoutManager layoutManager;

    public static <T extends RecyclerView.ViewHolder> InfiniteScrollAdapter<T> wrap(@NonNull RecyclerView.Adapter<T> adapter) {
        return new InfiniteScrollAdapter<T>(adapter);
    }

    public InfiniteScrollAdapter(@NonNull RecyclerView.Adapter<T> wrapped) {
        this.wrapped = wrapped;
        this.wrapped.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)new DataSetChangeDelegate());
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        this.wrapped.onAttachedToRecyclerView(recyclerView);
        if (!(recyclerView instanceof DiscreteScrollView)) {
            String msg = recyclerView.getContext().getString(R.string.dsv_ex_msg_adapter_wrong_recycler);
            throw new RuntimeException(msg);
        }
        this.layoutManager = (DiscreteScrollLayoutManager)recyclerView.getLayoutManager();
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        this.wrapped.onDetachedFromRecyclerView(recyclerView);
        this.layoutManager = null;
    }

    @NonNull
    public T onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return (T)this.wrapped.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(@NonNull T holder, int position) {
        if (this.isResetRequired(position)) {
            int resetPosition = 0x3FFFFFFF + this.mapPositionToReal(this.layoutManager.getCurrentPosition());
            this.setPosition(resetPosition);
            return;
        }
        this.wrapped.onBindViewHolder(holder, this.mapPositionToReal(position));
    }

    public int getItemViewType(int position) {
        return this.wrapped.getItemViewType(this.mapPositionToReal(position));
    }

    public int getItemCount() {
        return this.isInfinite() ? Integer.MAX_VALUE : this.wrapped.getItemCount();
    }

    public int getRealItemCount() {
        return this.wrapped.getItemCount();
    }

    public int getRealCurrentPosition() {
        return this.getRealPosition(this.layoutManager.getCurrentPosition());
    }

    public int getRealPosition(int position) {
        return this.mapPositionToReal(position);
    }

    public int getClosestPosition(int position) {
        int wraparoundDistance;
        this.ensureValidPosition(position);
        int adapterCurrent = this.layoutManager.getCurrentPosition();
        int current = this.mapPositionToReal(adapterCurrent);
        if (position == current) {
            return adapterCurrent;
        }
        int delta = position - current;
        int target = adapterCurrent + delta;
        int wraparoundTarget = adapterCurrent + (position > current ? delta - this.wrapped.getItemCount() : this.wrapped.getItemCount() + delta);
        int distance = Math.abs(adapterCurrent - target);
        if (distance == (wraparoundDistance = Math.abs(adapterCurrent - wraparoundTarget))) {
            return target > adapterCurrent ? target : wraparoundTarget;
        }
        return distance < wraparoundDistance ? target : wraparoundTarget;
    }

    private int mapPositionToReal(int position) {
        if (position < 0x3FFFFFFF) {
            int rem = (0x3FFFFFFF - position) % this.wrapped.getItemCount();
            return rem == 0 ? 0 : this.wrapped.getItemCount() - rem;
        }
        return (position - 0x3FFFFFFF) % this.wrapped.getItemCount();
    }

    private boolean isResetRequired(int requestedPosition) {
        return this.isInfinite() && (requestedPosition <= 100 || requestedPosition >= 2147483547);
    }

    private void ensureValidPosition(int position) {
        if (position >= this.wrapped.getItemCount()) {
            throw new IndexOutOfBoundsException(String.format(Locale.US, "requested position is outside adapter's bounds: position=%d, size=%d", position, this.wrapped.getItemCount()));
        }
    }

    private boolean isInfinite() {
        return this.wrapped.getItemCount() > 1;
    }

    @Override
    public int getInitialPosition() {
        return this.isInfinite() ? 0x3FFFFFFF : 0;
    }

    private void setPosition(int position) {
        this.layoutManager.scrollToPosition(position);
    }

    private class DataSetChangeDelegate
    extends RecyclerView.AdapterDataObserver {
        private DataSetChangeDelegate() {
        }

        public void onChanged() {
            InfiniteScrollAdapter.this.setPosition(InfiniteScrollAdapter.this.getInitialPosition());
            InfiniteScrollAdapter.this.notifyDataSetChanged();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.onChanged();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.onChanged();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            this.onChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            InfiniteScrollAdapter.this.notifyItemRangeChanged(0, InfiniteScrollAdapter.this.getItemCount());
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            InfiniteScrollAdapter.this.notifyItemRangeChanged(0, InfiniteScrollAdapter.this.getItemCount(), payload);
        }
    }
}

