/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v7.widget.ListPopupWindow;
import android.view.View;
import android.widget.AdapterView;
import android.widget.CursorAdapter;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zhihu.matisse.R;
import com.zhihu.matisse.internal.entity.Album;
import com.zhihu.matisse.internal.utils.Platform;

public class AlbumsSpinner {
    private static final int MAX_SHOWN_COUNT = 6;
    private CursorAdapter mAdapter;
    private TextView mSelected;
    private ListPopupWindow mListPopupWindow;
    private AdapterView.OnItemSelectedListener mOnItemSelectedListener;

    public AlbumsSpinner(@NonNull Context context) {
        this.mListPopupWindow = new ListPopupWindow(context, null, R.attr.listPopupWindowStyle);
        this.mListPopupWindow.setModal(true);
        float density = context.getResources().getDisplayMetrics().density;
        this.mListPopupWindow.setContentWidth((int)(216.0f * density));
        this.mListPopupWindow.setHorizontalOffset((int)(16.0f * density));
        this.mListPopupWindow.setVerticalOffset((int)(-48.0f * density));
        this.mListPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                AlbumsSpinner.this.onItemSelected(parent.getContext(), position);
                if (AlbumsSpinner.this.mOnItemSelectedListener != null) {
                    AlbumsSpinner.this.mOnItemSelectedListener.onItemSelected(parent, view, position, id2);
                }
            }
        });
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener listener) {
        this.mOnItemSelectedListener = listener;
    }

    public void setSelection(Context context, int position) {
        this.mListPopupWindow.setSelection(position);
        this.onItemSelected(context, position);
    }

    private void onItemSelected(Context context, int position) {
        this.mListPopupWindow.dismiss();
        Cursor cursor = this.mAdapter.getCursor();
        cursor.moveToPosition(position);
        Album album = Album.valueOf(cursor);
        String displayName = album.getDisplayName(context);
        if (this.mSelected.getVisibility() == 0) {
            this.mSelected.setText((CharSequence)displayName);
        } else if (Platform.hasICS()) {
            this.mSelected.setAlpha(0.0f);
            this.mSelected.setVisibility(0);
            this.mSelected.setText((CharSequence)displayName);
            this.mSelected.animate().alpha(1.0f).setDuration((long)context.getResources().getInteger(17694722)).start();
        } else {
            this.mSelected.setVisibility(0);
            this.mSelected.setText((CharSequence)displayName);
        }
    }

    public void setAdapter(CursorAdapter adapter) {
        this.mListPopupWindow.setAdapter((ListAdapter)adapter);
        this.mAdapter = adapter;
    }

    public void setSelectedTextView(TextView textView) {
        this.mSelected = textView;
        Drawable[] drawables = this.mSelected.getCompoundDrawables();
        Drawable right = drawables[2];
        TypedArray ta = this.mSelected.getContext().getTheme().obtainStyledAttributes(new int[]{R.attr.album_element_color});
        int color2 = ta.getColor(0, 0);
        ta.recycle();
        right.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        this.mSelected.setVisibility(8);
        this.mSelected.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int itemHeight = v.getResources().getDimensionPixelSize(R.dimen.album_item_height);
                AlbumsSpinner.this.mListPopupWindow.setHeight(AlbumsSpinner.this.mAdapter.getCount() > 6 ? itemHeight * 6 : itemHeight * AlbumsSpinner.this.mAdapter.getCount());
                AlbumsSpinner.this.mListPopupWindow.show();
            }
        });
        this.mSelected.setOnTouchListener(this.mListPopupWindow.createDragToOpenListener((View)this.mSelected));
    }

    public void setPopupAnchorView(View view) {
        this.mListPopupWindow.setAnchorView(view);
    }
}

