/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import android.support.annotation.FloatRange;
import android.view.animation.LinearInterpolator;

public abstract class ZLoadingBuilder
implements ValueAnimator.AnimatorUpdateListener,
Animator.AnimatorListener {
    public static float DEFAULT_SIZE = 56.0f;
    protected static final long ANIMATION_START_DELAY = 333L;
    protected static final long ANIMATION_DURATION = 1333L;
    private float mAllSize;
    private float mViewWidth;
    private float mViewHeight;
    private Drawable.Callback mCallback;
    private ValueAnimator mFloatValueAnimator;
    private double mDurationTimePercent = 1.0;

    void init(Context context) {
        this.mAllSize = ZLoadingBuilder.dip2px(context, DEFAULT_SIZE * 0.5f - 12.0f);
        this.mViewWidth = ZLoadingBuilder.dip2px(context, DEFAULT_SIZE);
        this.mViewHeight = ZLoadingBuilder.dip2px(context, DEFAULT_SIZE);
        this.initAnimators();
    }

    private void initAnimators() {
        this.mFloatValueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mFloatValueAnimator.setRepeatCount(-1);
        this.mFloatValueAnimator.setDuration(this.getAnimationDuration());
        this.mFloatValueAnimator.setStartDelay(this.getAnimationStartDelay());
        this.mFloatValueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
    }

    protected abstract void initParams(Context var1);

    protected abstract void onDraw(Canvas var1);

    protected abstract void setAlpha(int var1);

    protected abstract void prepareStart(ValueAnimator var1);

    protected abstract void prepareEnd();

    protected abstract void computeUpdateValue(ValueAnimator var1, @FloatRange(from=0.0, to=1.0) float var2);

    protected abstract void setColorFilter(ColorFilter var1);

    void setCallback(Drawable.Callback callback) {
        this.mCallback = callback;
    }

    void draw(Canvas canvas) {
        this.onDraw(canvas);
    }

    void start() {
        if (this.mFloatValueAnimator.isStarted()) {
            return;
        }
        this.mFloatValueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.mFloatValueAnimator.addListener((Animator.AnimatorListener)this);
        this.mFloatValueAnimator.setRepeatCount(-1);
        this.mFloatValueAnimator.setDuration(this.getAnimationDuration());
        this.prepareStart(this.mFloatValueAnimator);
        this.mFloatValueAnimator.start();
    }

    void stop() {
        this.mFloatValueAnimator.removeAllUpdateListeners();
        this.mFloatValueAnimator.removeAllListeners();
        this.mFloatValueAnimator.setRepeatCount(0);
        this.mFloatValueAnimator.setDuration(0L);
        this.prepareEnd();
        this.mFloatValueAnimator.end();
    }

    boolean isRunning() {
        return this.mFloatValueAnimator.isRunning();
    }

    public final void onAnimationUpdate(ValueAnimator animation) {
        this.computeUpdateValue(animation, ((Float)animation.getAnimatedValue()).floatValue());
        this.invalidateSelf();
    }

    private void invalidateSelf() {
        if (this.mCallback != null) {
            this.mCallback.invalidateDrawable(null);
        }
    }

    public void onAnimationStart(Animator animation) {
    }

    public void onAnimationEnd(Animator animation) {
    }

    public void onAnimationCancel(Animator animation) {
    }

    public void onAnimationRepeat(Animator animation) {
    }

    public void setDurationTimePercent(double durationTimePercent) {
        this.mDurationTimePercent = durationTimePercent <= 0.0 ? 1.0 : durationTimePercent;
    }

    protected long getAnimationStartDelay() {
        return 333L;
    }

    protected long getAnimationDuration() {
        return ZLoadingBuilder.ceil(1333.0 * this.mDurationTimePercent);
    }

    protected float getIntrinsicHeight() {
        return this.mViewHeight;
    }

    protected float getIntrinsicWidth() {
        return this.mViewWidth;
    }

    protected final float getViewCenterX() {
        return this.getIntrinsicWidth() * 0.5f;
    }

    protected final float getViewCenterY() {
        return this.getIntrinsicHeight() * 0.5f;
    }

    protected final float getAllSize() {
        return this.mAllSize;
    }

    protected static float dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return dpValue * scale;
    }

    protected static long ceil(double value) {
        return (long)Math.ceil(value);
    }
}

