/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zyao89.view.zloading.R;
import com.zyao89.view.zloading.ZLoadingTextView;
import com.zyao89.view.zloading.ZLoadingView;
import com.zyao89.view.zloading.Z_TYPE;
import java.lang.ref.WeakReference;

public class ZLoadingDialog {
    private final WeakReference<Context> mContext;
    private final int mThemeResId;
    private Z_TYPE mLoadingBuilderType;
    private int mLoadingBuilderColor;
    private String mHintText;
    private float mHintTextSize = -1.0f;
    private int mHintTextColor = -1;
    private boolean mCancelable = true;
    private boolean mCanceledOnTouchOutside = true;
    private double mDurationTimePercent = 1.0;
    private int mDialogBackgroundColor = -1;
    private Dialog mZLoadingDialog;

    public ZLoadingDialog(@NonNull Context context) {
        this(context, R.style.alert_dialog);
    }

    public ZLoadingDialog(@NonNull Context context, int themeResId) {
        this.mContext = new WeakReference<Context>(context);
        this.mThemeResId = themeResId;
    }

    public ZLoadingDialog setLoadingBuilder(@NonNull Z_TYPE type) {
        this.mLoadingBuilderType = type;
        return this;
    }

    public ZLoadingDialog setLoadingColor(@ColorInt int color) {
        this.mLoadingBuilderColor = color;
        return this;
    }

    public ZLoadingDialog setHintText(String text) {
        this.mHintText = text;
        return this;
    }

    public ZLoadingDialog setHintTextSize(float size) {
        this.mHintTextSize = size;
        return this;
    }

    public ZLoadingDialog setHintTextColor(@ColorInt int color) {
        this.mHintTextColor = color;
        return this;
    }

    public ZLoadingDialog setCancelable(boolean cancelable) {
        this.mCancelable = cancelable;
        return this;
    }

    public ZLoadingDialog setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
        this.mCanceledOnTouchOutside = canceledOnTouchOutside;
        return this;
    }

    public ZLoadingDialog setDurationTime(double percent) {
        this.mDurationTimePercent = percent;
        return this;
    }

    public ZLoadingDialog setDialogBackgroundColor(@ColorInt int color) {
        this.mDialogBackgroundColor = color;
        return this;
    }

    @NonNull
    private View createContentView() {
        if (this.isContextNotExist()) {
            throw new RuntimeException("Context is null...");
        }
        return View.inflate((Context)((Context)this.mContext.get()), (int)R.layout.z_loading_dialog, null);
    }

    public Dialog create() {
        Drawable drawable;
        if (this.isContextNotExist()) {
            throw new RuntimeException("Context is null...");
        }
        if (this.mZLoadingDialog != null) {
            this.cancel();
        }
        this.mZLoadingDialog = new Dialog((Context)this.mContext.get(), this.mThemeResId);
        View contentView = this.createContentView();
        LinearLayout zLoadingRootView = (LinearLayout)contentView.findViewById(R.id.z_loading);
        if (this.mDialogBackgroundColor != -1 && (drawable = zLoadingRootView.getBackground()) != null) {
            drawable.setAlpha(Color.alpha((int)this.mDialogBackgroundColor));
            drawable.setColorFilter(this.mDialogBackgroundColor, PorterDuff.Mode.SRC_ATOP);
        }
        ZLoadingView zLoadingView = (ZLoadingView)contentView.findViewById(R.id.z_loading_view);
        ZLoadingTextView zTextView = (ZLoadingTextView)contentView.findViewById(R.id.z_text_view);
        TextView zCustomTextView = (TextView)contentView.findViewById(R.id.z_custom_text_view);
        if (this.mHintTextSize > 0.0f && !TextUtils.isEmpty((CharSequence)this.mHintText)) {
            zCustomTextView.setVisibility(0);
            zCustomTextView.setText((CharSequence)this.mHintText);
            zCustomTextView.setTextSize(this.mHintTextSize);
            zCustomTextView.setTextColor(this.mHintTextColor == -1 ? this.mLoadingBuilderColor : this.mHintTextColor);
        } else if (!TextUtils.isEmpty((CharSequence)this.mHintText)) {
            zTextView.setVisibility(0);
            zTextView.setText(this.mHintText);
            zTextView.setColorFilter(this.mHintTextColor == -1 ? this.mLoadingBuilderColor : this.mHintTextColor, PorterDuff.Mode.SRC_ATOP);
        }
        zLoadingView.setLoadingBuilder(this.mLoadingBuilderType);
        if (zLoadingView.mZLoadingBuilder != null) {
            zLoadingView.mZLoadingBuilder.setDurationTimePercent(this.mDurationTimePercent);
        }
        zLoadingView.setColorFilter(this.mLoadingBuilderColor, PorterDuff.Mode.SRC_ATOP);
        this.mZLoadingDialog.setContentView(contentView);
        this.mZLoadingDialog.setCancelable(this.mCancelable);
        this.mZLoadingDialog.setCanceledOnTouchOutside(this.mCanceledOnTouchOutside);
        return this.mZLoadingDialog;
    }

    public void show() {
        if (this.mZLoadingDialog != null) {
            this.mZLoadingDialog.show();
        } else {
            Dialog zLoadingDialog = this.create();
            zLoadingDialog.show();
        }
    }

    public void cancel() {
        if (this.mZLoadingDialog != null) {
            this.mZLoadingDialog.cancel();
        }
        this.mZLoadingDialog = null;
    }

    public void dismiss() {
        if (this.mZLoadingDialog != null) {
            this.mZLoadingDialog.dismiss();
        }
        this.mZLoadingDialog = null;
    }

    private boolean isContextNotExist() {
        Context context = (Context)this.mContext.get();
        return context == null;
    }
}

