/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.zyao89.view.zloading.R;
import com.zyao89.view.zloading.ZLoadingBuilder;
import com.zyao89.view.zloading.ZLoadingDrawable;
import com.zyao89.view.zloading.Z_TYPE;

public class ZLoadingView
extends ImageView {
    private ZLoadingDrawable mZLoadingDrawable;
    protected ZLoadingBuilder mZLoadingBuilder;

    public ZLoadingView(Context context) {
        this(context, null);
    }

    public ZLoadingView(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public ZLoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        try {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ZLoadingView);
            int typeId = ta.getInt(R.styleable.ZLoadingView_z_type, 0);
            int color = ta.getColor(R.styleable.ZLoadingView_z_color, -16777216);
            float durationTimePercent = ta.getFloat(R.styleable.ZLoadingView_z_duration_percent, 1.0f);
            ta.recycle();
            this.setLoadingBuilder(Z_TYPE.values()[typeId], durationTimePercent);
            this.setColorFilter(color);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLoadingBuilder(@NonNull Z_TYPE builder) {
        this.mZLoadingBuilder = builder.newInstance();
        this.initZLoadingDrawable();
    }

    public void setLoadingBuilder(@NonNull Z_TYPE builder, double durationPercent) {
        this.setLoadingBuilder(builder);
        this.initDurationTimePercent(durationPercent);
    }

    private void initZLoadingDrawable() {
        if (this.mZLoadingBuilder == null) {
            throw new RuntimeException("mZLoadingBuilder is null.");
        }
        this.mZLoadingDrawable = new ZLoadingDrawable(this.mZLoadingBuilder);
        this.mZLoadingDrawable.initParams(this.getContext());
        this.setImageDrawable(this.mZLoadingDrawable);
    }

    private void initDurationTimePercent(double durationPercent) {
        if (this.mZLoadingBuilder == null) {
            throw new RuntimeException("mZLoadingBuilder is null.");
        }
        this.mZLoadingBuilder.setDurationTimePercent(durationPercent);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startAnimation();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        boolean visible;
        super.onVisibilityChanged(changedView, visibility);
        boolean bl = visible = visibility == 0 && this.getVisibility() == 0;
        if (visible) {
            this.startAnimation();
        } else {
            this.stopAnimation();
        }
    }

    private void startAnimation() {
        if (this.mZLoadingDrawable != null) {
            this.mZLoadingDrawable.start();
        }
    }

    private void stopAnimation() {
        if (this.mZLoadingDrawable != null) {
            this.mZLoadingDrawable.stop();
        }
    }
}

