/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.ball;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import com.zyao89.view.zloading.ZLoadingBuilder;
import java.util.LinkedList;

abstract class BaseBallBuilder
extends ZLoadingBuilder {
    private static final float PROP_VALUE = 0.55191505f;
    protected final LinkedList<CirclePoint> mBallPoints = new LinkedList();
    protected Paint mPaint;

    BaseBallBuilder() {
    }

    protected void initPaint(float lineWidth) {
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mPaint.setStrokeWidth(lineWidth);
        this.mPaint.setColor(-16777216);
        this.mPaint.setDither(true);
        this.mPaint.setFilterBitmap(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
    }

    protected final void initPoints(float ballR) {
        float centerX = this.getViewCenterX();
        float centerY = this.getViewCenterY();
        CirclePoint p_0 = new CirclePoint(centerX - ballR, centerY);
        this.mBallPoints.add(p_0);
        CirclePoint p_1 = new CirclePoint(centerX - ballR, centerY + ballR * 0.55191505f);
        this.mBallPoints.add(p_1);
        CirclePoint p_2 = new CirclePoint(centerX - ballR * 0.55191505f, centerY + ballR);
        this.mBallPoints.add(p_2);
        CirclePoint p_3 = new CirclePoint(centerX, centerY + ballR);
        this.mBallPoints.add(p_3);
        CirclePoint p_4 = new CirclePoint(centerX + ballR * 0.55191505f, centerY + ballR);
        this.mBallPoints.add(p_4);
        CirclePoint p_5 = new CirclePoint(centerX + ballR, centerY + ballR * 0.55191505f);
        this.mBallPoints.add(p_5);
        CirclePoint p_6 = new CirclePoint(centerX + ballR, centerY);
        this.mBallPoints.add(p_6);
        CirclePoint p_7 = new CirclePoint(centerX + ballR, centerY - ballR * 0.55191505f);
        this.mBallPoints.add(p_7);
        CirclePoint p_8 = new CirclePoint(centerX + ballR * 0.55191505f, centerY - ballR);
        this.mBallPoints.add(p_8);
        CirclePoint p_9 = new CirclePoint(centerX, centerY - ballR);
        this.mBallPoints.add(p_9);
        CirclePoint p_10 = new CirclePoint(centerX - ballR * 0.55191505f, centerY - ballR);
        this.mBallPoints.add(p_10);
        CirclePoint p_11 = new CirclePoint(centerX - ballR, centerY - ballR * 0.55191505f);
        this.mBallPoints.add(p_11);
    }

    protected final void drawBall(Canvas canvas, Path path, Paint paint) {
        path.reset();
        path.moveTo(this.mBallPoints.get(0).getX(), this.mBallPoints.get(0).getY());
        path.cubicTo(this.mBallPoints.get(1).getX(), this.mBallPoints.get(1).getY(), this.mBallPoints.get(2).getX(), this.mBallPoints.get(2).getY(), this.mBallPoints.get(3).getX(), this.mBallPoints.get(3).getY());
        path.cubicTo(this.mBallPoints.get(4).getX(), this.mBallPoints.get(4).getY(), this.mBallPoints.get(5).getX(), this.mBallPoints.get(5).getY(), this.mBallPoints.get(6).getX(), this.mBallPoints.get(6).getY());
        path.cubicTo(this.mBallPoints.get(7).getX(), this.mBallPoints.get(7).getY(), this.mBallPoints.get(8).getX(), this.mBallPoints.get(8).getY(), this.mBallPoints.get(9).getX(), this.mBallPoints.get(9).getY());
        path.cubicTo(this.mBallPoints.get(10).getX(), this.mBallPoints.get(10).getY(), this.mBallPoints.get(11).getX(), this.mBallPoints.get(11).getY(), this.mBallPoints.get(0).getX(), this.mBallPoints.get(0).getY());
        canvas.drawPath(path, paint);
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    static class CirclePoint {
        private final float mX;
        private final float mY;
        private float mOffsetX = 0.0f;
        private float mOffsetY = 0.0f;
        private boolean mEnabled = true;

        CirclePoint(float x, float y) {
            this.mX = x;
            this.mY = y;
        }

        float getX() {
            return this.mX + this.mOffsetX;
        }

        float getY() {
            return this.mY + this.mOffsetY;
        }

        void setOffsetX(float offsetX) {
            this.mOffsetX = offsetX;
        }

        void setOffsetY(float offsetY) {
            this.mOffsetY = offsetY;
        }

        public void setEnabled(boolean enabled) {
            this.mEnabled = enabled;
        }

        void draw(Canvas canvas, float r, Paint paint) {
            if (this.mEnabled) {
                canvas.drawCircle(this.getX(), this.getY(), r, paint);
            }
        }
    }
}

