/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.ball;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.annotation.FloatRange;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.zyao89.view.zloading.ball.BaseBallBuilder;
import java.util.LinkedList;

public class ElasticBallBuilder
extends BaseBallBuilder {
    private static final int FINAL_STATE = 2;
    private static final int SUM_POINT_POS = 5;
    private final LinkedList<BaseBallBuilder.CirclePoint> mBGCircles = new LinkedList();
    private long mDurationTime = 333L;
    private float mBallR;
    private Path mPath;
    private int mCurrAnimatorState = 0;
    private float mCanvasTranslateOffset;
    private boolean mIsReverse = false;
    private int mCurrPointPos = 0;

    @Override
    protected void initParams(Context context) {
        this.mBallR = this.getAllSize() / 5.0f;
        this.mCanvasTranslateOffset = this.getIntrinsicWidth() / 5.0f;
        this.mPath = new Path();
        this.initPaint(5.0f);
        this.initPoints(this.mBallR);
        this.initBGPoints();
    }

    private void initBGPoints() {
        float centerX = this.getViewCenterX();
        float centerY = this.getViewCenterY();
        BaseBallBuilder.CirclePoint p_0 = new BaseBallBuilder.CirclePoint(centerX - this.mCanvasTranslateOffset * 2.0f, centerY);
        BaseBallBuilder.CirclePoint p_1 = new BaseBallBuilder.CirclePoint(centerX - this.mCanvasTranslateOffset, centerY);
        BaseBallBuilder.CirclePoint p_2 = new BaseBallBuilder.CirclePoint(centerX, centerY);
        BaseBallBuilder.CirclePoint p_3 = new BaseBallBuilder.CirclePoint(centerX + this.mCanvasTranslateOffset, centerY);
        BaseBallBuilder.CirclePoint p_4 = new BaseBallBuilder.CirclePoint(centerX + this.mCanvasTranslateOffset * 2.0f, centerY);
        p_0.setEnabled(false);
        this.mBGCircles.add(p_0);
        this.mBGCircles.add(p_1);
        this.mBGCircles.add(p_2);
        this.mBGCircles.add(p_3);
        this.mBGCircles.add(p_4);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        this.drawBG(canvas);
        this.drawBall(canvas);
    }

    private void drawBall(Canvas canvas) {
        canvas.save();
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        float offsetX = (float)(this.mBGCircles.size() / 2) * this.mCanvasTranslateOffset;
        canvas.translate(-offsetX + this.mCanvasTranslateOffset * (float)this.mCurrPointPos, 0.0f);
        super.drawBall(canvas, this.mPath, this.mPaint);
        canvas.restore();
    }

    private void drawBG(Canvas canvas) {
        canvas.save();
        this.mPaint.setStyle(Paint.Style.STROKE);
        for (BaseBallBuilder.CirclePoint point : this.mBGCircles) {
            point.draw(canvas, this.mBallR, this.mPaint);
        }
        canvas.restore();
    }

    @Override
    protected void prepareStart(ValueAnimator floatValueAnimator) {
        this.mDurationTime = ElasticBallBuilder.ceil((float)this.getAnimationDuration() * 0.3f);
        floatValueAnimator.setDuration(this.mDurationTime);
    }

    @Override
    protected void prepareEnd() {
    }

    @Override
    protected void computeUpdateValue(ValueAnimator animation, @FloatRange(from=0.0, to=1.0) float animatedValue) {
        float offset = this.mCanvasTranslateOffset;
        int currState = this.mIsReverse ? this.mCurrAnimatorState + 3 : this.mCurrAnimatorState;
        switch (currState) {
            case 0: {
                animation.setDuration(this.mDurationTime);
                animation.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(5)).setOffsetX(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(6)).setOffsetX(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(7)).setOffsetX(animatedValue * offset);
                break;
            }
            case 1: {
                animation.setDuration(this.mDurationTime + 111L);
                animation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(2)).setOffsetX(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(3)).setOffsetX(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(4)).setOffsetX(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(8)).setOffsetX(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(9)).setOffsetX(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(10)).setOffsetX(animatedValue * offset);
                break;
            }
            case 2: {
                animation.setDuration(this.mDurationTime + 333L);
                animation.setInterpolator((TimeInterpolator)new BounceInterpolator());
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(0)).setOffsetX(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(1)).setOffsetX(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(11)).setOffsetX(animatedValue * offset);
                break;
            }
            case 3: {
                animation.setDuration(this.mDurationTime);
                animation.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(0)).setOffsetX((1.0f - animatedValue) * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(1)).setOffsetX((1.0f - animatedValue) * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(11)).setOffsetX((1.0f - animatedValue) * offset);
                break;
            }
            case 4: {
                animation.setDuration(this.mDurationTime + 111L);
                animation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(2)).setOffsetX((1.0f - animatedValue) * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(3)).setOffsetX((1.0f - animatedValue) * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(4)).setOffsetX((1.0f - animatedValue) * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(8)).setOffsetX((1.0f - animatedValue) * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(9)).setOffsetX((1.0f - animatedValue) * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(10)).setOffsetX((1.0f - animatedValue) * offset);
                break;
            }
            case 5: {
                animation.setDuration(this.mDurationTime + 333L);
                animation.setInterpolator((TimeInterpolator)new BounceInterpolator());
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(5)).setOffsetX((1.0f - animatedValue) * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(6)).setOffsetX((1.0f - animatedValue) * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(7)).setOffsetX((1.0f - animatedValue) * offset);
                break;
            }
        }
    }

    @Override
    public void onAnimationRepeat(Animator animation) {
        if (++this.mCurrAnimatorState > 2) {
            BaseBallBuilder.CirclePoint point2;
            int i;
            this.mCurrAnimatorState = 0;
            this.mCurrPointPos = this.mIsReverse ? --this.mCurrPointPos : ++this.mCurrPointPos;
            if (this.mCurrPointPos >= 4) {
                this.mIsReverse = true;
                this.mCurrPointPos = 3;
                for (i = 0; i < this.mBGCircles.size(); ++i) {
                    point2 = this.mBGCircles.get(i);
                    if (i == this.mBGCircles.size() - 1) {
                        point2.setEnabled(true);
                        continue;
                    }
                    point2.setEnabled(false);
                }
            } else if (this.mCurrPointPos < 0) {
                this.mIsReverse = false;
                this.mCurrPointPos = 0;
                for (i = 0; i < this.mBGCircles.size(); ++i) {
                    point2 = this.mBGCircles.get(i);
                    if (i == 0) {
                        point2.setEnabled(false);
                        continue;
                    }
                    point2.setEnabled(true);
                }
            }
            if (this.mIsReverse) {
                for (BaseBallBuilder.CirclePoint point2 : this.mBallPoints) {
                    point2.setOffsetX(this.mCanvasTranslateOffset);
                }
                this.mBGCircles.get(this.mCurrPointPos + 1).setEnabled(true);
            } else {
                for (BaseBallBuilder.CirclePoint point2 : this.mBallPoints) {
                    point2.setOffsetX(0.0f);
                }
                this.mBGCircles.get(this.mCurrPointPos).setEnabled(false);
            }
        }
    }
}

