/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.ball;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.annotation.FloatRange;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.zyao89.view.zloading.ball.BaseBallBuilder;

public class InfectionBallBuilder
extends BaseBallBuilder {
    private long mDurationTime = 888L;
    private long mDurationTime_1 = 222L;
    private long mDurationTime_2 = 333L;
    private long mDurationTime_3 = 1333L;
    private long mDurationTime_4 = 1333L;
    private static final int FINAL_STATE = 4;
    private static final int SUM_POINT_POS = 3;
    private float mBallR;
    private Path mPath;
    private int mCurrAnimatorState = 0;
    private float mCanvasTranslateOffset;

    @Override
    protected void initParams(Context context) {
        this.mBallR = this.getAllSize() / 3.0f;
        this.mCanvasTranslateOffset = this.getIntrinsicWidth() / 3.0f;
        this.mPath = new Path();
        this.initPaint(5.0f);
        this.initPoints(this.mBallR);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        this.drawBall(canvas);
    }

    private void drawBall(Canvas canvas) {
        canvas.save();
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        canvas.translate(0.0f, -this.mCanvasTranslateOffset);
        super.drawBall(canvas, this.mPath, this.mPaint);
        canvas.restore();
    }

    @Override
    protected void prepareStart(ValueAnimator floatValueAnimator) {
        this.mDurationTime = InfectionBallBuilder.ceil((double)this.getAnimationDuration() * 0.7);
        this.mDurationTime_1 = InfectionBallBuilder.ceil((double)this.getAnimationDuration() * 0.2);
        this.mDurationTime_2 = InfectionBallBuilder.ceil((double)this.getAnimationDuration() * 0.3);
        this.mDurationTime_3 = this.getAnimationDuration();
        this.mDurationTime_4 = this.getAnimationDuration();
    }

    @Override
    protected void prepareEnd() {
    }

    @Override
    protected void computeUpdateValue(ValueAnimator animation, @FloatRange(from=0.0, to=1.0) float animatedValue) {
        float offset = this.mCanvasTranslateOffset;
        switch (this.mCurrAnimatorState) {
            case 0: {
                animation.setDuration(this.mDurationTime);
                animation.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(2)).setOffsetY(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(3)).setOffsetY(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(4)).setOffsetY(animatedValue * offset);
                break;
            }
            case 1: {
                animation.setDuration(this.mDurationTime_1);
                animation.setInterpolator((TimeInterpolator)new LinearInterpolator());
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(5)).setOffsetY(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(6)).setOffsetY(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(7)).setOffsetY(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(1)).setOffsetY(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(0)).setOffsetY(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(11)).setOffsetY(animatedValue * offset);
                break;
            }
            case 2: {
                animation.setDuration(this.mDurationTime_2);
                animation.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                for (int i = 0; i < this.mBallPoints.size(); ++i) {
                    if (i > 10 || i < 8) {
                        ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(i)).setOffsetY(animatedValue * offset + offset);
                        continue;
                    }
                    ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(i)).setOffsetY(animatedValue * offset);
                }
                break;
            }
            case 3: {
                animation.setDuration(this.mDurationTime_3);
                animation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(8)).setOffsetY(animatedValue * offset + offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(9)).setOffsetY(animatedValue * offset + offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(10)).setOffsetY(animatedValue * offset + offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(5)).setOffsetX(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(6)).setOffsetX(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(7)).setOffsetX(animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(1)).setOffsetX(-animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(0)).setOffsetX(-animatedValue * offset);
                ((BaseBallBuilder.CirclePoint)this.mBallPoints.get(11)).setOffsetX(-animatedValue * offset);
                break;
            }
            case 4: {
                animation.setDuration(this.mDurationTime_4);
                this.mPaint.setAlpha((int)((1.0f - animatedValue) * 255.0f));
                break;
            }
        }
    }

    @Override
    public void onAnimationRepeat(Animator animation) {
        if (++this.mCurrAnimatorState > 4) {
            this.mCurrAnimatorState = 0;
            for (BaseBallBuilder.CirclePoint point : this.mBallPoints) {
                point.setOffsetY(0.0f);
                point.setOffsetX(0.0f);
            }
            this.mPaint.setAlpha(255);
        }
    }
}

