/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.ball;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.annotation.FloatRange;
import android.view.animation.AccelerateInterpolator;
import com.zyao89.view.zloading.ball.BaseBallBuilder;

public class IntertwineBuilder
extends BaseBallBuilder {
    private static final int FINAL_STATE = 1;
    private float mBallR;
    private Path mPath;
    private int mCurrAnimatorState = 0;

    @Override
    protected void initParams(Context context) {
        this.mBallR = this.getAllSize();
        this.mPath = new Path();
        this.initPaint(5.0f);
        this.initPoints(this.mBallR);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        this.drawBall(canvas);
    }

    private void drawBall(Canvas canvas) {
        canvas.save();
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        super.drawBall(canvas, this.mPath, this.mPaint);
        canvas.restore();
    }

    @Override
    protected void prepareStart(ValueAnimator floatValueAnimator) {
    }

    @Override
    protected void prepareEnd() {
    }

    @Override
    protected void computeUpdateValue(ValueAnimator animation, @FloatRange(from=0.0, to=1.0) float animatedValue) {
        switch (this.mCurrAnimatorState) {
            case 1: {
                animation.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                for (int i = 0; i < this.mBallPoints.size(); ++i) {
                    BaseBallBuilder.CirclePoint circlePoint = (BaseBallBuilder.CirclePoint)this.mBallPoints.get(i);
                    if (2 <= i && i <= 7) {
                        circlePoint.setOffsetX(-this.mBallR * (1.0f - animatedValue));
                        circlePoint.setOffsetY(-this.mBallR * (1.0f - animatedValue));
                        continue;
                    }
                    circlePoint.setOffsetX(this.mBallR * (1.0f - animatedValue));
                    circlePoint.setOffsetY(this.mBallR * (1.0f - animatedValue));
                }
                break;
            }
            case 0: {
                animation.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                for (int i = 0; i < this.mBallPoints.size(); ++i) {
                    BaseBallBuilder.CirclePoint circlePoint = (BaseBallBuilder.CirclePoint)this.mBallPoints.get(i);
                    if (2 <= i && i <= 7) {
                        circlePoint.setOffsetX(-this.mBallR * animatedValue);
                        circlePoint.setOffsetY(-this.mBallR * animatedValue);
                        continue;
                    }
                    circlePoint.setOffsetX(this.mBallR * animatedValue);
                    circlePoint.setOffsetY(this.mBallR * animatedValue);
                }
                break;
            }
        }
    }

    @Override
    public void onAnimationRepeat(Animator animation) {
        if (++this.mCurrAnimatorState > 1) {
            this.mCurrAnimatorState = 0;
            for (BaseBallBuilder.CirclePoint point : this.mBallPoints) {
                point.setOffsetY(0.0f);
                point.setOffsetX(0.0f);
            }
        }
    }
}

