/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.base;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import com.zyao89.view.zloading.ZLoadingBuilder;

public abstract class BaseStateBuilder
extends ZLoadingBuilder {
    private int mCurrAnimatorState = 0;
    private Paint mPaint;

    protected abstract int getStateCount();

    protected abstract void initParams(Context var1, Paint var2);

    protected abstract void onComputeUpdateValue(ValueAnimator var1, float var2, int var3);

    @Override
    protected final void initParams(Context context) {
        this.initPaint();
        this.initParams(context, this.mPaint);
    }

    private void initPaint() {
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(6.0f);
        this.mPaint.setColor(-16777216);
        this.mPaint.setDither(true);
        this.mPaint.setFilterBitmap(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void computeUpdateValue(ValueAnimator animation, float animatedValue) {
        this.onComputeUpdateValue(animation, animatedValue, this.mCurrAnimatorState);
    }

    @Override
    public void onAnimationRepeat(Animator animation) {
        int iFinalState = this.getStateCount();
        if (++this.mCurrAnimatorState > iFinalState) {
            this.mCurrAnimatorState = 0;
        }
    }

    @Override
    protected void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }
}

