/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.circle;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import com.zyao89.view.zloading.ZLoadingBuilder;

public class DoubleCircleBuilder
extends ZLoadingBuilder {
    private static final int OUTER_CIRCLE_ANGLE = 270;
    private static final int INTER_CIRCLE_ANGLE = 90;
    private Paint mStrokePaint;
    private RectF mOuterCircleRectF;
    private RectF mInnerCircleRectF;
    private int mRotateAngle;

    @Override
    protected void initParams(Context context) {
        float outR = this.getAllSize();
        float inR = outR * 0.6f;
        this.initPaint(inR * 0.4f);
        this.mRotateAngle = 0;
        this.mOuterCircleRectF = new RectF();
        this.mOuterCircleRectF.set(this.getViewCenterX() - outR, this.getViewCenterY() - outR, this.getViewCenterX() + outR, this.getViewCenterY() + outR);
        this.mInnerCircleRectF = new RectF();
        this.mInnerCircleRectF.set(this.getViewCenterX() - inR, this.getViewCenterY() - inR, this.getViewCenterX() + inR, this.getViewCenterY() + inR);
    }

    private void initPaint(float lineWidth) {
        this.mStrokePaint = new Paint(1);
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        this.mStrokePaint.setStrokeWidth(lineWidth);
        this.mStrokePaint.setColor(-1);
        this.mStrokePaint.setDither(true);
        this.mStrokePaint.setFilterBitmap(true);
        this.mStrokePaint.setStrokeCap(Paint.Cap.ROUND);
        this.mStrokePaint.setStrokeJoin(Paint.Join.ROUND);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        canvas.save();
        canvas.drawArc(this.mOuterCircleRectF, (float)(this.mRotateAngle % 360), 270.0f, false, this.mStrokePaint);
        canvas.drawArc(this.mInnerCircleRectF, (float)(270 - this.mRotateAngle % 360), 90.0f, false, this.mStrokePaint);
        canvas.restore();
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mStrokePaint.setAlpha(alpha);
    }

    @Override
    protected void prepareStart(ValueAnimator floatValueAnimator) {
    }

    @Override
    protected void prepareEnd() {
    }

    @Override
    protected void computeUpdateValue(ValueAnimator animation, @FloatRange(from=0.0, to=1.0) float animatedValue) {
        this.mRotateAngle = (int)(360.0f * animatedValue);
    }

    @Override
    protected void setColorFilter(ColorFilter colorFilter) {
        this.mStrokePaint.setColorFilter(colorFilter);
    }
}

