/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.circle;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import com.zyao89.view.zloading.ZLoadingBuilder;

public class PacManBuilder
extends ZLoadingBuilder {
    private static final int FINAL_STATE = 9;
    private static final int MAX_MOUTH_ANGLE = 45;
    private long mDurationTime = 333L;
    private Paint mFullPaint;
    private RectF mOuterCircleRectF;
    private int mMouthAngle;
    private float mMoveDistance;
    private int mCurrAnimatorState = 0;
    private int HorizontalAngle;
    private float mMaxMoveRange;
    private float mLastMoveDistance;
    private float mDefaultStartMoveX;

    @Override
    protected void initParams(Context context) {
        float outR = this.getAllSize();
        float inR = outR * 0.7f;
        this.mMaxMoveRange = this.getIntrinsicWidth() + 2.0f * inR;
        this.initPaint();
        this.mMouthAngle = 45;
        this.HorizontalAngle = 0;
        this.mDefaultStartMoveX = -this.mMaxMoveRange * 0.5f;
        this.mMoveDistance = 0.0f;
        this.mOuterCircleRectF = new RectF(this.getViewCenterX() - inR, this.getViewCenterY() - inR, this.getViewCenterX() + inR, this.getViewCenterY() + inR);
    }

    private void initPaint() {
        this.mFullPaint = new Paint(1);
        this.mFullPaint.setStyle(Paint.Style.FILL);
        this.mFullPaint.setColor(-1);
        this.mFullPaint.setDither(true);
        this.mFullPaint.setFilterBitmap(true);
        this.mFullPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mFullPaint.setStrokeJoin(Paint.Join.ROUND);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        canvas.save();
        canvas.translate(this.mDefaultStartMoveX + this.mMoveDistance, 0.0f);
        canvas.rotate((float)this.HorizontalAngle, this.getViewCenterX(), this.getViewCenterY());
        canvas.drawArc(this.mOuterCircleRectF, (float)this.mMouthAngle, (float)(360 - this.mMouthAngle * 2), true, this.mFullPaint);
        canvas.restore();
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mFullPaint.setAlpha(alpha);
    }

    @Override
    protected void prepareStart(ValueAnimator floatValueAnimator) {
        this.mDurationTime = PacManBuilder.ceil((double)this.getAnimationDuration() * 0.3);
        floatValueAnimator.setDuration(this.mDurationTime);
    }

    @Override
    protected void prepareEnd() {
    }

    @Override
    protected void computeUpdateValue(ValueAnimator animation, @FloatRange(from=0.0, to=1.0) float animatedValue) {
        int half = 5;
        float step = this.mMaxMoveRange / (float)half;
        if (this.mCurrAnimatorState < half) {
            this.HorizontalAngle = 0;
            this.mMoveDistance = this.mLastMoveDistance + step * animatedValue;
        } else {
            this.HorizontalAngle = 180;
            this.mMoveDistance = this.mLastMoveDistance - step * animatedValue;
        }
        this.mMouthAngle = this.mCurrAnimatorState % 2 == 0 ? (int)(45.0f * animatedValue) + 5 : (int)(45.0f * (1.0f - animatedValue)) + 5;
    }

    @Override
    public void onAnimationRepeat(Animator animation) {
        if (++this.mCurrAnimatorState > 9) {
            this.mCurrAnimatorState = 0;
        }
        int half = 5;
        float stepRange = this.mMaxMoveRange / (float)half;
        this.mLastMoveDistance = this.mCurrAnimatorState < half ? stepRange * (float)this.mCurrAnimatorState : stepRange * (float)(half - this.mCurrAnimatorState % half);
    }

    @Override
    protected void setColorFilter(ColorFilter colorFilter) {
        this.mFullPaint.setColorFilter(colorFilter);
    }
}

