/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.circle;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.support.annotation.FloatRange;
import com.zyao89.view.zloading.ZLoadingBuilder;

public class RotateCircleBuilder
extends ZLoadingBuilder {
    private static final int CIRCLE_NUM = 10;
    private Paint mFullPaint;
    private float mOuterRadius;
    private float mDefaultAngle;
    private float mInterRadius;

    @Override
    protected void initParams(Context context) {
        this.mOuterRadius = this.getAllSize();
        this.initPaint();
        this.mInterRadius = RotateCircleBuilder.dip2px(context, 2.0f);
    }

    private void initPaint() {
        this.mFullPaint = new Paint(1);
        this.mFullPaint.setStyle(Paint.Style.FILL);
        this.mFullPaint.setColor(-16777216);
        this.mFullPaint.setDither(true);
        this.mFullPaint.setFilterBitmap(true);
        this.mFullPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mFullPaint.setStrokeJoin(Paint.Join.ROUND);
    }

    private void drawCircles(Canvas canvas) {
        int all = 10;
        for (int i = 0; i < all; ++i) {
            int angle = (int)((float)(360 / all * i) + this.mDefaultAngle);
            float centerX = this.getViewCenterX() + this.mOuterRadius * this.cos(angle);
            float centerY = this.getViewCenterY() + this.mOuterRadius * this.sin(angle);
            this.mFullPaint.setAlpha(255 / all * i);
            canvas.drawCircle(centerX, centerY, (float)i + this.mInterRadius, this.mFullPaint);
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        this.drawCircles(canvas);
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mFullPaint.setAlpha(alpha);
    }

    @Override
    protected void prepareStart(ValueAnimator floatValueAnimator) {
    }

    @Override
    protected void prepareEnd() {
    }

    @Override
    protected void computeUpdateValue(ValueAnimator animation, @FloatRange(from=0.0, to=1.0) float animatedValue) {
        this.mDefaultAngle = 360.0f * animatedValue;
    }

    @Override
    protected void setColorFilter(ColorFilter colorFilter) {
        this.mFullPaint.setColorFilter(colorFilter);
    }

    protected final float cos(int num) {
        return (float)Math.cos((double)num * Math.PI / 180.0);
    }

    protected final float sin(int num) {
        return (float)Math.sin((double)num * Math.PI / 180.0);
    }
}

