/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.circle;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import com.zyao89.view.zloading.ZLoadingBuilder;

public class SingleCircleBuilder
extends ZLoadingBuilder {
    private static final int OUTER_CIRCLE_ANGLE = 320;
    private static final int FINAL_STATE = 2;
    private int mCurrAnimatorState = 0;
    private Paint mStrokePaint;
    private RectF mOuterCircleRectF;
    private int mStartRotateAngle;
    private int mRotateAngle;

    @Override
    protected void initParams(Context context) {
        float outR = this.getAllSize();
        float inR = outR * 0.6f;
        this.initPaint(inR * 0.4f);
        this.mStartRotateAngle = 0;
        this.mOuterCircleRectF = new RectF();
        this.mOuterCircleRectF.set(this.getViewCenterX() - outR, this.getViewCenterY() - outR, this.getViewCenterX() + outR, this.getViewCenterY() + outR);
    }

    private void initPaint(float lineWidth) {
        this.mStrokePaint = new Paint(1);
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        this.mStrokePaint.setStrokeWidth(lineWidth);
        this.mStrokePaint.setColor(-1);
        this.mStrokePaint.setDither(true);
        this.mStrokePaint.setFilterBitmap(true);
        this.mStrokePaint.setStrokeCap(Paint.Cap.ROUND);
        this.mStrokePaint.setStrokeJoin(Paint.Join.ROUND);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        canvas.save();
        canvas.drawArc(this.mOuterCircleRectF, (float)(this.mStartRotateAngle % 360), (float)(this.mRotateAngle % 360), false, this.mStrokePaint);
        canvas.restore();
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mStrokePaint.setAlpha(alpha);
    }

    @Override
    protected void prepareStart(ValueAnimator floatValueAnimator) {
    }

    @Override
    protected void prepareEnd() {
    }

    @Override
    protected void computeUpdateValue(ValueAnimator animation, @FloatRange(from=0.0, to=1.0) float animatedValue) {
        this.mStartRotateAngle = (int)(360.0f * animatedValue);
        switch (this.mCurrAnimatorState) {
            case 0: {
                this.mRotateAngle = (int)(320.0f * animatedValue);
                break;
            }
            case 1: {
                this.mRotateAngle = 320 - (int)(320.0f * animatedValue);
                break;
            }
        }
    }

    @Override
    public void onAnimationRepeat(Animator animation) {
        if (++this.mCurrAnimatorState > 2) {
            this.mCurrAnimatorState = 0;
        }
    }

    @Override
    protected void setColorFilter(ColorFilter colorFilter) {
        this.mStrokePaint.setColorFilter(colorFilter);
    }
}

