/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.circle;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import com.zyao89.view.zloading.ZLoadingBuilder;

public class SnakeCircleBuilder
extends ZLoadingBuilder {
    private static final int FINAL_STATE = 1;
    private int mCurrAnimatorState = 0;
    private Paint mStrokePaint;
    private float mOuterRF;
    private float mInterRF;
    private RectF mOuterCircleRectF;
    private RectF mInterCircleRectF;
    private int mAlpha = 255;
    private float mRotateAngle;
    private float mAntiRotateAngle;
    private Path mPath;
    private PathMeasure mPathMeasure;
    private Path mDrawPath;

    @Override
    protected void initParams(Context context) {
        this.mOuterRF = this.getAllSize() * 1.0f;
        this.mInterRF = this.mOuterRF * 0.7f;
        this.initPaint(this.mInterRF * 0.4f);
        this.mRotateAngle = 0.0f;
        this.mOuterCircleRectF = new RectF();
        this.mOuterCircleRectF.set(this.getViewCenterX() - this.mOuterRF, this.getViewCenterY() - this.mOuterRF, this.getViewCenterX() + this.mOuterRF, this.getViewCenterY() + this.mOuterRF);
        this.mInterCircleRectF = new RectF();
        this.mInterCircleRectF.set(this.getViewCenterX() - this.mInterRF, this.getViewCenterY() - this.mInterRF, this.getViewCenterX() + this.mInterRF, this.getViewCenterY() + this.mInterRF);
        this.initPathMeasure();
        this.initPaths();
    }

    private void initPaint(float lineWidth) {
        this.mStrokePaint = new Paint(1);
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        this.mStrokePaint.setStrokeWidth(lineWidth);
        this.mStrokePaint.setColor(-1);
        this.mStrokePaint.setDither(true);
        this.mStrokePaint.setFilterBitmap(true);
        this.mStrokePaint.setStrokeCap(Paint.Cap.ROUND);
        this.mStrokePaint.setStrokeJoin(Paint.Join.ROUND);
    }

    private void initPathMeasure() {
        this.mDrawPath = new Path();
        this.mPathMeasure = new PathMeasure();
    }

    private void initPaths() {
        this.mPath = new Path();
        float pointOffset = this.mOuterRF * 0.3f;
        float pointOffsetHalf = this.mOuterRF * 0.3f * 0.5f;
        this.mPath.moveTo(this.getViewCenterX() - this.mOuterRF * 0.8f, this.getViewCenterY());
        this.mPath.lineTo(this.getViewCenterX() - pointOffset, this.getViewCenterY());
        this.mPath.lineTo(this.getViewCenterX() - pointOffsetHalf, this.getViewCenterY() + pointOffsetHalf);
        this.mPath.lineTo(this.getViewCenterX() + pointOffsetHalf, this.getViewCenterY() - pointOffsetHalf);
        this.mPath.lineTo(this.getViewCenterX() + pointOffset, this.getViewCenterY());
        this.mPath.lineTo(this.getViewCenterX() + this.mOuterRF * 0.8f, this.getViewCenterY());
    }

    @Override
    protected void onDraw(Canvas canvas) {
        canvas.save();
        this.mStrokePaint.setStrokeWidth(this.mOuterRF * 0.05f);
        this.mStrokePaint.setAlpha((int)((float)this.mAlpha * 0.6f));
        canvas.drawCircle(this.getViewCenterX(), this.getViewCenterY(), this.mOuterRF, this.mStrokePaint);
        canvas.drawCircle(this.getViewCenterX(), this.getViewCenterY(), this.mInterRF, this.mStrokePaint);
        canvas.restore();
        canvas.save();
        this.mStrokePaint.setStrokeWidth(this.mOuterRF * 0.1f);
        this.mStrokePaint.setAlpha(this.mAlpha);
        canvas.rotate(this.mRotateAngle, this.getViewCenterX(), this.getViewCenterY());
        canvas.drawArc(this.mOuterCircleRectF, 0.0f, 120.0f, false, this.mStrokePaint);
        canvas.drawArc(this.mOuterCircleRectF, 180.0f, 120.0f, false, this.mStrokePaint);
        canvas.restore();
        canvas.save();
        this.mStrokePaint.setAlpha((int)((float)this.mAlpha * 0.6f));
        canvas.drawPath(this.mDrawPath, this.mStrokePaint);
        canvas.restore();
        canvas.save();
        this.mStrokePaint.setStrokeWidth(this.mOuterRF * 0.1f);
        this.mStrokePaint.setAlpha(this.mAlpha);
        canvas.rotate(this.mAntiRotateAngle, this.getViewCenterX(), this.getViewCenterY());
        canvas.drawArc(this.mInterCircleRectF, 60.0f, 60.0f, false, this.mStrokePaint);
        canvas.drawArc(this.mInterCircleRectF, 180.0f, 180.0f, false, this.mStrokePaint);
        canvas.restore();
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    @Override
    protected void prepareStart(ValueAnimator floatValueAnimator) {
    }

    @Override
    protected void prepareEnd() {
    }

    @Override
    protected void computeUpdateValue(ValueAnimator animation, @FloatRange(from=0.0, to=1.0) float animatedValue) {
        this.mRotateAngle = 360.0f * animatedValue;
        this.mAntiRotateAngle = 360.0f * (1.0f - animatedValue);
        switch (this.mCurrAnimatorState) {
            case 0: {
                this.resetDrawPath();
                this.mPathMeasure.setPath(this.mPath, false);
                float stop = this.mPathMeasure.getLength() * animatedValue;
                float start = 0.0f;
                this.mPathMeasure.getSegment(start, stop, this.mDrawPath, true);
                break;
            }
            case 1: {
                this.resetDrawPath();
                this.mPathMeasure.setPath(this.mPath, false);
                float stop = this.mPathMeasure.getLength();
                float start = this.mPathMeasure.getLength() * animatedValue;
                this.mPathMeasure.getSegment(start, stop, this.mDrawPath, true);
                break;
            }
        }
    }

    @Override
    public void onAnimationRepeat(Animator animation) {
        if (++this.mCurrAnimatorState > 1) {
            this.mCurrAnimatorState = 0;
        }
    }

    @Override
    protected void setColorFilter(ColorFilter colorFilter) {
        this.mStrokePaint.setColorFilter(colorFilter);
    }

    private void resetDrawPath() {
        this.mDrawPath.reset();
        this.mDrawPath.lineTo(0.0f, 0.0f);
    }
}

