/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.clock;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import com.zyao89.view.zloading.ZLoadingBuilder;

public class CircleBuilder
extends ZLoadingBuilder {
    private static final float DEFAULT_ANGLE = -90.0f;
    private RectF mInnerCircleRectF;
    private Paint mPaint;
    private float mStartAngle;
    private float mEndAngle;
    private boolean mIsFirstState = true;

    private void initValues(Context context) {
        float allSize = this.getAllSize();
        float innerRadius = allSize - CircleBuilder.dip2px(context, 3.0f);
        this.mInnerCircleRectF = new RectF();
        this.mStartAngle = -90.0f;
        this.mEndAngle = -90.0f;
        float viewCenterX = this.getViewCenterX();
        float viewCenterY = this.getViewCenterY();
        this.mInnerCircleRectF.set(viewCenterX - innerRadius, viewCenterY - innerRadius, viewCenterX + innerRadius, viewCenterY + innerRadius);
    }

    @Override
    protected void initParams(Context context) {
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-16777216);
        this.initValues(context);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        canvas.save();
        canvas.drawArc(this.mInnerCircleRectF, this.mStartAngle, this.mEndAngle - this.mStartAngle, true, this.mPaint);
        canvas.restore();
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void prepareStart(ValueAnimator floatValueAnimator) {
    }

    @Override
    protected void prepareEnd() {
    }

    @Override
    protected void computeUpdateValue(ValueAnimator animation, @FloatRange(from=0.0, to=1.0) float animatedValue) {
        if (this.mIsFirstState) {
            this.mEndAngle = animatedValue * 360.0f + -90.0f;
        } else {
            this.mStartAngle = animatedValue * 360.0f + -90.0f;
        }
    }

    @Override
    protected void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    @Override
    public void onAnimationStart(Animator animation) {
        this.mStartAngle = -90.0f;
        this.mEndAngle = -90.0f;
    }

    @Override
    public void onAnimationEnd(Animator animation) {
        this.mStartAngle = -90.0f;
        this.mEndAngle = -90.0f;
    }

    @Override
    public void onAnimationCancel(Animator animation) {
        this.mStartAngle = -90.0f;
        this.mEndAngle = -90.0f;
    }

    @Override
    public void onAnimationRepeat(Animator animation) {
        boolean bl = this.mIsFirstState = !this.mIsFirstState;
        if (this.mIsFirstState) {
            this.mStartAngle = -90.0f;
            this.mEndAngle = -90.0f;
        } else {
            this.mStartAngle = -90.0f;
            this.mEndAngle = 270.0f;
        }
    }

    protected Paint getPaint() {
        return this.mPaint;
    }
}

