/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.clock;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import com.zyao89.view.zloading.clock.CircleBuilder;

public class ClockBuilder
extends CircleBuilder {
    private float mOuterRadius;
    private float mCircleSpace;
    private Paint mStrokePaint;
    private Paint mFillPaint;
    private RectF mBtnRectF;
    private RectF mBottomBtnRectF;

    @Override
    protected void initParams(Context context) {
        super.initParams(context);
        this.initOptions(context);
        this.createStrokePaint();
        this.createFillPaint();
    }

    private void initOptions(Context context) {
        float allSize = this.getAllSize();
        this.mCircleSpace = 4.0f;
        this.mOuterRadius = allSize - this.mCircleSpace;
        float btnWidth = ClockBuilder.dip2px(context, 8.0f);
        float btnHeight = ClockBuilder.dip2px(context, 3.0f);
        float bottomBtnWidth = ClockBuilder.dip2px(context, 3.0f);
        float bottomBtnHeight = ClockBuilder.dip2px(context, 2.0f);
        this.mBtnRectF = new RectF(this.getViewCenterX() - btnWidth / 2.0f, this.getViewCenterY() - allSize - bottomBtnHeight - btnHeight, this.getViewCenterX() + btnWidth / 2.0f, this.getViewCenterY() - allSize - bottomBtnHeight);
        this.mBottomBtnRectF = new RectF(this.getViewCenterX() - bottomBtnWidth / 2.0f, this.getViewCenterY() - allSize - bottomBtnHeight, this.getViewCenterX() + bottomBtnWidth / 2.0f, this.getViewCenterY() - allSize);
    }

    private void createStrokePaint() {
        this.mStrokePaint = new Paint(1);
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        this.mStrokePaint.setStrokeWidth(this.mCircleSpace);
        this.mStrokePaint.setColor(-16777216);
    }

    private void createFillPaint() {
        this.mFillPaint = new Paint(1);
        this.mFillPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mFillPaint.setColor(-16777216);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawCircle(this.getViewCenterX(), this.getViewCenterY(), this.mOuterRadius, this.mStrokePaint);
        canvas.drawRect(this.mBtnRectF, this.mFillPaint);
        canvas.drawRect(this.mBottomBtnRectF, this.mFillPaint);
        canvas.save();
        canvas.rotate(45.0f, this.getViewCenterX(), this.getViewCenterY());
        canvas.drawRect(this.mBottomBtnRectF, this.mFillPaint);
        canvas.restore();
        canvas.translate(0.0f, 20.0f);
    }

    @Override
    protected void setAlpha(int alpha) {
        super.setAlpha(alpha);
        this.mStrokePaint.setAlpha(alpha);
        this.mFillPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter colorFilter) {
        super.setColorFilter(colorFilter);
        this.mStrokePaint.setColorFilter(colorFilter);
        this.mFillPaint.setColorFilter(colorFilter);
    }
}

