/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.path;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.graphics.RectF;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.zyao89.view.zloading.base.BaseStateBuilder;
import java.util.LinkedList;

public class MusicPathBuilder
extends BaseStateBuilder {
    private final int MUSIC_LINE_COUNT = 5;
    private Paint mPaint;
    private float mR;
    private LinkedList<Path> mMusicPaths;
    private LinkedList<Path> mMusicDrawPaths;
    private PathMeasure mPathMeasure;
    private LinkedList<MusicParam> mMusicParams;
    private boolean mOpenJump = false;
    private DecelerateInterpolator mDecelerateInterpolator;
    private BounceInterpolator mBounceInterpolator;

    @Override
    protected int getStateCount() {
        return 3;
    }

    @Override
    protected void initParams(Context context, Paint paint) {
        this.mPaint = paint;
        this.mPaint.setStrokeWidth(2.0f);
        this.mR = this.getAllSize();
        this.initPaths();
        this.initPathMeasure();
        this.initMusicParams();
        this.initInterpolator();
    }

    private void initPaths() {
        this.mMusicPaths = new LinkedList();
        float lineW = this.mR * 2.0f;
        float space = this.mR * 2.0f / 5.0f;
        float startXP = this.getViewCenterX() - this.mR;
        float startYP = this.getViewCenterY() + this.mR;
        for (int i = 0; i < 5; ++i) {
            Path path = new Path();
            path.moveTo(startXP, startYP - (float)i * space);
            path.lineTo(startXP + lineW, startYP - (float)i * space);
            this.mMusicPaths.add(path);
        }
    }

    private void initPathMeasure() {
        this.mMusicDrawPaths = new LinkedList();
        for (int i = 0; i < 5; ++i) {
            Path drawPath = new Path();
            this.mMusicDrawPaths.add(drawPath);
        }
        this.mPathMeasure = new PathMeasure();
    }

    private void initMusicParams() {
        float musicWidth = this.mR * 0.2f;
        float musicHeight = this.mR;
        this.mMusicParams = new LinkedList();
        float musicPointHeight = this.mR * 2.0f / 5.0f;
        float left = this.getViewCenterX() - musicWidth / 2.0f;
        float right = this.getViewCenterX() + musicWidth / 2.0f;
        float top = this.getViewCenterY() + musicHeight - musicPointHeight * 1.5f;
        float bottom = this.getViewCenterY() + musicHeight - musicPointHeight * 0.5f;
        RectF rectF = new RectF(left - this.mR * 0.5f, top, right - this.mR * 0.5f, bottom);
        float offsetX = (float)((double)musicWidth * 0.5 * Math.cos(75.0));
        PointF sPointF = new PointF(rectF.right + offsetX, rectF.centerY());
        PointF ePointF = new PointF(rectF.right + offsetX, rectF.centerY() - musicHeight);
        MusicParam musicParam = new MusicParam(rectF, sPointF, ePointF);
        this.mMusicParams.add(musicParam);
        rectF = new RectF(left + this.mR * 0.5f, top - musicPointHeight, right + this.mR * 0.5f, bottom - musicPointHeight);
        offsetX = (float)((double)musicWidth * 0.5 * Math.cos(75.0));
        sPointF = new PointF(rectF.right + offsetX, rectF.centerY());
        ePointF = new PointF(rectF.right + offsetX, rectF.centerY() - musicHeight);
        musicParam = new MusicParam(rectF, sPointF, ePointF);
        this.mMusicParams.add(musicParam);
    }

    private void initInterpolator() {
        this.mDecelerateInterpolator = new DecelerateInterpolator();
        this.mBounceInterpolator = new BounceInterpolator();
    }

    @Override
    protected void onComputeUpdateValue(ValueAnimator animation, float animatedValue, int state) {
        switch (state) {
            case 0: {
                animation.setInterpolator((TimeInterpolator)this.mDecelerateInterpolator);
                this.resetDrawPath();
                for (int i = 0; i < 5; ++i) {
                    float start;
                    float stop;
                    this.mPathMeasure.setPath(this.mMusicPaths.get(i), false);
                    if (i % 2 == 0) {
                        stop = this.mPathMeasure.getLength() * animatedValue;
                        start = (float)((double)stop - (0.5 - Math.abs((double)animatedValue - 0.5)) * 200.0);
                        this.mPathMeasure.getSegment(start, stop, this.mMusicDrawPaths.get(i), true);
                        continue;
                    }
                    stop = this.mPathMeasure.getLength() * (1.0f - animatedValue);
                    start = (float)((double)stop - (0.5 - Math.abs((double)(1.0f - animatedValue) - 0.5)) * 200.0);
                    this.mPathMeasure.getSegment(start, stop, this.mMusicDrawPaths.get(i), true);
                }
                break;
            }
            case 1: {
                this.resetDrawPath();
                for (int i = 0; i < 5; ++i) {
                    float start;
                    float stop;
                    this.mPathMeasure.setPath(this.mMusicPaths.get(i), false);
                    if (i % 2 == 0) {
                        stop = this.mPathMeasure.getLength() * animatedValue;
                        start = 0.0f;
                        this.mPathMeasure.getSegment(start, stop, this.mMusicDrawPaths.get(i), true);
                        continue;
                    }
                    stop = this.mPathMeasure.getLength();
                    start = this.mPathMeasure.getLength() * (1.0f - animatedValue);
                    this.mPathMeasure.getSegment(start, stop, this.mMusicDrawPaths.get(i), true);
                }
                break;
            }
            case 2: {
                animation.setInterpolator((TimeInterpolator)this.mBounceInterpolator);
                this.mOpenJump = true;
                float space = this.mR * 2.0f / 5.0f;
                for (int i = 0; i < this.mMusicParams.size(); ++i) {
                    MusicParam musicParam = this.mMusicParams.get(i);
                    if (i % 2 == 0) {
                        musicParam.setOffsetY(animatedValue * space);
                        continue;
                    }
                    musicParam.setOffsetY((1.0f - animatedValue) * space);
                }
                break;
            }
            case 3: {
                this.mOpenJump = true;
                float space = this.mR * 2.0f / 5.0f;
                for (int i = 0; i < this.mMusicParams.size(); ++i) {
                    MusicParam musicParam = this.mMusicParams.get(i);
                    if (i % 2 == 0) {
                        musicParam.setOffsetY((1.0f - animatedValue) * space);
                        continue;
                    }
                    musicParam.setOffsetY(animatedValue * space);
                }
                break;
            }
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        for (Path drawPath : this.mMusicDrawPaths) {
            canvas.drawPath(drawPath, this.mPaint);
        }
        if (this.mOpenJump) {
            this.drawMusic(canvas);
        }
    }

    private void drawMusic(Canvas canvas) {
        for (MusicParam musicParam : this.mMusicParams) {
            this.mPaint.setStrokeWidth(4.0f);
            canvas.save();
            RectF oldCircleRectF = musicParam.getCircleRectF();
            RectF circleRectF = new RectF(oldCircleRectF);
            float offsetY = musicParam.getOffsetY();
            circleRectF.set(oldCircleRectF.left, oldCircleRectF.top - offsetY, oldCircleRectF.right, oldCircleRectF.bottom - offsetY);
            canvas.rotate(75.0f, circleRectF.centerX(), circleRectF.centerY());
            this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            canvas.drawOval(circleRectF, this.mPaint);
            this.mPaint.setStyle(Paint.Style.STROKE);
            canvas.restore();
            PointF startPointF = musicParam.getLineStartPointF();
            PointF endPointF = musicParam.getLineEndPointF();
            canvas.drawLine(startPointF.x, startPointF.y - offsetY, endPointF.x, endPointF.y - offsetY, this.mPaint);
            this.mPaint.setStrokeWidth(2.0f);
        }
    }

    @Override
    protected void prepareStart(ValueAnimator animation) {
        animation.setInterpolator((TimeInterpolator)this.mDecelerateInterpolator);
    }

    @Override
    protected void prepareEnd() {
    }

    private void resetDrawPath() {
        this.mOpenJump = false;
        for (Path path : this.mMusicDrawPaths) {
            path.reset();
            path.lineTo(0.0f, 0.0f);
        }
        for (MusicParam musicParam : this.mMusicParams) {
            musicParam.clear();
        }
    }

    static class MusicParam {
        private final RectF mCircleRectF;
        private final PointF mLineStartPointF;
        private final PointF mLineEndPointF;
        private float mOffsetY = 0.0f;

        MusicParam(RectF rectF, PointF sPointF, PointF ePointF) {
            this.mCircleRectF = rectF;
            this.mLineStartPointF = sPointF;
            this.mLineEndPointF = ePointF;
        }

        RectF getCircleRectF() {
            return this.mCircleRectF;
        }

        PointF getLineStartPointF() {
            return this.mLineStartPointF;
        }

        PointF getLineEndPointF() {
            return this.mLineEndPointF;
        }

        float getOffsetY() {
            return this.mOffsetY;
        }

        void setOffsetY(float v) {
            this.mOffsetY = v;
        }

        void clear() {
            this.mOffsetY = 0.0f;
        }
    }
}

